/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.quartz;

import com.alibaba.fastjson.JSON;
import com.centit.framework.components.OperationLogCenter;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzJob
implements Job {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractQuartzJob.class);

    protected abstract boolean runRealJob(JobExecutionContext var1) throws JobExecutionException;

    protected abstract void loadExecutionContext(JobExecutionContext var1);

    protected void beforeRun(JobExecutionContext context) {
        logger.info("beforeRun");
        JobKey jobKey = context.getJobDetail().getKey();
        OperationLogCenter.log((String)"before", (String)"admin", (String)"U00000", (String)"quartz", (String)"error ", (String)(jobKey.getGroup() + ":" + jobKey.getName()), (String)JSON.toJSONString((Object)context.getMergedJobDataMap()), (String)"", (Object)"", (Object)"");
    }

    protected void onSuccess(JobExecutionContext context) {
        logger.info("onSuccess");
        JobKey jobKey = context.getJobDetail().getKey();
        OperationLogCenter.log((String)"sucess", (String)"admin", (String)"U00000", (String)"quartz", (String)"error ", (String)(jobKey.getGroup() + ":" + jobKey.getName()), (String)JSON.toJSONString((Object)context.getMergedJobDataMap()), (String)"", (Object)"", (Object)"");
    }

    protected void onError(JobExecutionContext context) {
        logger.error("onError");
        JobKey jobKey = context.getJobDetail().getKey();
        OperationLogCenter.log((String)"error", (String)"admin", (String)"U00000", (String)"quartz", (String)"error ", (String)(jobKey.getGroup() + ":" + jobKey.getName()), (String)JSON.toJSONString((Object)context.getMergedJobDataMap()), (String)"", (Object)"", (Object)"");
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.loadExecutionContext(context);
        this.beforeRun(context);
        boolean success = this.runRealJob(context);
        if (success) {
            this.onSuccess(context);
        } else {
            this.onError(context);
        }
    }
}

