/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.quartz;

import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.network.UrlOptUtils;
import com.centit.support.quartz.AbstractQuartzJob;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class HttpRquestJob
extends AbstractQuartzJob {
    private static ConcurrentHashMap<String, AppSession> appSessionPoolMap = new ConcurrentHashMap(10);
    private AppSession appSession;
    private String requestUrl;
    private Map<String, Object> params;
    private String httpMethod;
    private String requstBody;

    private static AppSession fetchAppSession(String url, String userCode, String password) {
        String sUrl = StringUtils.isBlank((CharSequence)url) ? "blank" : url;
        AppSession appSession = appSessionPoolMap.get(sUrl);
        if (appSession == null) {
            appSession = StringUtils.isNotBlank((CharSequence)userCode) ? new AppSession(url, userCode, password) : new AppSession(url);
            appSessionPoolMap.put(sUrl, appSession);
        }
        return appSession;
    }

    @Override
    protected void loadExecutionContext(JobExecutionContext context) {
        JobDataMap paramMap = context.getMergedJobDataMap();
        this.appSession = HttpRquestJob.fetchAppSession(paramMap.getString("osUrl"), paramMap.getString("osUser"), paramMap.getString("osUserPwd"));
        this.requestUrl = paramMap.getString("requestUrl");
        this.httpMethod = paramMap.getString("httpMethod");
        this.requstBody = paramMap.getString("requstBody");
        Object obj = paramMap.get((Object)"params");
        this.params = obj != null ? (Map<Object, Object>)GeneralAlgorithm.castObjectToType((Object)obj, Map.class) : new HashMap<String, Object>(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runRealJob(JobExecutionContext context) throws JobExecutionException {
        CloseableHttpClient httpClient = null;
        boolean ret = true;
        try {
            String retStr;
            httpClient = this.appSession.allocHttpClient();
            this.appSession.checkAccessToken(httpClient);
            switch (this.httpMethod) {
                case "post": {
                    retStr = this.appSession.jsonPost(httpClient, UrlOptUtils.appendParamsToUrl((String)this.requestUrl, this.params), (Object)this.requstBody);
                    break;
                }
                case "put": {
                    retStr = this.appSession.jsonPut(httpClient, UrlOptUtils.appendParamsToUrl((String)this.requestUrl, this.params), (Object)this.requstBody);
                    break;
                }
                case "delete": {
                    retStr = this.appSession.doDelete(httpClient, UrlOptUtils.appendParamsToUrl((String)this.requestUrl, this.params), null);
                    break;
                }
                default: {
                    retStr = this.appSession.simpleGet(httpClient, this.requestUrl, this.params);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)retStr)) {
                HttpReceiveJSON json = HttpReceiveJSON.valueOfJson((String)retStr);
                ret = json.getCode() == 0;
            }
        }
        catch (Exception e) {
            ret = false;
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (this.appSession != null && httpClient != null) {
                this.appSession.releaseHttpClient(httpClient);
            }
        }
        return ret;
    }

    public void setAppSession(AppSession appSession) {
        this.appSession = appSession;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public void setParams(Map<String, Object> requestParams) {
        this.params = requestParams;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setRequstBody(String requstBody) {
        this.requstBody = requstBody;
    }
}

