/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.quartz;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.quartz.AbstractQuartzJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class JavaBeanJob
extends AbstractQuartzJob {
    private Object bean;
    private String beanName;
    private String methodName;
    private Map<String, Object> params;

    @Override
    protected void loadExecutionContext(JobExecutionContext context) {
        JobDataMap paramMap = context.getMergedJobDataMap();
        this.bean = paramMap.get((Object)"bean");
        this.beanName = paramMap.getString("beanName");
        this.methodName = paramMap.getString("methodName");
        Object obj = paramMap.get((Object)"params");
        this.params = obj != null ? (Map<Object, Object>)GeneralAlgorithm.castObjectToType((Object)obj, Map.class) : new HashMap<String, Object>(1);
    }

    @Override
    protected boolean runRealJob(JobExecutionContext context) throws JobExecutionException {
        if (this.bean == null) {
            WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
            this.bean = webApplicationContext.getBean(this.beanName);
        }
        LeftRightPair mp = ReflectionOpt.getMatchBestMethod(this.bean.getClass(), (String)this.methodName, this.params);
        boolean ret = true;
        if (mp.getLeft() != null) {
            try {
                if (mp.getRight() == null) {
                    ((Method)mp.getLeft()).invoke(this.bean, new Object[0]);
                } else {
                    ((Method)mp.getLeft()).invoke(this.bean, (Object[])mp.getRight());
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                ret = false;
            }
        }
        return ret;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

