/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.quartz;

import com.centit.support.quartz.AbstractQuartzJob;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public abstract class QuartzJobUtils {
    private static ConcurrentHashMap<String, Class<? extends AbstractQuartzJob>> jobTypeMap = new ConcurrentHashMap(10);

    public static void registerJobType(String jobType, Class<? extends AbstractQuartzJob> type) {
        jobTypeMap.put(jobType, type);
    }

    public static void createOrReplaceCronJob(Scheduler scheduler, String jobName, String jobGroup, String jobType, String cronExpress, Map<String, Object> param) throws SchedulerException {
        QuartzJobUtils.createOrReplaceCronJob(scheduler, jobName, jobGroup, jobTypeMap.get(jobType), cronExpress, param);
    }

    public static void createOrReplaceCronJob(Scheduler scheduler, String jobName, String jobGroup, Class<? extends Job> jobClass, String cronExpress, Map<String, Object> param) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
        Trigger trigger = scheduler.getTrigger(triggerKey);
        if (trigger == null) {
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroup).usingJobData(new JobDataMap(param)).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpress);
            trigger = TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.scheduleJob(jobDetail, trigger);
        } else {
            if (!(trigger instanceof CronTrigger)) {
                throw new SchedulerException("\u4efb\u52a1\u5b9a\u65f6\u5668\u7c7b\u578b\u4e0d\u80fd\u6539\u53d8\uff01");
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpress);
            trigger = ((CronTrigger)trigger).getTriggerBuilder().withIdentity(triggerKey).usingJobData(new JobDataMap(param)).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.rescheduleJob(triggerKey, trigger);
        }
    }

    public static void createOrReplaceSimpleJob(Scheduler scheduler, String jobName, String jobGroup, String jobType, int intervalInSeconds, Map<String, Object> param) throws SchedulerException {
        QuartzJobUtils.createOrReplaceSimpleJob(scheduler, jobName, jobGroup, jobTypeMap.get(jobType), intervalInSeconds, param);
    }

    public static void createOrReplaceSimpleJob(Scheduler scheduler, String jobName, String jobGroup, Class<? extends Job> jobClass, int intervalInSeconds, Map<String, Object> param) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
        Trigger trigger = scheduler.getTrigger(triggerKey);
        if (trigger == null) {
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroup).usingJobData(new JobDataMap(param)).build();
            trigger = TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(intervalInSeconds).repeatForever()).build();
            scheduler.scheduleJob(jobDetail, trigger);
        } else {
            if (!(trigger instanceof SimpleTrigger)) {
                throw new SchedulerException("\u4efb\u52a1\u5b9a\u65f6\u5668\u7c7b\u578b\u4e0d\u80fd\u6539\u53d8\uff01");
            }
            trigger = ((SimpleTrigger)trigger).getTriggerBuilder().withIdentity(triggerKey).usingJobData(new JobDataMap(param)).startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(intervalInSeconds).repeatForever()).build();
            scheduler.rescheduleJob(triggerKey, trigger);
        }
    }

    public static void deleteJob(Scheduler scheduler, String jobName, String jobGroup) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
        scheduler.pauseTrigger(triggerKey);
        scheduler.unscheduleJob(triggerKey);
        scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroup));
    }
}

