/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.report.ExcelTypeEnum;
import com.centit.support.report.StatReportException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelExportUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);

    private ExcelExportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static void generateExcel(OutputStream outputStream, String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, List<Object[]> objLists, String[] header) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, String sheetName, List<? extends Object> objLists, Class<?> objType) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, List<? extends Object> objLists, Class<?> objType) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, List<Object[]> objLists, String[] header) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, String sheetName, List<? extends Object> objLists, Class<?> objType) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, List<? extends Object> objLists, Class<?> objType) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static void generateExcelSheet(Sheet sheet, List<? extends Object> objLists, Class<?> objType) {
        JavaBeanMetaData metaData = JavaBeanMetaData.createBeanMetaDataFromType(objType);
        Row headerRow = sheet.createRow(0);
        CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
        ArrayList header = new ArrayList(metaData.getFileds().keySet());
        int i = 0;
        for (String headStr : header) {
            Cell cell = headerRow.createCell(i);
            ExcelExportUtil.setCellStyle(cell, cellStyle);
            cell.setCellValue(headStr);
            ++i;
        }
        int row = 1;
        for (Object object : objLists) {
            Row objRow = sheet.createRow(row++);
            i = 0;
            for (String headStr : header) {
                Cell cell = objRow.createCell(i++);
                ExcelExportUtil.setCellStyle(cell, cellStyle);
                cell.setCellValue(StringBaseOpt.objectToString((Object)metaData.getFiled(headStr).getObjectFieldValue(object)));
            }
        }
    }

    public static void generateExcelSheet(Sheet sheet, List<? extends Object> objLists, String[] header, String[] property) {
        int beginRow = 0;
        if (header != null && header.length > 0) {
            ExcelExportUtil.generateExcelHeader(sheet, header);
            ++beginRow;
        }
        try {
            if (property != null && property.length > 0) {
                ExcelExportUtil.generateExcelText(sheet, objLists, property, beginRow);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new StatReportException(e);
        }
    }

    public static void generateExcelSheet(Sheet sheet, List<Object[]> objLists, String[] header) {
        int beginRow = 0;
        if (header != null && header.length > 0) {
            ExcelExportUtil.generateExcelHeader(sheet, header);
            ++beginRow;
        }
        ExcelExportUtil.generateExcelText(sheet, objLists, beginRow);
    }

    private static void generateExcelHeader(Sheet sheet, String[] header) {
        Row headerRow = sheet.createRow(0);
        CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
        for (int i = 0; i < header.length; ++i) {
            Cell cell = headerRow.createCell(i);
            ExcelExportUtil.setCellStyle(cell, cellStyle);
            cell.setCellValue(header[i]);
        }
    }

    private static void generateExcelText(Sheet sheet, List<? extends Object> objLists, String[] property, int beginRow) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        for (int i = 0; i < objLists.size(); ++i) {
            Row textRow = sheet.createRow(i + beginRow);
            for (int j = 0; j < property.length; ++j) {
                if (!StringUtils.isNotBlank((CharSequence)property[j])) continue;
                CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
                Cell cell = textRow.createCell(j);
                JSONObject obj = (JSONObject)JSONObject.toJSON((Object)objLists.get(i));
                String type = obj.get((Object)property[j]) != null ? obj.get((Object)property[j]).getClass().getSimpleName() : "String";
                ExcelExportUtil.setCellStyle(sheet, cell, cellStyle, type);
                ExcelExportUtil.setCellValue(cell, objLists.get(i), property[j], type);
            }
        }
    }

    private static void generateExcelText(Sheet sheet, List<Object[]> objLists, int beginRow) {
        for (int i = 0; i < objLists.size(); ++i) {
            Row textRow = sheet.createRow(i + beginRow);
            CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
            for (int j = 0; j < objLists.get(i).length; ++j) {
                Cell cell = textRow.createCell(j);
                ExcelExportUtil.setCellStyle(cell, cellStyle);
                cell.setCellValue(null == objLists.get(i)[j] ? "" : StringBaseOpt.objectToString((Object)objLists.get(i)[j]));
            }
        }
    }

    private static void setCellStyle(Cell cell, CellStyle cellStyle) {
        cell.setCellType(CellType.STRING);
        cell.setCellStyle(cellStyle);
    }

    private static void setCellStyle(Sheet sheet, Cell cell, CellStyle cellStyle, String type) {
        switch (type) {
            case "int": 
            case "Integer": 
            case "long": 
            case "Long": 
            case "float": 
            case "Float": 
            case "double": 
            case "Double": 
            case "BigDecimal": {
                cell.setCellType(CellType.NUMERIC);
                break;
            }
            case "String": {
                cell.setCellType(CellType.STRING);
                break;
            }
            case "boolean": 
            case "Boolean": {
                cell.setCellType(CellType.BOOLEAN);
                break;
            }
            case "Date": 
            case "Timestamp": {
                cell.setCellType(CellType.NUMERIC);
                DataFormat format = sheet.getWorkbook().createDataFormat();
                cellStyle.setDataFormat(format.getFormat("yyyy-MM-dd"));
                break;
            }
            default: {
                cell.setCellType(CellType.STRING);
            }
        }
        cell.setCellStyle(cellStyle);
    }

    private static void setCellValue(Cell cell, Object obj, String property, String type) {
        switch (type) {
            case "int": 
            case "Integer": {
                cell.setCellValue((double)NumberBaseOpt.castObjectToInteger((Object)ReflectionOpt.attainExpressionValue((Object)obj, (String)property)).intValue());
                break;
            }
            case "long": 
            case "Long": {
                cell.setCellValue((double)NumberBaseOpt.castObjectToLong((Object)ReflectionOpt.attainExpressionValue((Object)obj, (String)property)).longValue());
                break;
            }
            case "float": 
            case "Float": 
            case "double": 
            case "Double": {
                cell.setCellValue(NumberBaseOpt.castObjectToDouble((Object)ReflectionOpt.attainExpressionValue((Object)obj, (String)property)).doubleValue());
                break;
            }
            case "String": {
                cell.setCellValue(StringBaseOpt.objectToString((Object)ReflectionOpt.attainExpressionValue((Object)obj, (String)property)));
                break;
            }
            case "Date": 
            case "Timestamp": {
                cell.setCellValue(DatetimeOpt.castObjectToDate((Object)ReflectionOpt.attainExpressionValue((Object)obj, (String)property)));
                break;
            }
            default: {
                cell.setCellValue(StringBaseOpt.objectToString((Object)ReflectionOpt.attainExpressionValue((Object)obj, (String)property)));
            }
        }
    }

    private static CellStyle getDefaultCellStyle(Workbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static void saveObjectsToExcelSheet(Sheet sheet, List<Object> objects, Map<Integer, String> fieldDesc, int beginRow, boolean createRow) {
        int nRowCount = objects.size();
        CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
        for (int i = 0; i < nRowCount; ++i) {
            Row excelRow = createRow ? sheet.createRow(beginRow + i) : sheet.getRow(beginRow + i);
            Object rowObj = objects.get(i);
            if (rowObj == null || excelRow == null) continue;
            for (Map.Entry<Integer, String> ent : fieldDesc.entrySet()) {
                Cell cell = null;
                if (!createRow) {
                    cell = excelRow.getCell(ent.getKey().intValue());
                }
                if (cell == null) {
                    cell = excelRow.createCell(ent.getKey().intValue());
                    ExcelExportUtil.setCellStyle(cell, cellStyle);
                }
                cell.setCellValue(StringBaseOpt.objectToString((Object)ReflectionOpt.attainExpressionValue((Object)rowObj, (String)ent.getValue())));
            }
        }
    }

    public static void saveObjectsToExcelSheet(Sheet sheet, List<Object[]> objects, int beginCol, int beginRow, boolean createRow) {
        int nRowCount = objects.size();
        CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
        for (int i = 0; i < nRowCount; ++i) {
            Row excelRow = createRow ? sheet.createRow(beginRow + i) : sheet.getRow(beginRow + i);
            Object[] rowObj = objects.get(i);
            if (rowObj == null || excelRow == null) continue;
            for (int j = 0; j < rowObj.length; ++j) {
                Cell cell = null;
                if (!createRow) {
                    cell = excelRow.getCell(beginCol + j);
                }
                if (cell == null) {
                    cell = excelRow.createCell(beginCol + j);
                    ExcelExportUtil.setCellStyle(cell, cellStyle);
                }
                cell.setCellValue(StringBaseOpt.objectToString((Object)rowObj[j]));
            }
        }
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, String sheetName, List<Object> objects, Map<Integer, String> fieldDesc, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (FileInputStream excelFile = new FileInputStream(new File(excelTemplateFilePath));){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
            Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, fieldDesc, beginRow, createRow);
        }
        var10_9 = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            wb.write((OutputStream)newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, int sheetIndex, List<Object> objects, Map<Integer, String> fieldDesc, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (FileInputStream excelFile = new FileInputStream(new File(excelTemplateFilePath));){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
            Sheet sheet = wb.getSheetAt(sheetIndex);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, fieldDesc, beginRow, createRow);
        }
        var10_9 = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            wb.write((OutputStream)newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, String sheetName, List<Object[]> objects, int beginCol, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (FileInputStream excelFile = new FileInputStream(new File(excelTemplateFilePath));){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
            Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, beginCol, beginRow, createRow);
        }
        var10_9 = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            wb.write((OutputStream)newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, int sheetIndex, List<Object[]> objects, int beginCol, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (FileInputStream excelFile = new FileInputStream(new File(excelTemplateFilePath));){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
            Sheet sheet = wb.getSheetAt(sheetIndex);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, beginCol, beginRow, createRow);
        }
        var10_9 = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            wb.write((OutputStream)newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        Throwable throwable;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        HSSFWorkbook wb = null;
        try {
            throwable = null;
            try (FileInputStream excelFile = new FileInputStream(new File(excelFilePath));){
                wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
                Sheet sheet = wb.getSheet(sheetName);
                if (sheet == null) {
                    sheet = wb.createSheet(sheetName);
                    ExcelExportUtil.generateExcelSheet(sheet, objLists, header, property);
                } else {
                    int beginRow = sheet.getLastRowNum() + 1;
                    ExcelExportUtil.generateExcelText(sheet, objLists, property, beginRow);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getLocalizedMessage());
        }
        throwable = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            if (wb != null) {
                wb.write((OutputStream)newExcelFile);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, int sheetIndex, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        Throwable throwable;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        HSSFWorkbook wb = null;
        try {
            throwable = null;
            try (FileInputStream excelFile = new FileInputStream(new File(excelFilePath));){
                wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
                Sheet sheet = wb.getSheetAt(sheetIndex);
                if (sheet == null) {
                    sheet = wb.createSheet();
                    ExcelExportUtil.generateExcelSheet(sheet, objLists, header, property);
                } else {
                    int beginRow = sheet.getLastRowNum() + 1;
                    ExcelExportUtil.generateExcelText(sheet, objLists, property, beginRow);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getLocalizedMessage());
        }
        throwable = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            if (wb != null) {
                wb.write((OutputStream)newExcelFile);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        HSSFWorkbook wb = null;
        try (FileInputStream excelFile = new FileInputStream(new File(excelFilePath));){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
            Sheet sheet = wb.getSheet(sheetName);
            if (sheet == null) {
                sheet = wb.createSheet(sheetName);
                ExcelExportUtil.generateExcelSheet(sheet, objLists, header);
            } else {
                int beginRow = sheet.getLastRowNum() + 1;
                ExcelExportUtil.generateExcelText(sheet, objLists, beginRow);
            }
        }
        var7_7 = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            if (wb != null) {
                wb.write((OutputStream)newExcelFile);
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, int sheetIndex, List<Object[]> objLists, String[] header) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        HSSFWorkbook wb = null;
        try (FileInputStream excelFile = new FileInputStream(new File(excelFilePath));){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook((InputStream)excelFile) : new XSSFWorkbook((InputStream)excelFile);
            Sheet sheet = wb.getSheetAt(sheetIndex);
            if (sheet == null) {
                sheet = wb.createSheet();
                ExcelExportUtil.generateExcelSheet(sheet, objLists, header);
            } else {
                int beginRow = sheet.getLastRowNum() + 1;
                ExcelExportUtil.generateExcelText(sheet, objLists, beginRow);
            }
        }
        var7_7 = null;
        try (FileOutputStream newExcelFile = new FileOutputStream(new File(excelFilePath));){
            if (wb != null) {
                wb.write((OutputStream)newExcelFile);
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }
}

