/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.centit.support.common.JavaBeanField;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.report.ExcelTypeEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelImportUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ExcelImportUtil.class);

    private ExcelImportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    private static void setObjectFieldValue(Object object, JavaBeanField field, Cell cell) {
        switch (field.getFieldJavaType()) {
            case "int": 
            case "Integer": 
            case "long": 
            case "Long": 
            case "float": 
            case "Float": 
            case "double": 
            case "Double": 
            case "BigDecimal": 
            case "BigInteger": {
                if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                    field.setObjectFieldValue(object, (Object)cell.getNumericCellValue());
                    break;
                }
                field.setObjectFieldValue(object, (Object)cell.toString());
                break;
            }
            case "Date": 
            case "sqlDate": 
            case "sqlTimestamp": {
                if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                    field.setObjectFieldValue(object, (Object)cell.getDateCellValue());
                    break;
                }
                field.setObjectFieldValue(object, (Object)cell.toString());
                break;
            }
            case "boolean": 
            case "Boolean": {
                if (cell.getCellTypeEnum() == CellType.BOOLEAN) {
                    field.setObjectFieldValue(object, (Object)cell.getBooleanCellValue());
                    break;
                }
                field.setObjectFieldValue(object, (Object)cell.toString());
                break;
            }
            default: {
                field.setObjectFieldValue(object, (Object)cell.toString());
            }
        }
    }

    private static <T> List<T> loadObjectFromExcelSheet(Sheet sheet, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException {
        if (sheet == null) {
            return null;
        }
        JavaBeanMetaData metaData = JavaBeanMetaData.createBeanMetaDataFromType(beanType);
        ArrayList<T> datas = new ArrayList<T>(endRow - beginRow + 1);
        for (int row = beginRow; row < endRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            boolean i = false;
            T rowObj = beanType.newInstance();
            boolean hasValue = false;
            for (Map.Entry<Integer, String> ent : fieldDesc.entrySet()) {
                Cell cell = excelRow.getCell(ent.getKey().intValue());
                JavaBeanField field = metaData.getFiled(ent.getValue());
                if (cell == null || !StringUtils.isNotBlank((CharSequence)cell.toString())) continue;
                hasValue = true;
                ExcelImportUtil.setObjectFieldValue(rowObj, field, cell);
            }
            if (!hasValue) continue;
            datas.add(rowObj);
        }
        return datas;
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, endRow);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetName, beanType, fieldDesc, beginRow, endRow);
            return list;
        }
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, sheet.getLastRowNum() + 1);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetName, beanType, fieldDesc, beginRow);
            return list;
        }
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, endRow);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetIndex, beanType, fieldDesc, beginRow, endRow);
            return list;
        }
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, sheet.getLastRowNum() + 1);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetIndex, beanType, fieldDesc, beginRow);
            return list;
        }
    }

    private static List<String[]> loadDataFromExcelSheet(Sheet sheet, int[] columnList, int[] rowList) {
        if (sheet == null) {
            return null;
        }
        ArrayList<String[]> datas = new ArrayList<String[]>(rowList.length + 1);
        for (int row : rowList) {
            String[] rowObj = new String[columnList.length];
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) {
                datas.add(null);
                continue;
            }
            int i = 0;
            for (int col : columnList) {
                Cell cell = excelRow.getCell(col);
                rowObj[i++] = cell == null ? null : cell.getStringCellValue();
            }
            datas.add(rowObj);
        }
        return datas;
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int[] columnList, int[] rowList) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, columnList, rowList);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int[] columnList, int[] rowList) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, columnList, rowList);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int[] columnList, int[] rowList) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, columnList, rowList);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int[] columnList, int[] rowList) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, columnList, rowList);
            return list;
        }
    }

    private static List<String[]> loadDataFromExcelSheet(Sheet sheet, int beginCol, int endCol, int beginRow, int endRow) {
        if (sheet == null) {
            return null;
        }
        ArrayList<String[]> datas = new ArrayList<String[]>(endRow - beginRow + 1);
        for (int row = beginRow; row < endRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            int i = 0;
            String[] rowObj = new String[endCol - beginCol + 1];
            boolean hasValue = false;
            for (int col = beginCol; col <= endCol; ++col) {
                Cell cell = excelRow.getCell(col);
                if (cell != null) {
                    rowObj[i] = cell.getStringCellValue();
                    hasValue = true;
                }
                ++i;
            }
            if (!hasValue) continue;
            datas.add(rowObj);
        }
        return datas;
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, endRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, beginCol, endCol, beginRow, endRow);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, endRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, beginCol, endCol, beginRow, endRow);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int beginCol, int endCol, int beginRow) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, sheet.getLastRowNum() + 1);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int beginCol, int endCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, beginCol, endCol, beginRow);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int beginCol, int endCol, int beginRow) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, sheet.getLastRowNum() + 1);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int beginCol, int endCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, beginCol, endCol, beginRow);
            return list;
        }
    }

    private static List<String[]> loadDataFromExcelSheet(Sheet sheet, int beginCol, int beginRow) throws IOException {
        if (sheet == null) {
            return null;
        }
        int maxRow = sheet.getLastRowNum();
        ArrayList<String[]> datas = new ArrayList<String[]>(maxRow - beginRow + 1);
        for (int row = beginRow; row <= maxRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            short endCol = excelRow.getLastCellNum();
            String[] rowObj = new String[endCol - beginCol + 1];
            int i = 0;
            boolean hasValue = false;
            for (int col = beginCol; col <= endCol; ++col) {
                Cell cell = excelRow.getCell(col);
                if (cell != null) {
                    hasValue = true;
                    rowObj[i] = cell.getStringCellValue();
                }
                ++i;
            }
            if (!hasValue) continue;
            datas.add(rowObj);
        }
        return datas;
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int beginCol, int beginRow) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, beginRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int beginCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, beginCol, beginRow);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int beginCol, int beginRow) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, beginRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int beginCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, beginCol, beginRow);
            return list;
        }
    }
}

