/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.report.JsonDocxContext;
import com.centit.support.report.SmartDocxContext;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WordReportUtil {
    protected static final Logger logger = LoggerFactory.getLogger(WordReportUtil.class);

    private WordReportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static void convertDocxToPdf(String docxFilePath, String pdfFilePath) throws Exception {
        XWPFDocument document = new XWPFDocument((InputStream)new FileInputStream(new File(docxFilePath)));
        File outFile = new File(pdfFilePath);
        outFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(outFile);
        PdfOptions options = PdfOptions.create();
        PdfConverter.getInstance().convert(document, (OutputStream)out, (Options)options);
    }

    private static void innerReportDocxWithFreemarker(Object params, String templateName, String outputFileName, int contentType) {
        try (FileInputStream in = new FileInputStream(new File(templateName));){
            IXDocReport report = XDocReportRegistry.getRegistry().loadReport((InputStream)in, TemplateEngineKind.Freemarker, false);
            IContext context = WordReportUtil.getReportContext(report, params, contentType);
            File outputFile = new File(outputFileName);
            File parentFile = outputFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (outputFile.exists()) {
                outputFile.renameTo(new File(outputFileName + "." + new Date().getTime()));
            }
            try (FileOutputStream outputStream = new FileOutputStream(outputFileName);){
                report.process(context, (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            logger.warn("\u6587\u4ef6\u6d41\u83b7\u53d6\u5931\u8d25", (Throwable)e);
        }
        catch (XDocReportException e) {
            logger.warn("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }

    private static IContext getReportContext(IXDocReport report, Object object, int contentType) throws XDocReportException {
        switch (contentType) {
            case 1: {
                IContext context = report.createContext();
                FieldsMetadata metadata = new FieldsMetadata();
                Map params = object instanceof Map ? (Map)object : (JSONObject)JSON.toJSON((Object)object);
                for (Map.Entry entry : params.entrySet()) {
                    context.put((String)entry.getKey(), GeneralAlgorithm.nvl(entry.getValue(), (Object)""));
                }
                report.setFieldsMetadata(metadata);
                return context;
            }
            case 2: {
                return new JsonDocxContext(object);
            }
        }
        return new SmartDocxContext(object);
    }

    public static void reportDocxWithFreemarker(Object params, String templateName, String outputFileName) {
        WordReportUtil.innerReportDocxWithFreemarker(params, templateName, outputFileName, 2);
    }

    public static void reportListDocxWithFreemarker(Object params, String templateName, String outputFileName) {
        WordReportUtil.innerReportDocxWithFreemarker(params, templateName, outputFileName, 1);
    }

    public static void reportSmartDocxWithFreemarker(Object params, String templateName, String outputFileName) {
        WordReportUtil.innerReportDocxWithFreemarker(params, templateName, outputFileName, 3);
    }
}

