/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.report.ExcelImportUtil;
import com.centit.support.report.ExcelTypeEnum;
import com.centit.support.report.StatReportException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelExportUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);

    private ExcelExportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static void generateExcel(OutputStream outputStream, String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, List<Object[]> objLists, String[] header) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, String sheetName, List<? extends Object> objLists, Class<?> objType) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static void generateExcel(OutputStream outputStream, List<? extends Object> objLists, Class<?> objType) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header, property);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, List<Object[]> objLists, String[] header) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, header);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, String sheetName, List<? extends Object> objLists, Class<?> objType) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static void generateExcel2003(OutputStream outputStream, List<? extends Object> objLists, Class<?> objType) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        ExcelExportUtil.generateExcelSheet((Sheet)sheet, objLists, objType);
        wb.write(outputStream);
    }

    public static InputStream generateExcelStream(String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel(bout, sheetName, objLists, header, property);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcelStream(List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel((OutputStream)bout, objLists, header, property);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcelStream(String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel((OutputStream)bout, sheetName, objLists, header);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcelStream(List<Object[]> objLists, String[] header) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel((OutputStream)bout, objLists, header);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcelStream(String sheetName, List<? extends Object> objLists, Class<?> objType) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel((OutputStream)bout, sheetName, objLists, objType);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcelStream(List<? extends Object> objLists, Class<?> objType) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel((OutputStream)bout, objLists, objType);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcel2003Stream(String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel2003(bout, sheetName, objLists, header, property);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcel2003Stream(List<? extends Object> objLists, String[] header, String[] property) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel2003((OutputStream)bout, objLists, header, property);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcel2003Stream(String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel2003((OutputStream)bout, sheetName, objLists, header);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcel2003Stream(List<Object[]> objLists, String[] header) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel2003((OutputStream)bout, objLists, header);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcel2003Stream(String sheetName, List<? extends Object> objLists, Class<?> objType) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel2003((OutputStream)bout, sheetName, objLists, objType);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static InputStream generateExcel2003Stream(List<? extends Object> objLists, Class<?> objType) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            ExcelExportUtil.generateExcel2003((OutputStream)bout, objLists, objType);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static void generateExcelSheet(Sheet sheet, List<? extends Object> objLists, Class<?> objType) {
        JavaBeanMetaData metaData = JavaBeanMetaData.createBeanMetaDataFromType(objType);
        Row headerRow = sheet.createRow(0);
        CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
        ArrayList header = new ArrayList(metaData.getFileds().keySet());
        int i = 0;
        for (String headStr : header) {
            Cell cell = headerRow.createCell(i);
            ExcelExportUtil.setCellStyle(cell, cellStyle);
            cell.setCellValue(headStr);
            ++i;
        }
        int row = 1;
        for (Object object : objLists) {
            Row objRow = sheet.createRow(row++);
            i = 0;
            for (String headStr : header) {
                Cell cell = objRow.createCell(i++);
                ExcelExportUtil.setCellStyle(cell, cellStyle);
                cell.setCellValue(StringBaseOpt.objectToString((Object)metaData.getFiled(headStr).getObjectFieldValue(object)));
            }
        }
    }

    public static void generateExcelSheet(Sheet sheet, List<? extends Object> objLists, String[] header, String[] property) {
        int beginRow = 0;
        if (header != null && header.length > 0) {
            ExcelExportUtil.generateExcelHeader(sheet, header);
            ++beginRow;
        }
        try {
            if (property != null && property.length > 0) {
                ExcelExportUtil.generateExcelText(sheet, objLists, property, beginRow);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new StatReportException(e);
        }
    }

    public static void generateExcelSheet(Sheet sheet, List<Object[]> objLists, String[] header) {
        int beginRow = 0;
        if (header != null && header.length > 0) {
            ExcelExportUtil.generateExcelHeader(sheet, header);
            ++beginRow;
        }
        ExcelExportUtil.generateExcelText(sheet, objLists, beginRow);
    }

    private static void generateExcelHeader(Sheet sheet, String[] header) {
        Row headerRow = sheet.createRow(0);
        CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
        for (int i = 0; i < header.length; ++i) {
            Cell cell = headerRow.createCell(i);
            ExcelExportUtil.setCellStyle(cell, cellStyle);
            cell.setCellValue(header[i]);
        }
    }

    private static void generateExcelText(Sheet sheet, List<? extends Object> objLists, String[] property, int beginRow) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
        for (int i = 0; i < objLists.size(); ++i) {
            Row textRow = sheet.createRow(i + beginRow);
            JSONObject obj = JSONObject.from((Object)objLists.get(i));
            for (int j = 0; j < property.length; ++j) {
                if (!StringUtils.isNotBlank((CharSequence)property[j])) continue;
                Cell cell = textRow.createCell(j);
                Object objectValue = obj.get(property[j]);
                String type = objectValue != null ? objectValue.getClass().getSimpleName() : "String";
                ExcelExportUtil.setCellStyle(sheet, cell, cellStyle, type);
                ExcelExportUtil.setCellValue(cell, objectValue, type);
            }
        }
    }

    private static void generateExcelText(Sheet sheet, List<Object[]> objLists, int beginRow) {
        for (int i = 0; i < objLists.size(); ++i) {
            Row textRow = sheet.createRow(i + beginRow);
            CellStyle cellStyle = ExcelExportUtil.getDefaultCellStyle(sheet.getWorkbook());
            for (int j = 0; j < objLists.get(i).length; ++j) {
                Cell cell = textRow.createCell(j);
                ExcelExportUtil.setCellStyle(cell, cellStyle);
                cell.setCellValue(null == objLists.get(i)[j] ? "" : StringBaseOpt.objectToString((Object)objLists.get(i)[j]));
            }
        }
    }

    private static void setCellStyle(Cell cell, CellStyle cellStyle) {
        cell.setCellType(CellType.STRING);
        cell.setCellStyle(cellStyle);
    }

    private static void setCellStyle(Sheet sheet, Cell cell, CellStyle cellStyle, String type) {
        switch (type) {
            case "int": 
            case "Integer": 
            case "long": 
            case "Long": 
            case "float": 
            case "Float": 
            case "double": 
            case "Double": 
            case "BigDecimal": {
                cell.setCellType(CellType.NUMERIC);
                break;
            }
            case "String": {
                cell.setCellType(CellType.STRING);
                break;
            }
            case "boolean": 
            case "Boolean": {
                cell.setCellType(CellType.BOOLEAN);
                break;
            }
            case "Date": 
            case "Timestamp": {
                cell.setCellType(CellType.NUMERIC);
                DataFormat format = sheet.getWorkbook().createDataFormat();
                cellStyle.setDataFormat(format.getFormat("yyyy-MM-dd"));
                break;
            }
            default: {
                cell.setCellType(CellType.STRING);
            }
        }
        cell.setCellStyle(cellStyle);
    }

    private static void setCellValue(Cell cell, Object obj, String type) {
        switch (type) {
            case "int": 
            case "Integer": {
                cell.setCellValue((double)NumberBaseOpt.castObjectToInteger((Object)obj).intValue());
                break;
            }
            case "long": 
            case "Long": {
                cell.setCellValue((double)NumberBaseOpt.castObjectToLong((Object)obj).longValue());
                break;
            }
            case "float": 
            case "Float": 
            case "double": 
            case "Double": {
                cell.setCellValue(NumberBaseOpt.castObjectToDouble((Object)obj).doubleValue());
                break;
            }
            case "String": {
                cell.setCellValue(StringBaseOpt.objectToString((Object)obj));
                break;
            }
            case "Date": 
            case "Timestamp": {
                cell.setCellValue(DatetimeOpt.castObjectToDate((Object)obj));
                break;
            }
            default: {
                cell.setCellValue(StringBaseOpt.objectToString((Object)obj));
            }
        }
    }

    private static CellStyle getDefaultCellStyle(Workbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        return cellStyle;
    }

    private static void createNewRowsForSaveData(Sheet sheet, int beginRow, int nRowCount) {
        Row excelRow = sheet.getRow(beginRow);
        if (excelRow == null) {
            for (int i = 0; i < nRowCount; ++i) {
                Row toRow = sheet.getRow(beginRow + i);
                if (toRow != null) continue;
                sheet.createRow(beginRow + i);
            }
            return;
        }
        int nColCount = excelRow.getLastCellNum() + 1;
        int lastRow = sheet.getLastRowNum();
        if (beginRow < lastRow && nRowCount > 1) {
            sheet.shiftRows(beginRow + 1, lastRow, nRowCount - 1, true, false);
        }
        for (int i = 1; i < nRowCount; ++i) {
            ExcelExportUtil.copyRow(sheet.getWorkbook(), sheet, beginRow, beginRow + i, 1, nColCount);
        }
    }

    private static void mergeColCell(Sheet sheet, int mergeColCell, int beginRow, int endRow) {
        for (int i = 0; i < mergeColCell; ++i) {
            String preCellText = "";
            int preBeginRow = beginRow;
            for (int j = beginRow; j < endRow; ++j) {
                String cellText = ExcelImportUtil.getCellString(ExcelImportUtil.getCell(sheet, j, i));
                if (StringUtils.equals((CharSequence)cellText, (CharSequence)preCellText)) continue;
                int mergeEndRow = j - 1;
                if (mergeEndRow > preBeginRow) {
                    Cell currentCell = ExcelImportUtil.getCell(sheet, preBeginRow, i);
                    CellStyle style = currentCell.getCellStyle();
                    sheet.addMergedRegion(new CellRangeAddress(preBeginRow, mergeEndRow, i, i));
                    Cell newCell = ExcelImportUtil.getCell(sheet, preBeginRow, i);
                    newCell.setCellStyle(style);
                    newCell.setCellValue(preCellText);
                }
                preCellText = cellText;
                preBeginRow = j;
            }
            if (endRow - 1 <= preBeginRow) continue;
            sheet.addMergedRegion(new CellRangeAddress(preBeginRow, endRow - 1, i, i));
            Cell newCell = ExcelImportUtil.getCell(sheet, preBeginRow, i);
            newCell.setCellValue(preCellText);
        }
    }

    public static void setCellValue(Cell cell, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setCellValue(StringBaseOpt.castObjectToString((Object)value));
        }
    }

    public static void saveObjectsToExcelSheet(Sheet sheet, List<? extends Object> objects, Map<Integer, String> fieldDesc, int beginRow, boolean createRow, int mergeColCell) {
        int nRowCount = objects.size();
        if (createRow) {
            ExcelExportUtil.createNewRowsForSaveData(sheet, beginRow, nRowCount);
        }
        for (int i = 0; i < nRowCount; ++i) {
            Row excelRow = sheet.getRow(beginRow + i);
            Object rowObj = objects.get(i);
            if (rowObj == null || excelRow == null) continue;
            for (Map.Entry<Integer, String> ent : fieldDesc.entrySet()) {
                Cell cell = excelRow.getCell(ent.getKey().intValue());
                if (cell == null) {
                    cell = excelRow.createCell(ent.getKey().intValue());
                }
                ExcelExportUtil.setCellValue(cell, ReflectionOpt.attainExpressionValue((Object)rowObj, (String)ent.getValue()));
            }
        }
        ExcelExportUtil.mergeColCell(sheet, mergeColCell, beginRow, beginRow + nRowCount);
    }

    public static void saveObjectsToExcelSheet(Sheet sheet, List<Object[]> objects, int beginCol, int beginRow, boolean createRow, int mergeColCell) {
        int nRowCount = objects.size();
        if (createRow) {
            ExcelExportUtil.createNewRowsForSaveData(sheet, beginRow, nRowCount);
        }
        for (int i = 0; i < nRowCount; ++i) {
            Row excelRow = sheet.getRow(beginRow + i);
            Object[] rowObj = objects.get(i);
            if (rowObj == null || excelRow == null) continue;
            for (int j = 0; j < rowObj.length; ++j) {
                Cell cell = null;
                if (!createRow) {
                    cell = excelRow.getCell(beginCol + j);
                }
                if (cell == null) {
                    cell = excelRow.createCell(beginCol + j);
                }
                ExcelExportUtil.setCellValue(cell, rowObj[j]);
            }
        }
        ExcelExportUtil.mergeColCell(sheet, mergeColCell, beginRow, beginRow + nRowCount);
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, String sheetName, List<? extends Object> objects, Map<Integer, String> fieldDesc, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (InputStream excelFile = Files.newInputStream(new File(excelTemplateFilePath).toPath(), new OpenOption[0]);){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, fieldDesc, beginRow, createRow, -1);
        }
        var10_9 = null;
        try (OutputStream newExcelFile = Files.newOutputStream(new File(excelFilePath).toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, int sheetIndex, List<? extends Object> objects, Map<Integer, String> fieldDesc, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (InputStream excelFile = Files.newInputStream(new File(excelTemplateFilePath).toPath(), new OpenOption[0]);){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            Sheet sheet = wb.getSheetAt(sheetIndex);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, fieldDesc, beginRow, createRow, -1);
        }
        var10_9 = null;
        try (OutputStream newExcelFile = Files.newOutputStream(new File(excelFilePath).toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, String sheetName, List<Object[]> objects, int beginCol, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (InputStream excelFile = Files.newInputStream(new File(excelTemplateFilePath).toPath(), new OpenOption[0]);){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            Sheet sheet = StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, beginCol, beginRow, createRow, -1);
        }
        var10_9 = null;
        try (OutputStream newExcelFile = Files.newOutputStream(new File(excelFilePath).toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void generateExcelByTemplate(String excelTemplateFilePath, String excelFilePath, int sheetIndex, List<Object[]> objects, int beginCol, int beginRow, boolean createRow) throws IOException {
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelTemplateFilePath);
        try (InputStream excelFile = Files.newInputStream(new File(excelTemplateFilePath).toPath(), new OpenOption[0]);){
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            Sheet sheet = wb.getSheetAt(sheetIndex);
            ExcelExportUtil.saveObjectsToExcelSheet(sheet, objects, beginCol, beginRow, createRow, -1);
        }
        var10_9 = null;
        try (OutputStream newExcelFile = Files.newOutputStream(new File(excelFilePath).toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, String sheetName, List<? extends Object> objLists, String[] header, String[] property) throws IOException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException {
        Sheet sheet;
        Object wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        File file = new File(excelFilePath);
        if (file.exists()) {
            InputStream excelFile = Files.newInputStream(file.toPath(), new OpenOption[0]);
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            sheet = wb.getSheet(sheetName);
            if (sheet == null) {
                sheet = wb.createSheet(sheetName);
            }
        } else {
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook() : new XSSFWorkbook();
            sheet = wb.createSheet(sheetName);
        }
        if (sheet.getLastRowNum() == 0) {
            ExcelExportUtil.generateExcelSheet(sheet, objLists, header, property);
        } else {
            int beginRow = sheet.getLastRowNum() + 1;
            ExcelExportUtil.generateExcelText(sheet, objLists, property, beginRow);
        }
        try (OutputStream newExcelFile = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, int sheetIndex, List<? extends Object> objLists, String[] header, String[] property) throws IOException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException {
        Sheet sheet;
        Object wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        File file = new File(excelFilePath);
        if (file.exists()) {
            InputStream excelFile = Files.newInputStream(file.toPath(), new OpenOption[0]);
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            sheet = wb.getSheetAt(sheetIndex);
            if (sheet == null) {
                sheet = wb.createSheet(String.valueOf(sheetIndex));
            }
        } else {
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook() : new XSSFWorkbook();
            sheet = wb.createSheet();
        }
        if (sheet.getLastRowNum() == 0) {
            ExcelExportUtil.generateExcelSheet(sheet, objLists, header, property);
        } else {
            int beginRow = sheet.getLastRowNum() + 1;
            ExcelExportUtil.generateExcelText(sheet, objLists, property, beginRow);
        }
        try (OutputStream newExcelFile = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, String sheetName, List<Object[]> objLists, String[] header) throws IOException {
        Sheet sheet;
        Object wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        File file = new File(excelFilePath);
        if (file.exists()) {
            InputStream excelFile = Files.newInputStream(file.toPath(), new OpenOption[0]);
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            sheet = wb.getSheet(sheetName);
            if (sheet == null) {
                sheet = wb.createSheet(sheetName);
            }
        } else {
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook() : new XSSFWorkbook();
            sheet = wb.createSheet(sheetName);
        }
        if (sheet.getLastRowNum() == 0) {
            ExcelExportUtil.generateExcelSheet(sheet, objLists, header);
        } else {
            int beginRow = sheet.getLastRowNum() + 1;
            ExcelExportUtil.generateExcelText(sheet, objLists, beginRow);
        }
        try (OutputStream newExcelFile = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
    }

    public static void appendDataToExcelSheet(String excelFilePath, int sheetIndex, List<Object[]> objLists, String[] header) throws IOException {
        Sheet sheet;
        HSSFWorkbook wb;
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(excelFilePath);
        File file = new File(excelFilePath);
        if (file.exists()) {
            InputStream excelFile = Files.newInputStream(file.toPath(), new OpenOption[0]);
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
            sheet = wb.getSheetAt(sheetIndex);
        } else {
            wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook() : new XSSFWorkbook();
            sheet = wb.createSheet();
        }
        if (sheet.getLastRowNum() == 0) {
            ExcelExportUtil.generateExcelSheet(sheet, objLists, header);
        } else {
            int beginRow = sheet.getLastRowNum() + 1;
            ExcelExportUtil.generateExcelText(sheet, objLists, beginRow);
        }
        try (OutputStream newExcelFile = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            wb.write(newExcelFile);
        }
    }

    public static void copyRow(Workbook workbook, Sheet sheet, int fromRowIndex, int toRowIndex, int copyRowNum, Integer colNum) {
        for (int i = 0; i < copyRowNum; ++i) {
            Row fromRow = sheet.getRow(fromRowIndex + i);
            Row toRow = sheet.getRow(toRowIndex + i);
            if (toRow == null) {
                toRow = sheet.createRow(toRowIndex + i);
            }
            for (int colIndex = 0; colIndex < (colNum != null ? colNum : fromRow.getLastCellNum() + 1); ++colIndex) {
                Cell tmpCell = fromRow.getCell(colIndex);
                if (tmpCell == null) {
                    tmpCell = fromRow.createCell(colIndex);
                    ExcelExportUtil.copyCell(workbook, fromRow.createCell(colIndex), tmpCell);
                }
                Cell newCell = toRow.createCell(colIndex);
                ExcelExportUtil.copyCell(workbook, tmpCell, newCell);
            }
        }
    }

    public static void copyCell(Workbook workbook, Cell srcCell, Cell distCell) {
        distCell.setCellStyle(srcCell.getCellStyle());
        CellType srcCellType = srcCell.getCellType();
        distCell.setCellType(srcCellType);
        if (srcCellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)srcCell)) {
                distCell.setCellValue(srcCell.getDateCellValue());
            } else {
                distCell.setCellValue(srcCell.getNumericCellValue());
            }
        } else if (srcCellType == CellType.STRING) {
            distCell.setCellValue(srcCell.getRichStringCellValue());
        } else if (srcCellType == CellType.BOOLEAN) {
            distCell.setCellValue(srcCell.getBooleanCellValue());
        } else if (srcCellType == CellType.ERROR) {
            distCell.setCellErrorValue(srcCell.getErrorCellValue());
        } else if (srcCellType == CellType.FORMULA) {
            distCell.setCellFormula(srcCell.getCellFormula());
        }
    }

    public static void copyCellStyle(CellStyle fromStyle, CellStyle toStyle, Workbook workbook) {
        toStyle.setAlignment(fromStyle.getAlignment());
        toStyle.setVerticalAlignment(fromStyle.getVerticalAlignment());
        toStyle.setBorderBottom(fromStyle.getBorderBottom());
        toStyle.setBorderLeft(fromStyle.getBorderLeft());
        toStyle.setBorderRight(fromStyle.getBorderRight());
        toStyle.setBorderTop(fromStyle.getBorderTop());
        toStyle.setTopBorderColor(fromStyle.getTopBorderColor());
        toStyle.setBottomBorderColor(fromStyle.getBottomBorderColor());
        toStyle.setRightBorderColor(fromStyle.getRightBorderColor());
        toStyle.setLeftBorderColor(fromStyle.getLeftBorderColor());
        if (fromStyle instanceof XSSFCellStyle) {
            XSSFCellStyle xssfToStyle = (XSSFCellStyle)toStyle;
            xssfToStyle.setFillBackgroundColor(((XSSFCellStyle)fromStyle).getFillBackgroundColorColor());
            xssfToStyle.setFillForegroundColor(((XSSFCellStyle)fromStyle).getFillForegroundColorColor());
        } else {
            toStyle.setFillBackgroundColor(fromStyle.getFillBackgroundColor());
            toStyle.setFillForegroundColor(fromStyle.getFillForegroundColor());
        }
        toStyle.setDataFormat(fromStyle.getDataFormat());
        toStyle.setFillPattern(fromStyle.getFillPattern());
        if (fromStyle instanceof XSSFCellStyle) {
            toStyle.setFont((Font)((XSSFCellStyle)fromStyle).getFont());
        } else if (fromStyle instanceof HSSFCellStyle) {
            toStyle.setFont((Font)((HSSFCellStyle)fromStyle).getFont(workbook));
        }
        toStyle.setHidden(fromStyle.getHidden());
        toStyle.setIndention(fromStyle.getIndention());
        toStyle.setLocked(fromStyle.getLocked());
        toStyle.setRotation(fromStyle.getRotation());
        toStyle.setWrapText(fromStyle.getWrapText());
    }
}

