/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.JavaBeanField;
import com.centit.support.common.JavaBeanMetaData;
import com.centit.support.common.LeftRightPair;
import com.centit.support.report.ExcelTypeEnum;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelImportUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ExcelImportUtil.class);

    private ExcelImportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static void setObjectFieldValue(Object object, JavaBeanField field, Cell cell) {
        switch (field.getFieldJavaTypeShortName()) {
            case "int": 
            case "Integer": 
            case "long": 
            case "Long": 
            case "float": 
            case "Float": 
            case "double": 
            case "Double": 
            case "BigDecimal": 
            case "BigInteger": {
                if (cell.getCellType() == CellType.NUMERIC) {
                    field.setObjectFieldValue(object, (Object)cell.getNumericCellValue());
                    break;
                }
                field.setObjectFieldValue(object, (Object)ExcelImportUtil.getCellString(cell));
                break;
            }
            case "Date": 
            case "sqlDate": 
            case "sqlTimestamp": {
                if (cell.getCellType() == CellType.NUMERIC) {
                    field.setObjectFieldValue(object, (Object)cell.getDateCellValue());
                    break;
                }
                field.setObjectFieldValue(object, (Object)ExcelImportUtil.getCellString(cell));
                break;
            }
            case "boolean": 
            case "Boolean": {
                if (cell.getCellType() == CellType.BOOLEAN) {
                    field.setObjectFieldValue(object, (Object)cell.getBooleanCellValue());
                    break;
                }
                field.setObjectFieldValue(object, (Object)ExcelImportUtil.getCellString(cell));
                break;
            }
            default: {
                field.setObjectFieldValue(object, (Object)ExcelImportUtil.getCellString(cell));
            }
        }
    }

    public static int mapColumnIndex(String column) {
        if (StringRegularOpt.isDigit((String)column)) {
            return NumberBaseOpt.castObjectToInteger((Object)column);
        }
        char[] chars = column.toUpperCase().toCharArray();
        int index = 0;
        for (int i = 0; i < chars.length; ++i) {
            index = index * 26 + column.charAt(i) - 65 + 1;
        }
        return index - 1;
    }

    public static String mapIndexColumn(int ind) {
        int index = ind + 1;
        String column = "";
        while (index > 0) {
            int i = index % 26;
            if (i == 0) {
                column = 'Z' + column;
                index = index / 26 - 1;
                continue;
            }
            column = (char)(64 + i) + column;
            index /= 26;
        }
        return column;
    }

    public static Map<Integer, String> mapColumnIndex(Map<String, String> fieldDesc) {
        HashMap<Integer, String> fieldIndexDesc = new HashMap<Integer, String>(fieldDesc.size() + 4);
        for (Map.Entry<String, String> ent : fieldDesc.entrySet()) {
            fieldIndexDesc.put(ExcelImportUtil.mapColumnIndex(ent.getKey()), ent.getValue());
        }
        return fieldIndexDesc;
    }

    public static Object getCellValue(Cell cell) {
        Object value;
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = cell.getCachedFormulaResultType();
        }
        switch (cellType) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    String dataFormat = cell.getCellStyle().getDataFormatString();
                    if (StringUtils.containsIgnoreCase((CharSequence)dataFormat, (CharSequence)"yy")) {
                        value = cell.getDateCellValue();
                        break;
                    }
                    value = DatetimeOpt.convertTimeWithSecondToString((Date)cell.getDateCellValue());
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public static Cell getCell(Sheet sheet, int row, int col) {
        Row sheetRow = sheet.getRow(row);
        if (sheetRow == null) {
            return null;
        }
        return sheetRow.getCell(col);
    }

    public static String getCellString(Cell cell) {
        String value;
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = cell.getCachedFormulaResultType();
        }
        switch (cellType) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    String dataFormat = cell.getCellStyle().getDataFormatString();
                    if (StringUtils.containsIgnoreCase((CharSequence)dataFormat, (CharSequence)"yy")) {
                        value = DatetimeOpt.convertTimestampToString((Date)cell.getDateCellValue());
                        break;
                    }
                    value = DatetimeOpt.convertTimeWithSecondToString((Date)cell.getDateCellValue());
                    break;
                }
                value = StringBaseOpt.castObjectToString((Object)cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue() ? "true" : "false";
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().getString().trim();
                break;
            }
            case ERROR: {
                return ErrorEval.getText((int)cell.getErrorCellValue());
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    private static <T> List<T> loadObjectFromExcelSheet(Sheet sheet, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException {
        if (sheet == null) {
            return null;
        }
        JavaBeanMetaData metaData = JavaBeanMetaData.createBeanMetaDataFromType(beanType);
        ArrayList<T> datas = new ArrayList<T>(endRow - beginRow + 1);
        for (int row = beginRow; row < endRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            boolean i = false;
            T rowObj = beanType.newInstance();
            boolean hasValue = false;
            for (Map.Entry<Integer, String> ent : fieldDesc.entrySet()) {
                Cell cell = excelRow.getCell(ent.getKey().intValue());
                JavaBeanField field = metaData.getFiled(ent.getValue());
                if (cell == null || !StringUtils.isNotBlank((CharSequence)ExcelImportUtil.getCellString(cell))) continue;
                hasValue = true;
                ExcelImportUtil.setObjectFieldValue(rowObj, field, cell);
            }
            if (!hasValue) continue;
            datas.add(rowObj);
        }
        return datas;
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, endRow);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetName, beanType, fieldDesc, beginRow, endRow);
            return list;
        }
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, sheet.getLastRowNum() + 1);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, String sheetName, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetName, beanType, fieldDesc, beginRow);
            return list;
        }
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetIndex);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, endRow);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetIndex, beanType, fieldDesc, beginRow, endRow);
            return list;
        }
    }

    public static <T> List<T> loadObjectFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadObjectFromExcelSheet(sheet, beanType, fieldDesc, beginRow, sheet.getLastRowNum() + 1);
    }

    public static <T> List<T> loadObjectFromExcel(String filePath, int sheetIndex, Class<T> beanType, Map<Integer, String> fieldDesc, int beginRow) throws IllegalAccessException, InstantiationException, IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<T> list = ExcelImportUtil.loadObjectFromExcel((InputStream)excelFile, excelType, sheetIndex, beanType, fieldDesc, beginRow);
            return list;
        }
    }

    private static List<String[]> loadDataFromExcelSheet(Sheet sheet, int[] columnList, int[] rowList) {
        if (sheet == null) {
            return null;
        }
        ArrayList<String[]> datas = new ArrayList<String[]>(rowList.length + 1);
        for (int row : rowList) {
            String[] rowObj = new String[columnList.length];
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) {
                datas.add(null);
                continue;
            }
            int i = 0;
            for (int col : columnList) {
                Cell cell = excelRow.getCell(col);
                rowObj[i++] = cell == null ? null : ExcelImportUtil.getCellString(cell);
            }
            datas.add(rowObj);
        }
        return datas;
    }

    private static Sheet loadExcelFileSheet(InputStream excelFile, String sheetName) throws IOException {
        Workbook wb = WorkbookFactory.create((InputStream)excelFile);
        return StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
    }

    private static Sheet loadExcelFileSheet(InputStream excelFile, int sheetIndex) throws IOException {
        Workbook wb = WorkbookFactory.create((InputStream)excelFile);
        return wb.getSheetAt(sheetIndex);
    }

    private static Sheet loadExcelFileSheet(InputStream excelFile, ExcelTypeEnum excelType, String sheetName) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        return StringUtils.isBlank((CharSequence)sheetName) ? wb.getSheetAt(0) : wb.getSheet(sheetName);
    }

    private static Sheet loadExcelFileSheet(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        return wb.getSheetAt(sheetIndex);
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int[] columnList, int[] rowList) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, columnList, rowList);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int[] columnList, int[] rowList) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, columnList, rowList);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int[] columnList, int[] rowList) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, columnList, rowList);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int[] columnList, int[] rowList) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, columnList, rowList);
            return list;
        }
    }

    private static List<String[]> loadDataFromExcelSheet(Sheet sheet, int beginCol, int endCol, int beginRow, int endRow) {
        if (sheet == null) {
            return null;
        }
        ArrayList<String[]> datas = new ArrayList<String[]>(endRow - beginRow + 1);
        for (int row = beginRow; row < endRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            int i = 0;
            String[] rowObj = new String[endCol - beginCol + 1];
            boolean hasValue = false;
            for (int col = beginCol; col <= endCol; ++col) {
                Cell cell = excelRow.getCell(col);
                if (cell != null) {
                    rowObj[i] = ExcelImportUtil.getCellString(cell);
                    hasValue = true;
                }
                ++i;
            }
            if (!hasValue) continue;
            datas.add(rowObj);
        }
        return datas;
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, endRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, beginCol, endCol, beginRow, endRow);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, endRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int beginCol, int endCol, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, beginCol, endCol, beginRow, endRow);
            return list;
        }
    }

    public static LeftRightPair<ExcelTypeEnum, InputStream> checkExcelInputStreamType(InputStream input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        byte[] headerBuf = new byte[1024];
        int len = input.read(headerBuf);
        if (len > 0) {
            baos.write(headerBuf, 0, len);
        }
        do {
            if ((len = input.read(buffer)) <= 0) continue;
            baos.write(buffer, 0, len);
        } while (len > -1);
        baos.flush();
        return new LeftRightPair((Object)ExcelTypeEnum.checkFileExcelType(headerBuf), (Object)new ByteArrayInputStream(baos.toByteArray()));
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int beginCol, int endCol, int beginRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, sheet.getLastRowNum() + 1);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int beginCol, int endCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, beginCol, endCol, beginRow);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int beginCol, int endCol, int beginRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, endCol, beginRow, sheet.getLastRowNum() + 1);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int beginCol, int endCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, beginCol, endCol, beginRow);
            return list;
        }
    }

    private static List<String[]> loadDataFromExcelSheet(Sheet sheet, int beginCol, int beginRow) throws IOException {
        if (sheet == null) {
            return null;
        }
        int maxRow = sheet.getLastRowNum();
        ArrayList<String[]> datas = new ArrayList<String[]>(maxRow - beginRow + 1);
        for (int row = beginRow; row <= maxRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            short endCol = excelRow.getLastCellNum();
            String[] rowObj = new String[endCol - beginCol + 1];
            int i = 0;
            boolean hasValue = false;
            for (int col = beginCol; col <= endCol; ++col) {
                Cell cell = excelRow.getCell(col);
                if (cell != null) {
                    hasValue = true;
                    rowObj[i] = ExcelImportUtil.getCellString(cell);
                }
                ++i;
            }
            if (!hasValue) continue;
            datas.add(rowObj);
        }
        return datas;
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, int beginCol, int beginRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetIndex);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, beginRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, int sheetIndex, int beginCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetIndex, beginCol, beginRow);
            return list;
        }
    }

    public static List<String[]> loadDataFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, int beginCol, int beginRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadDataFromExcelSheet(sheet, beginCol, beginRow);
    }

    public static List<String[]> loadDataFromExcel(String filePath, String sheetName, int beginCol, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<String[]> list = ExcelImportUtil.loadDataFromExcel((InputStream)excelFile, excelType, sheetName, beginCol, beginRow);
            return list;
        }
    }

    private static boolean isMergedRegion(List<CellRangeAddress> cellRanges, int row, int column) {
        if (cellRanges == null || cellRanges.size() == 0) {
            return false;
        }
        for (CellRangeAddress range : cellRanges) {
            if (!range.containsColumn(column) || !range.containsRow(row)) continue;
            return range.getFirstRow() != row || range.getFirstColumn() != column;
        }
        return false;
    }

    private static List<Map<String, Object>> loadMapFromExcelSheet(Sheet sheet, int headerRow, int beginRow, int endRow, int beginColumn, int endColumn, boolean userUpMergeCell) {
        List cellRanges;
        if (beginColumn < 0) {
            beginColumn = 0;
        }
        Row headRow = sheet.getRow(headerRow);
        short lastColumnIndex = headRow.getLastCellNum();
        if (endColumn <= 0) {
            endColumn = lastColumnIndex;
        }
        boolean existNoHeader = false;
        ArrayList<String> header = new ArrayList<String>(60);
        for (int i = beginColumn; i <= endColumn; ++i) {
            Cell cell = headRow.getCell(i);
            if (cell == null || StringUtils.isBlank((CharSequence)ExcelImportUtil.getCellString(cell))) {
                header.add("column" + i);
                existNoHeader = true;
                continue;
            }
            header.add(ExcelImportUtil.getCellString(cell));
        }
        List list = cellRanges = userUpMergeCell ? sheet.getMergedRegions() : null;
        if (userUpMergeCell && existNoHeader) {
            for (int i = headerRow - 1; i >= 0; --i) {
                headRow = sheet.getRow(i);
                existNoHeader = false;
                for (int j = beginColumn; j <= endColumn; ++j) {
                    if (!StringUtils.equals((CharSequence)("column" + j), (CharSequence)((CharSequence)header.get(j - beginColumn)))) continue;
                    Cell cell = headRow.getCell(j);
                    if (cell == null || StringUtils.isBlank((CharSequence)ExcelImportUtil.getCellString(cell))) {
                        existNoHeader = true;
                        continue;
                    }
                    String headerName = ExcelImportUtil.getCellString(cell);
                    header.set(j - beginColumn, headerName);
                }
                if (!existNoHeader) break;
            }
        }
        if (endRow <= 0) {
            endRow = sheet.getLastRowNum() + 1;
        }
        if (beginRow <= headerRow) {
            beginRow = headerRow + 1;
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> preRowData = null;
        for (int row = beginRow; row < endRow; ++row) {
            Row dataRow = sheet.getRow(row);
            if (dataRow == null) continue;
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            boolean hasValue = false;
            for (int column = beginColumn; column <= dataRow.getLastCellNum(); ++column) {
                String key;
                Object cellValue = ExcelImportUtil.getCellValue(dataRow.getCell(column));
                if (cellValue != null) {
                    key = column <= endColumn ? (String)header.get(column - beginColumn) : "column" + column;
                    hasValue = true;
                    rowData.put(key, cellValue);
                    continue;
                }
                if (!userUpMergeCell || preRowData == null || !ExcelImportUtil.isMergedRegion(cellRanges, row, column)) continue;
                key = column <= endColumn ? (String)header.get(column - beginColumn) : "column" + column;
                rowData.put(key, preRowData.get(key));
            }
            if (!hasValue) continue;
            datas.add(rowData);
            preRowData = rowData;
        }
        return datas;
    }

    private static List<Map<String, Object>> loadMapFromExcelSheet(Sheet sheet, int headerRow, int beginRow, int endRow) {
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow, 0, -1, false);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(String filePath, String sheetName) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            Sheet sheet = ExcelImportUtil.loadExcelFileSheet((InputStream)excelFile, excelType, sheetName);
            int firstRow = sheet.getFirstRowNum();
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcelSheet(sheet, firstRow, firstRow + 1, sheet.getLastRowNum() + 1);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(String filePath, int sheetIndex) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            Sheet sheet = ExcelImportUtil.loadExcelFileSheet((InputStream)excelFile, excelType, sheetIndex);
            int firstRow = sheet.getFirstRowNum();
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcelSheet(sheet, firstRow, firstRow + 1, sheet.getLastRowNum() + 1);
            return list;
        }
    }

    public static String[] loadColumnsFromExcel(String filePath, int sheetIndex) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            Sheet sheet = ExcelImportUtil.loadExcelFileSheet((InputStream)excelFile, excelType, sheetIndex);
            int firstRow = sheet.getFirstRowNum();
            String[] stringArray = ExcelImportUtil.loadDataFromExcelSheet(sheet, 0, firstRow).get(0);
            return stringArray;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(String filePath, String sheetName, int headerRow, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            Sheet sheet = ExcelImportUtil.loadExcelFileSheet((InputStream)excelFile, excelType, sheetName);
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, sheet.getLastRowNum() + 1);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(String filePath, int sheetIndex, int headerRow, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            Sheet sheet = ExcelImportUtil.loadExcelFileSheet((InputStream)excelFile, excelType, sheetIndex);
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, sheet.getLastRowNum() + 1);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(String filePath, String sheetName, int headerRow, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            Sheet sheet = ExcelImportUtil.loadExcelFileSheet((InputStream)excelFile, excelType, sheetName);
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(String filePath, int sheetIndex, int headerRow, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            Sheet sheet = ExcelImportUtil.loadExcelFileSheet((InputStream)excelFile, excelType, sheetIndex);
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, String sheetName) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        int firstRow = sheet.getFirstRowNum();
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, firstRow, firstRow + 1, sheet.getLastRowNum() + 1);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, int sheetIndex) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        int firstRow = sheet.getFirstRowNum();
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, firstRow, firstRow + 1, sheet.getLastRowNum() + 1);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, String sheetName, int headerRow, int beginRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, sheet.getLastRowNum() + 1);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, int sheetIndex, int headerRow, int beginRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, sheet.getLastRowNum() + 1);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, String sheetName, int headerRow, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, int sheetIndex, int headerRow, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, String sheetName, int headerRow, int beginRow, int endRow, int beginColumn, int endColumn) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow, beginColumn, endColumn, false);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, int sheetIndex, int headerRow, int beginRow, int endRow, int beginColumn, int endColumn) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow, beginColumn, endColumn, false);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheetUseMergeCell(InputStream excelFile, int sheetIndex, int headerRow, int beginRow, int endRow, int beginColumn, int endColumn) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow, beginColumn, endColumn, true);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheetUseMergeCell(InputStream excelFile, String sheetName, int headerRow, int beginRow, int endRow, int beginColumn, int endColumn) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, headerRow, beginRow, endRow, beginColumn, endColumn, true);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheetUseIndexAsKey(InputStream excelFile, String sheetName, int beginRow, int endRow, boolean userUpMergeCell) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheetUseIndexAsKey(sheet, beginRow, endRow, userUpMergeCell);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheetUseIndexAsKey(InputStream excelFile, int sheetIndex, int beginRow, int endRow, boolean userUpMergeCell) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheetUseIndexAsKey(sheet, beginRow, endRow, userUpMergeCell);
    }

    private static List<Map<String, Object>> loadMapFromExcelSheetUseIndexAsKey(Sheet sheet, int beginRow, int endRow, boolean userUpMergeCell) {
        if (sheet == null) {
            return null;
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(endRow - beginRow + 1);
        List cellRanges = userUpMergeCell ? sheet.getMergedRegions() : null;
        HashMap<String, Object> preRowObj = null;
        for (int row = beginRow; row < endRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            int lcn = excelRow.getLastCellNum();
            HashMap<String, Object> rowObj = new HashMap<String, Object>(lcn + 2);
            boolean hasValue = false;
            for (int i = 0; i < lcn; ++i) {
                Object cellValue = ExcelImportUtil.getCellValue(excelRow.getCell(i));
                String columnIndex = ExcelImportUtil.mapIndexColumn(i);
                if (cellValue != null) {
                    hasValue = true;
                    rowObj.put(columnIndex, cellValue);
                    continue;
                }
                if (!userUpMergeCell || preRowObj == null || !ExcelImportUtil.isMergedRegion(cellRanges, row, i)) continue;
                rowObj.put(columnIndex, preRowObj.get(columnIndex));
            }
            if (!hasValue) continue;
            datas.add(rowObj);
            preRowObj = rowObj;
        }
        return datas;
    }

    private static List<Map<String, Object>> loadMapFromExcelSheet(Sheet sheet, Map<Integer, String> fieldDesc, int beginRow, int endRow, boolean userUpMergeCell) {
        if (sheet == null) {
            return null;
        }
        int columns = fieldDesc.size();
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(endRow - beginRow + 1);
        List cellRanges = userUpMergeCell ? sheet.getMergedRegions() : null;
        HashMap<String, Object> preRowObj = null;
        for (int row = beginRow; row < endRow; ++row) {
            Row excelRow = sheet.getRow(row);
            if (excelRow == null) continue;
            boolean i = false;
            HashMap<String, Object> rowObj = new HashMap<String, Object>(columns + 2);
            boolean hasValue = false;
            for (Map.Entry<Integer, String> ent : fieldDesc.entrySet()) {
                Object cellValue = ExcelImportUtil.getCellValue(excelRow.getCell(ent.getKey().intValue()));
                if (cellValue != null) {
                    hasValue = true;
                    rowObj.put(ent.getValue(), cellValue);
                    continue;
                }
                if (!userUpMergeCell || preRowObj == null || !ExcelImportUtil.isMergedRegion(cellRanges, row, ent.getKey())) continue;
                rowObj.put(ent.getValue(), preRowObj.get(ent.getValue()));
            }
            if (!hasValue) continue;
            datas.add(rowObj);
            preRowObj = rowObj;
        }
        return datas;
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, int sheetIndex, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, endRow, false);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheet(InputStream excelFile, String sheetName, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, endRow, false);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheetUseMergeCell(InputStream excelFile, int sheetIndex, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, endRow, true);
    }

    public static List<Map<String, Object>> loadMapFromExcelSheetUseMergeCell(InputStream excelFile, String sheetName, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, endRow, true);
    }

    public static List<Map<String, Object>> loadMapFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, endRow, false);
    }

    public static List<Map<String, Object>> loadMapFromExcel(String filePath, String sheetName, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcel((InputStream)excelFile, excelType, sheetName, fieldDesc, beginRow, endRow);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcel(InputStream excelFile, ExcelTypeEnum excelType, String sheetName, Map<Integer, String> fieldDesc, int beginRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetName);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, sheet.getLastRowNum() + 1, false);
    }

    public static List<Map<String, Object>> loadMapFromExcel(String filePath, String sheetName, Map<Integer, String> fieldDesc, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(new File(filePath));){
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcel((InputStream)excelFile, excelType, sheetName, fieldDesc, beginRow);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        Sheet sheet = ExcelImportUtil.loadExcelFileSheet(excelFile, excelType, sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, endRow, false);
    }

    public static List<Map<String, Object>> loadMapFromExcel(String filePath, int sheetIndex, Map<Integer, String> fieldDesc, int beginRow, int endRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(filePath);){
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcel((InputStream)excelFile, excelType, sheetIndex, fieldDesc, beginRow, endRow);
            return list;
        }
    }

    public static List<Map<String, Object>> loadMapFromExcel(InputStream excelFile, ExcelTypeEnum excelType, int sheetIndex, Map<Integer, String> fieldDesc, int beginRow) throws IOException {
        HSSFWorkbook wb = excelType == ExcelTypeEnum.HSSF ? new HSSFWorkbook(excelFile) : new XSSFWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(sheetIndex);
        return ExcelImportUtil.loadMapFromExcelSheet(sheet, fieldDesc, beginRow, sheet.getLastRowNum() + 1, false);
    }

    public static List<Map<String, Object>> loadMapFromExcel(String filePath, int sheetIndex, Map<Integer, String> fieldDesc, int beginRow) throws IOException {
        ExcelTypeEnum excelType = ExcelTypeEnum.checkFileExcelType(filePath);
        try (FileInputStream excelFile = new FileInputStream(filePath);){
            List<Map<String, Object>> list = ExcelImportUtil.loadMapFromExcel((InputStream)excelFile, excelType, sheetIndex, fieldDesc, beginRow);
            return list;
        }
    }
}

