/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.JavaBeanField;
import com.centit.support.common.JavaBeanMetaData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class LargeExcelImportUtil {
    protected static final Logger logger = LoggerFactory.getLogger(LargeExcelImportUtil.class);

    private LargeExcelImportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> void parserXSSFSheet(String xlsxFile, String sheetName, int beginRow, Class<T> beanType, Map<Integer, String> fieldDesc, Consumer<T> consumer) throws IOException, OpenXML4JException, SAXException {
        LargeExcelImportUtil.parserXSSFSheet(xlsxFile, sheetName, beginRow, -1, beanType, fieldDesc, consumer);
    }

    public static <T> void parserXSSFSheet(String xlsxFile, String sheetName, int beginRow, int endRow, Class<T> beanType, Map<Integer, String> fieldDesc, Consumer<T> consumer) throws IOException, OpenXML4JException, SAXException {
        JavaBeanMetaData metaData = JavaBeanMetaData.createBeanMetaDataFromType(beanType);
        LargeExcelImportUtil.parserXSSFSheet(xlsxFile, sheetName, beginRow, endRow, rowMap -> {
            try {
                Object rowObj = beanType.newInstance();
                for (Map.Entry ent : fieldDesc.entrySet()) {
                    JavaBeanField field;
                    Object value = rowMap.get(ent.getKey());
                    if (value == null || (field = metaData.getFiled((String)ent.getValue())) == null) continue;
                    field.setObjectFieldValue(rowObj, value);
                }
                consumer.accept(rowObj);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        });
    }

    public static void parserXSSFSheet(String xlsxFile, String sheetName, int beginRow, Consumer<Map<Integer, Object>> consumer) throws IOException, OpenXML4JException, SAXException {
        LargeExcelImportUtil.parserXSSFSheet(xlsxFile, sheetName, beginRow, -1, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parserXSSFSheet(String xlsxFile, String sheetName, int beginRow, int endRow, Consumer<Map<Integer, Object>> consumer) throws IOException, OpenXML4JException, SAXException {
        OPCPackage pkg = OPCPackage.open((InputStream)new FileInputStream(new File(xlsxFile)));
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pkg);
        XSSFReader xssfReader = new XSSFReader(pkg);
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        InputStream stream = null;
        int sheetIndex = 0;
        while (iter.hasNext()) {
            try {
                stream = iter.next();
                String currSheetName = iter.getSheetName();
                if (StringUtils.isBlank((CharSequence)sheetName) || StringUtils.equals((CharSequence)sheetName, (CharSequence)currSheetName) || StringUtils.equals((CharSequence)sheetName, (CharSequence)Integer.toString(sheetIndex))) {
                    XMLReader sheetParser = SAXHelper.newXMLReader();
                    XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)styles, null, (SharedStrings)strings, (XSSFSheetXMLHandler.SheetContentsHandler)new XSSFSheetToMapHandler(beginRow, endRow, consumer), new DataFormatter(), false);
                    sheetParser.setContentHandler((ContentHandler)handler);
                    sheetParser.parse(new InputSource(stream));
                    return;
                }
                ++sheetIndex;
            }
            catch (Exception e) {
                logger.error("parserSheetXml error: ", (Throwable)e);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parserXSSFSheetWithHead(String xlsxFile, String sheetName, int headRow, int beginRow, int endRow, Consumer<Map<String, Object>> consumer) throws IOException, OpenXML4JException, SAXException {
        OPCPackage pkg = OPCPackage.open((InputStream)new FileInputStream(new File(xlsxFile)));
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pkg);
        XSSFReader xssfReader = new XSSFReader(pkg);
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        InputStream stream = null;
        int sheetIndex = 0;
        while (iter.hasNext()) {
            try {
                stream = iter.next();
                String currSheetName = iter.getSheetName();
                if (StringUtils.isBlank((CharSequence)sheetName) || StringUtils.equals((CharSequence)sheetName, (CharSequence)currSheetName) || StringUtils.equals((CharSequence)sheetName, (CharSequence)Integer.toString(sheetIndex))) {
                    XMLReader sheetParser = SAXHelper.newXMLReader();
                    XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)styles, null, (SharedStrings)strings, (XSSFSheetXMLHandler.SheetContentsHandler)new XSSFSheetWithHeadToMapHandler(headRow, beginRow, endRow, consumer), new DataFormatter(), false);
                    sheetParser.setContentHandler((ContentHandler)handler);
                    sheetParser.parse(new InputSource(stream));
                    return;
                }
                ++sheetIndex;
            }
            catch (Exception e) {
                logger.error("parserSheetXml error: ", (Throwable)e);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    public static void parserXSSFSheetWithHead(String xlsxFile, String sheetName, int headRow, int beginRow, Consumer<Map<String, Object>> consumer) throws IOException, OpenXML4JException, SAXException {
        LargeExcelImportUtil.parserXSSFSheetWithHead(xlsxFile, sheetName, headRow, beginRow, -1, consumer);
    }

    public static void parserXSSFSheetWithHead(String xlsxFile, String sheetName, int headRow, Consumer<Map<String, Object>> consumer) throws IOException, OpenXML4JException, SAXException {
        LargeExcelImportUtil.parserXSSFSheetWithHead(xlsxFile, sheetName, headRow, headRow + 1, -1, consumer);
    }

    public static void parserXSSFSheetWithHead(String xlsxFile, String sheetName, Consumer<Map<String, Object>> consumer) throws IOException, OpenXML4JException, SAXException {
        LargeExcelImportUtil.parserXSSFSheetWithHead(xlsxFile, sheetName, 0, 1, -1, consumer);
    }

    private static class XSSFSheetWithHeadToMapHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private Map<Integer, String> headData;
        private Map<Integer, Object> rowData;
        private int headRow;
        private int beginRow;
        private int endRow;
        private Consumer<Map<String, Object>> consumer;

        public XSSFSheetWithHeadToMapHandler() {
            this.beginRow = -1;
            this.endRow = -1;
            this.headRow = -1;
            this.headData = new HashMap<Integer, String>(100);
            this.rowData = new HashMap<Integer, Object>(100);
        }

        public XSSFSheetWithHeadToMapHandler(int headRow, int beginRow, int endRow, Consumer<Map<String, Object>> consumer) {
            this.headRow = headRow;
            this.beginRow = beginRow;
            this.endRow = endRow;
            this.rowData = new HashMap<Integer, Object>(100);
            this.headData = new HashMap<Integer, String>(100);
            this.consumer = consumer;
        }

        public void startRow(int rowNum) {
            this.rowData.clear();
        }

        public void endRow(int rowNum) {
            if (rowNum == this.headRow) {
                for (Map.Entry<Integer, Object> ent : this.rowData.entrySet()) {
                    this.headData.put(ent.getKey(), StringBaseOpt.castObjectToString((Object)ent.getValue()));
                }
            } else if (rowNum >= this.beginRow && (this.endRow < 0 || rowNum < this.endRow)) {
                HashMap<String, String> objectData = new HashMap<String, String>(100);
                for (Map.Entry<Integer, Object> ent : this.rowData.entrySet()) {
                    String key = this.headData.get(ent.getKey());
                    if (key == null) {
                        key = "row" + ent.getKey();
                    }
                    objectData.put(key, StringBaseOpt.castObjectToString((Object)ent.getValue()));
                }
                this.consumer.accept(objectData);
            }
        }

        public void cell(String cellReference, String cellValue, XSSFComment comment) {
            short thisCol = new CellReference(cellReference).getCol();
            this.rowData.put(Integer.valueOf(thisCol), cellValue);
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }

    private static class XSSFSheetToMapHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private Map<Integer, Object> rowData;
        private int beginRow;
        private int endRow;
        private Consumer<Map<Integer, Object>> consumer;

        public XSSFSheetToMapHandler() {
            this.beginRow = -1;
            this.endRow = -1;
            this.rowData = new HashMap<Integer, Object>(100);
        }

        public XSSFSheetToMapHandler(int beginRow, int endRow, Consumer<Map<Integer, Object>> consumer) {
            this.beginRow = beginRow;
            this.endRow = endRow;
            this.rowData = new HashMap<Integer, Object>(100);
            this.consumer = consumer;
        }

        public void startRow(int rowNum) {
            this.rowData.clear();
        }

        public void endRow(int rowNum) {
            if (rowNum >= this.beginRow && (this.endRow < 0 || rowNum < this.endRow)) {
                this.consumer.accept(this.rowData);
            }
        }

        public void cell(String cellReference, String cellValue, XSSFComment comment) {
            short thisCol = new CellReference(cellReference).getCol();
            this.rowData.put(Integer.valueOf(thisCol), cellValue);
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }
}

