/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.searcher;

import com.centit.support.searcher.SearchConfig;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;

public class DocDesc {
    public static String TYPE_FILE = "file";
    public static String TYPE_DB = "db";
    public static String TYPE_URL = "url";
    private ResType type;
    private String sValue;
    private String sCreateTime;
    private String sOpt;
    private String sOwner;
    private String sSummary;

    public String getOpt() {
        return this.sOpt;
    }

    public void setOpt(String sOpt) {
        this.sOpt = sOpt;
    }

    public String getOwner() {
        return this.sOwner;
    }

    public void setOwner(String sOwner) {
        this.sOwner = sOwner;
    }

    public ResType getType() {
        return this.type;
    }

    public void setId(String sId) {
        this.sValue = sId;
    }

    public String getUrl() {
        return this.sValue;
    }

    public String getFilePath() {
        return this.sValue;
    }

    public String getFetchSql() {
        return this.sValue;
    }

    public String getValue() {
        return this.sValue;
    }

    public String getId() {
        return this.sValue;
    }

    public DocDesc() {
        this.type = ResType.UNKNOW;
    }

    public DocDesc(Document document) {
        this.bindDocument(document);
    }

    public DocDesc(String sValue, ResType type) {
        this.sValue = sValue;
        this.type = type;
    }

    public void setFilepath(String sfilepath) {
        this.sValue = sfilepath;
        this.type = ResType.FILE;
    }

    public void setUrl(String sUrl) {
        this.sValue = sUrl;
        this.type = ResType.URL;
    }

    public void setSql(String sSql) {
        this.sValue = sSql;
        this.type = ResType.DB;
    }

    public String getCreateTime() {
        return this.sCreateTime;
    }

    public void setCreateTime(String sCreateTime) {
        this.sCreateTime = sCreateTime;
    }

    public String getSummary() {
        return this.sSummary;
    }

    public void setSummary(String sSummary) {
        this.sSummary = sSummary;
    }

    public void bindDocument(Document document) {
        String sType = document.get(SearchConfig.FIELD_TYPE);
        this.type = TYPE_FILE.equals(sType) ? ResType.FILE : (TYPE_URL.equals(sType) ? ResType.URL : (TYPE_DB.equals(sType) ? ResType.DB : ResType.UNKNOW));
        this.sValue = document.get(SearchConfig.FIELD_ID);
        this.sOpt = document.get(SearchConfig.FIELD_OPT_TYPE);
        this.sOwner = document.get(SearchConfig.FIELD_DOC_OWNER);
        this.sSummary = document.get(SearchConfig.FIELD_SUMMARY);
        this.sCreateTime = document.get(SearchConfig.FIELD_CREATE_TIME);
    }

    public Term getTerm() {
        return new Term(SearchConfig.FIELD_ID, this.sValue);
    }

    public static String makeSummary(String sContent) {
        int nsl = sContent.length();
        if (nsl <= 1024) {
            return sContent;
        }
        return sContent.substring(0, 256);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResType {
        UNKNOW,
        FILE,
        URL,
        DB;

    }
}

