/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.searcher;

import com.centit.support.searcher.DocDesc;
import com.centit.support.searcher.SearchConfig;
import com.centit.support.searcher.TextExtractor;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Indexer {
    private static String[] CanIndexFileType = new String[]{"txt", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "vsd", "htm", "html", "rtf", "pdf"};

    private Indexer() {
    }

    public static boolean canIndex(String fileExtName) {
        for (int i = 0; i < CanIndexFileType.length; ++i) {
            if (!CanIndexFileType[i].equalsIgnoreCase(fileExtName)) continue;
            return true;
        }
        return false;
    }

    public static void indexFile(String filePath, String fileExtName) {
        Indexer.indexFile(filePath, filePath, DocDesc.ResType.FILE, fileExtName, null, null);
    }

    public static void indexFile(String filePath) {
        String fileExtName = filePath.substring(filePath.lastIndexOf(".") + 1);
        Indexer.indexFile(filePath, filePath, DocDesc.ResType.FILE, fileExtName, null, null);
    }

    public static void indexFile(String filePath, String opt, String owner) {
        String fileExtName = filePath.substring(filePath.lastIndexOf(".") + 1);
        Indexer.indexFile(filePath, filePath, DocDesc.ResType.FILE, fileExtName, opt, owner);
    }

    public static void indexFile(String filePath, String url, String fileExtName, String opt, String owner) {
        Indexer.indexFile(filePath, url, DocDesc.ResType.FILE, fileExtName, opt, owner);
    }

    public static void indexFile(String filePath, String url, String opt, String owner) {
        String fileExtName = filePath.substring(filePath.lastIndexOf(".") + 1);
        Indexer.indexFile(filePath, url, DocDesc.ResType.FILE, fileExtName, opt, owner);
    }

    public static void indexFile(String filePath, String url, DocDesc.ResType type, String fileExtName, String opt, String owner) {
        String sContent = null;
        if ("txt".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getTextFileContent(filePath);
        } else if ("doc".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getDocFileContent(filePath);
        } else if ("docx".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getDocxFileContent(filePath);
        } else if ("pdf".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getPdfFileContent(filePath);
        } else if ("rtf".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getRtfFileContent(filePath);
        } else if ("html".equalsIgnoreCase(fileExtName) || "htm".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getHtmFileContent(filePath);
        } else if ("xls".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getXlsFileContent(filePath);
        } else if ("xlsx".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getXlsxFileContent(filePath);
        } else if ("ppt".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getPptFileContent(filePath);
        } else if ("pptx".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getPptxFileContent(filePath);
        } else if ("vsd".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getVsdFileContent(filePath);
        }
        if (StringUtils.isNotEmpty((String)sContent)) {
            Document doc = Indexer.createDocument(sContent, type, url, fileExtName.toLowerCase(), opt, owner);
            Indexer.writeIndexDocument(doc);
        }
    }

    public static void indexByte(byte[] bbuf, String url) {
        Indexer.indexByte(bbuf, url, DocDesc.ResType.DB, "txt", null, null);
    }

    public static void indexByte(byte[] bbuf, String url, String opt, String owner) {
        Indexer.indexByte(bbuf, url, DocDesc.ResType.DB, "txt", opt, owner);
    }

    public static void indexByte(byte[] bbuf, String url, String fileExtName) {
        Indexer.indexByte(bbuf, url, DocDesc.ResType.DB, fileExtName, null, null);
    }

    public static void indexByte(byte[] bbuf, String url, String fileExtName, String opt, String owner) {
        Indexer.indexByte(bbuf, url, DocDesc.ResType.DB, fileExtName, opt, owner);
    }

    public static void indexByte(byte[] bbuf, String url, DocDesc.ResType type, String fileExtName) {
        Indexer.indexByte(bbuf, url, type, fileExtName, null, null);
    }

    public static void indexByte(byte[] bbuf, String url, DocDesc.ResType type, String fileExtName, String opt, String owner) {
        String sContent = null;
        if ("txt".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getTextByteContent(bbuf);
        } else if ("doc".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getDocByteContent(bbuf);
        } else if ("docx".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getDocxByteContent(bbuf);
        } else if ("pdf".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getPdfByteContent(bbuf);
        } else if ("rtf".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getRtfByteContent(bbuf);
        } else if ("xls".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getXlsByteContent(bbuf);
        } else if ("xlsx".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getXlsxByteContent(bbuf);
        } else if ("ppt".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getPptByteContent(bbuf);
        } else if ("vsd".equalsIgnoreCase(fileExtName)) {
            sContent = TextExtractor.getVsdByteContent(bbuf);
        }
        if (StringUtils.isNotEmpty((String)sContent)) {
            Document doc = Indexer.createDocument(sContent, type, url, fileExtName.toLowerCase(), opt, owner);
            Indexer.writeIndexDocument(doc);
        }
    }

    public static void indexWebUrl(String url, String opt, String owner) {
        String sContent = TextExtractor.getWebUrl(url);
        if (StringUtils.isNotEmpty((String)sContent)) {
            Document doc = Indexer.createDocument(sContent, DocDesc.ResType.URL, url, "html", opt, owner);
            Indexer.writeIndexDocument(doc);
        }
    }

    public static void indexWebUrl(String url) {
        Indexer.indexWebUrl(url, null, null);
    }

    public static void setIndexDir(String sDir) {
        SearchConfig.getConfig().setIndexDir(sDir);
    }

    public static void createIndexDir() {
        try {
            FSDirectory indexDir = FSDirectory.open((File)new File(SearchConfig.getConfig().getIndexDir()));
            StandardAnalyzer analyzer = new StandardAnalyzer(SearchConfig.getConfig().getLuceneVersion());
            IndexWriter indexWriter = new IndexWriter((Directory)indexDir, (Analyzer)analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createIndexDir(String sDir) {
        try {
            SearchConfig.getConfig().setIndexDir(sDir);
            FSDirectory indexDir = FSDirectory.open((File)new File(sDir));
            StandardAnalyzer analyzer = new StandardAnalyzer(SearchConfig.getConfig().getLuceneVersion());
            IndexWriter indexWriter = new IndexWriter((Directory)indexDir, (Analyzer)analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeIndexDocument(Document document) {
        try {
            FSDirectory indexDir = FSDirectory.open((File)new File(SearchConfig.getConfig().getIndexDir()));
            StandardAnalyzer analyzer = new StandardAnalyzer(SearchConfig.getConfig().getLuceneVersion());
            IndexWriter indexWriter = new IndexWriter((Directory)indexDir, (Analyzer)analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
            indexWriter.addDocument(document);
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Document createDocument(String sContent, String sSummary, DocDesc.ResType type, String idDesc, String fileExtName, String opt, String owner) {
        Document resDoc = null;
        try {
            Document document = new Document();
            document.add((Fieldable)new Field(SearchConfig.FIELD_CONTENT, sContent, Field.Store.NO, Field.Index.ANALYZED));
            switch (type) {
                case FILE: {
                    document.add((Fieldable)new Field(SearchConfig.FIELD_FILE_ID, idDesc, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    document.add((Fieldable)new Field(SearchConfig.FIELD_TYPE, DocDesc.TYPE_FILE, Field.Store.YES, Field.Index.NO));
                    break;
                }
                case URL: {
                    document.add((Fieldable)new Field(SearchConfig.FIELD_URL_ID, idDesc, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    document.add((Fieldable)new Field(SearchConfig.FIELD_TYPE, DocDesc.TYPE_URL, Field.Store.YES, Field.Index.NO));
                    break;
                }
                case DB: {
                    document.add((Fieldable)new Field(SearchConfig.FIELD_DB_ID, idDesc, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    document.add((Fieldable)new Field(SearchConfig.FIELD_TYPE, DocDesc.TYPE_DB, Field.Store.YES, Field.Index.NO));
                }
            }
            document.add((Fieldable)new Field(SearchConfig.FIELD_SUMMARY, sSummary, Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(SearchConfig.FIELD_CREATE_TIME, new SimpleDateFormat("yyyy:MM:dd HH:mm:ss").format(new Date()), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(SearchConfig.FIELD_FILE_TYPE, fileExtName, Field.Store.YES, Field.Index.NOT_ANALYZED));
            if (StringUtils.isNotEmpty((String)opt)) {
                document.add((Fieldable)new Field(SearchConfig.FIELD_OPT_TYPE, opt, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
            if (StringUtils.isNotEmpty((String)owner)) {
                document.add((Fieldable)new Field(SearchConfig.FIELD_DOC_OWNER, owner, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
            resDoc = document;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resDoc;
    }

    private static Document createDocument(String sContent, DocDesc.ResType type, String idDesc, String fileExtName, String opt, String owner) {
        return Indexer.createDocument(sContent, DocDesc.makeSummary(sContent), type, idDesc, fileExtName, opt, owner);
    }

    public static int removeIndex(DocDesc did) {
        int deleted = 0;
        Term tm = did.getTerm();
        if (tm == null) {
            return deleted;
        }
        try {
            FSDirectory indexDir = FSDirectory.open((File)new File(SearchConfig.getConfig().getIndexDir()));
            IndexReader reader = IndexReader.open((Directory)indexDir, (boolean)false);
            deleted = reader.deleteDocuments(tm);
            reader.close();
            indexDir.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deleted;
    }
}

