/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.searcher;

import com.centit.support.searcher.SearchConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCondition {
    private String sKeyWord;
    private List<String> sTypeList = null;
    private List<String> sOptList = null;
    private String sOwner = null;
    private String sBeginTime = null;
    private String sEndTime = null;

    public String getBeginTime() {
        return this.sBeginTime;
    }

    public void setBeginTime(String sBeginTime) {
        this.sBeginTime = sBeginTime;
    }

    public String getEndTime() {
        return this.sEndTime;
    }

    public void setEndTime(String sEndTime) {
        this.sEndTime = sEndTime;
    }

    public SearchCondition() {
    }

    public SearchCondition(String sKW) {
        this.sKeyWord = sKW;
    }

    public String getKeyWord() {
        return this.sKeyWord;
    }

    public void setKeyWord(String sKeyWord) {
        this.sKeyWord = sKeyWord;
    }

    public List<String> getTypeList() {
        return this.sTypeList;
    }

    public void setTypeList(List<String> sTypeList) {
        this.sTypeList = sTypeList;
    }

    public void addType(String sType) {
        if (this.sTypeList == null) {
            this.sTypeList = new ArrayList<String>();
        }
        this.sTypeList.add(sType);
    }

    public List<String> getOptList() {
        return this.sOptList;
    }

    public void setOptList(List<String> sOptList) {
        this.sOptList = sOptList;
    }

    public void addOpt(String sOpt) {
        if (this.sOptList == null) {
            this.sOptList = new ArrayList<String>();
        }
        this.sOptList.add(sOpt);
    }

    public String getOwner() {
        return this.sOwner;
    }

    public void setOwner(String sOwner) {
        this.sOwner = sOwner;
    }

    public Filter getTimeFilter() {
        if (StringUtils.isNotEmpty((String)this.sBeginTime) || StringUtils.isNotEmpty((String)this.sEndTime)) {
            return new TermRangeFilter(SearchConfig.FIELD_CREATE_TIME, this.sBeginTime, this.sEndTime, true, true);
        }
        return null;
    }

    public Query makeQuery() {
        try {
            Query query = null;
            StandardAnalyzer analyzer = new StandardAnalyzer(SearchConfig.getConfig().getLuceneVersion());
            QueryParser qp = new QueryParser(SearchConfig.getConfig().getLuceneVersion(), SearchConfig.FIELD_CONTENT, (Analyzer)analyzer);
            query = qp.parse(this.sKeyWord);
            BooleanQuery typeNegativeSearch = new BooleanQuery();
            typeNegativeSearch.add(query, BooleanClause.Occur.MUST);
            if (StringUtils.isNotEmpty((String)this.sOwner)) {
                typeNegativeSearch.add((Query)new TermQuery(new Term(SearchConfig.FIELD_DOC_OWNER, this.sOwner)), BooleanClause.Occur.MUST);
            }
            if (this.sTypeList != null && !this.sTypeList.isEmpty()) {
                PhraseQuery typeQuery = new PhraseQuery();
                for (String sType : this.sTypeList) {
                    typeQuery.add(new Term(SearchConfig.FIELD_FILE_TYPE, sType));
                }
                typeNegativeSearch.add((Query)typeQuery, BooleanClause.Occur.MUST);
            }
            if (this.sOptList != null && !this.sOptList.isEmpty()) {
                PhraseQuery optQuery = new PhraseQuery();
                for (String sOpt : this.sOptList) {
                    optQuery.add(new Term(SearchConfig.FIELD_OPT_TYPE, sOpt));
                }
                typeNegativeSearch.add((Query)optQuery, BooleanClause.Occur.MUST);
            }
            return typeNegativeSearch;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

