/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.searcher;

import com.centit.support.searcher.DocDesc;
import com.centit.support.searcher.SearchCondition;
import com.centit.support.searcher.SearchConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Searcher {
    private Searcher() {
    }

    public static List<DocDesc> search(String sQuery) {
        Query query = null;
        IndexSearcher sh = null;
        ArrayList<DocDesc> res = null;
        try {
            FSDirectory indexDir = FSDirectory.open((File)new File(SearchConfig.getConfig().getIndexDir()));
            sh = new IndexSearcher((Directory)indexDir);
            StandardAnalyzer analyzer = new StandardAnalyzer(SearchConfig.getConfig().getLuceneVersion());
            QueryParser qp = new QueryParser(SearchConfig.getConfig().getLuceneVersion(), SearchConfig.FIELD_CONTENT, (Analyzer)analyzer);
            query = qp.parse(sQuery);
            res = new ArrayList<DocDesc>();
            if (sh != null && query != null) {
                TopDocs tdocs = sh.search(query, SearchConfig.MAX_SEARCH_RET_COUNT);
                for (int i = 0; i < tdocs.totalHits; ++i) {
                    Document doc = sh.doc(tdocs.scoreDocs[i].doc);
                    res.add(new DocDesc(doc));
                }
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public static List<DocDesc> search(SearchCondition cond) {
        ArrayList<DocDesc> res = null;
        try {
            IndexSearcher sh = null;
            FSDirectory indexDir = FSDirectory.open((File)new File(SearchConfig.getConfig().getIndexDir()));
            sh = new IndexSearcher((Directory)indexDir);
            Query query = cond.makeQuery();
            res = new ArrayList<DocDesc>();
            if (sh != null && query != null) {
                Filter filt = cond.getTimeFilter();
                TopDocs tdocs = filt == null ? sh.search(query, SearchConfig.MAX_SEARCH_RET_COUNT) : sh.search(query, filt, SearchConfig.MAX_SEARCH_RET_COUNT);
                for (int i = 0; i < tdocs.totalHits; ++i) {
                    Document doc = sh.doc(tdocs.scoreDocs[i].doc);
                    res.add(new DocDesc(doc));
                }
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }
}

