/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.searcher;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.visitors.HtmlPage;
import org.htmlparser.visitors.NodeVisitor;

public class TextExtractor {
    public static String getTextFileContent(String filePath) {
        try {
            FileReader reader = new FileReader(filePath);
            BufferedReader br = new BufferedReader(reader);
            StringBuffer content = new StringBuffer("");
            String str = null;
            while (null != (str = br.readLine())) {
                content.append(str + " ");
            }
            br.close();
            ((Reader)reader).close();
            String sContent = content.toString();
            return sContent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTextByteContent(byte[] buff) {
        return String.valueOf(buff);
    }

    public static String getDocFileContent(String filePath) {
        try {
            WordExtractor wordExtractor = new WordExtractor((InputStream)new FileInputStream(filePath));
            return wordExtractor.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDocByteContent(byte[] buff) {
        try {
            WordExtractor wordExtractor = new WordExtractor((InputStream)new ByteArrayInputStream(buff));
            return wordExtractor.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDocxFileContent(String filePath) {
        try {
            XWPFDocument docx = new XWPFDocument((InputStream)new FileInputStream(filePath));
            XWPFWordExtractor wordExtractor = new XWPFWordExtractor(docx);
            return wordExtractor.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDocxByteContent(byte[] buff) {
        try {
            XWPFDocument docx = new XWPFDocument((InputStream)new ByteArrayInputStream(buff));
            XWPFWordExtractor wordExtractor = new XWPFWordExtractor(docx);
            return wordExtractor.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getXlsFileContent(String filePath) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(filePath));
            ExcelExtractor excel = new ExcelExtractor(workbook);
            return excel.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getXlsByteContent(byte[] buff) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new ByteArrayInputStream(buff));
            ExcelExtractor excel = new ExcelExtractor(workbook);
            return excel.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getXlsxFileContent(String filePath) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(filePath));
            XSSFExcelExtractor excel = new XSSFExcelExtractor(workbook);
            return excel.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getXlsxByteContent(byte[] buff) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(buff));
            XSSFExcelExtractor excel = new XSSFExcelExtractor(workbook);
            return excel.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPptFileContent(String filePath) {
        try {
            HSLFSlideShow ppt = new HSLFSlideShow((InputStream)new FileInputStream(filePath));
            PowerPointExtractor powerpoint = new PowerPointExtractor(ppt);
            return powerpoint.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPptByteContent(byte[] buff) {
        try {
            HSLFSlideShow ppt = new HSLFSlideShow((InputStream)new ByteArrayInputStream(buff));
            PowerPointExtractor powerpoint = new PowerPointExtractor(ppt);
            return powerpoint.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPptxFileContent(String filePath) {
        try {
            XSLFSlideShow ppt = new XSLFSlideShow(filePath);
            XSLFPowerPointExtractor powerpoint = new XSLFPowerPointExtractor(ppt);
            return powerpoint.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getVsdFileContent(String filePath) {
        try {
            VisioTextExtractor vsdExtractor = new VisioTextExtractor((InputStream)new FileInputStream(filePath));
            return vsdExtractor.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getVsdByteContent(byte[] buff) {
        try {
            VisioTextExtractor vsdExtractor = new VisioTextExtractor((InputStream)new ByteArrayInputStream(buff));
            return vsdExtractor.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPdfFileContent(String filePath) {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            PDFParser p = new PDFParser((InputStream)fis);
            p.parse();
            PDFTextStripper ts = new PDFTextStripper();
            String bodyText = ts.getText(p.getPDDocument());
            fis.close();
            return bodyText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPdfByteContent(byte[] buff) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(buff);
            PDFParser p = new PDFParser((InputStream)fis);
            p.parse();
            PDFTextStripper ts = new PDFTextStripper();
            String bodyText = ts.getText(p.getPDDocument());
            ((InputStream)fis).close();
            return bodyText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRtfFileContent(String filePath) {
        try {
            FileInputStream is = new FileInputStream(filePath);
            DefaultStyledDocument styledDoc = new DefaultStyledDocument();
            new RTFEditorKit().read(is, (Document)styledDoc, 0);
            ((InputStream)is).close();
            String bodyText = styledDoc.getText(0, styledDoc.getLength());
            return bodyText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRtfByteContent(byte[] buff) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(buff);
            DefaultStyledDocument styledDoc = new DefaultStyledDocument();
            new RTFEditorKit().read(is, (Document)styledDoc, 0);
            ((InputStream)is).close();
            String bodyText = styledDoc.getText(0, styledDoc.getLength());
            return bodyText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getHtmFileContent(String filePath) {
        StringBuffer content = new StringBuffer("");
        try {
            Parser parser = null;
            parser = new Parser(filePath);
            HtmlPage visitor = new HtmlPage(parser);
            parser.visitAllNodesWith((NodeVisitor)visitor);
            NodeList nodes = visitor.getBody();
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = nodes.elementAt(i);
                content.append(node.toPlainTextString());
            }
            return content.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWebUrl(String urlString) {
        StringBuffer content = new StringBuffer("");
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet httpget = new HttpGet(urlString);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            String inputHTML = EntityUtils.toString((HttpEntity)response.getEntity());
            Parser parser = new Parser();
            parser.setInputHTML(inputHTML);
            HtmlPage visitor = new HtmlPage(parser);
            parser.visitAllNodesWith((NodeVisitor)visitor);
            NodeList nodes = visitor.getBody();
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = nodes.elementAt(i);
                content.append(node.toPlainTextString());
            }
            return content.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

