/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.config;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DBType {
    Oracle,
    DB2,
    SqlServer,
    MySql,
    Access,
    Unknown;


    public static DBType ValueOf(String sdbt) {
        if (sdbt == null) {
            return Unknown;
        }
        if ("oracle".equalsIgnoreCase(sdbt) || sdbt.startsWith("jdbc:oracle")) {
            return Oracle;
        }
        if ("db2".equalsIgnoreCase(sdbt) || sdbt.startsWith("jdbc:db2")) {
            return DB2;
        }
        if ("sqlserver".equalsIgnoreCase(sdbt) || sdbt.startsWith("jdbc:sqlserver")) {
            return SqlServer;
        }
        if ("mysql".equalsIgnoreCase(sdbt) || sdbt.startsWith("jdbc:mysql")) {
            return MySql;
        }
        if ("access".equalsIgnoreCase(sdbt)) {
            return Access;
        }
        return Unknown;
    }

    public static Set<DBType> Values() {
        HashSet<DBType> dbtypes = new HashSet<DBType>();
        dbtypes.add(Oracle);
        dbtypes.add(DB2);
        dbtypes.add(SqlServer);
        dbtypes.add(MySql);
        dbtypes.add(Access);
        return dbtypes;
    }
}

