/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.config;

import com.centit.support.database.config.DirectConnDB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectConn {
    private static Log log = LogFactory.getLog(DirectConn.class);
    public static List<String> hasLoadDrivers = new ArrayList<String>();
    public static Map<DirectConnDB, List<Connection>> connSpool = new HashMap<DirectConnDB, List<Connection>>();

    private DirectConn() {
    }

    private static void loadDBDriver(String driver) throws Exception {
        if (driver == null) {
            return;
        }
        for (String div : hasLoadDrivers) {
            if (!div.equals(driver)) continue;
            return;
        }
        Class.forName(driver).newInstance();
        hasLoadDrivers.add(driver);
    }

    public static Connection newConn(DirectConnDB dbc) throws Exception {
        DirectConn.loadDBDriver(dbc.getDriver());
        List<Connection> conns = connSpool.get(dbc);
        if (conns == null) {
            conns = new ArrayList<Connection>();
        }
        if (conns.size() >= dbc.getMaxConn()) {
            throw new Exception("\u5df2\u8fbe\u5230\u6700\u5927\u8fde\u63a5\u6570");
        }
        Connection conn = DriverManager.getConnection(dbc.getUrl(), dbc.getUser(), dbc.getPassword());
        conns.add(conn);
        connSpool.put(dbc, conns);
        return conn;
    }

    public static Connection getConn(DirectConnDB dbc) throws Exception {
        return DirectConn.getConn(dbc, 0);
    }

    public static Connection getConn(DirectConnDB dbc, int ind) throws Exception {
        List<Connection> conns = connSpool.get(dbc);
        if (conns == null) {
            return DirectConn.newConn(dbc);
        }
        int n = conns.size();
        return conns.get(ind % n);
    }

    public static void closeConn(DirectConnDB dbc, int ind) throws Exception {
        List<Connection> conns = connSpool.get(dbc);
        if (conns == null) {
            return;
        }
        int n = conns.size();
        if (n == 0) {
            return;
        }
        Connection conn = conns.get(ind % n);
        if (conn != null) {
            conn.close();
        }
        conns.remove(ind % n);
    }

    public static void closeConn(DirectConnDB dbc) throws Exception {
        DirectConn.closeConn(dbc, 0);
    }

    public static void closeAll() {
        for (Map.Entry<DirectConnDB, List<Connection>> cs : connSpool.entrySet()) {
            List<Connection> conns = cs.getValue();
            for (Connection conn : conns) {
                try {
                    if (conn == null || conn.isClosed()) continue;
                    conn.close();
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage());
                }
            }
            conns.clear();
        }
    }
}

