/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.config.DBConfig;
import com.centit.support.database.metadata.ReferenceMetadata;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class FWMetadataAccess {
    private DBConfig dbc;

    public TableMetadata loadTableMetadata(String tabName) {
        return null;
    }

    public void setDBConfig(DBConfig dbc) {
        this.dbc = dbc;
    }

    public void saveTableMetadata(TableMetadata md) {
        String sTabCode = md.getTabName().toUpperCase();
        try {
            Connection conn = this.dbc.getConn();
            PreparedStatement pStmt = conn.prepareStatement("delete from F_MD_TABLE where TBCODE=?");
            pStmt.setString(1, sTabCode);
            pStmt.executeUpdate();
            pStmt.close();
            pStmt = conn.prepareStatement("delete from F_MD_COLUMN where TBCODE=?");
            pStmt.setString(1, sTabCode);
            pStmt.executeUpdate();
            pStmt.close();
            pStmt = conn.prepareStatement("delete from F_MD_REL_DETIAL where RELCODE in (select RELCODE from F_MD_RELATION where PTABCODE=?)");
            pStmt.setString(1, sTabCode);
            pStmt.executeUpdate();
            pStmt.close();
            pStmt = conn.prepareStatement("delete from F_MD_RELATION where PTABCODE=?");
            pStmt.setString(1, sTabCode);
            pStmt.executeUpdate();
            pStmt.close();
            pStmt = conn.prepareStatement("insert into F_MD_TABLE(TBCODE,TBNAME,TBTYPE,TBSTATE,TBDESC,IsInWorkflow) values(?,?,'T','S',?,'F')");
            pStmt.setString(1, sTabCode);
            pStmt.setString(2, md.getTabDesc());
            pStmt.setString(3, md.getTabComment());
            pStmt.executeUpdate();
            pStmt.close();
            if (md.getColumns() != null) {
                pStmt = conn.prepareStatement("insert into F_MD_COLUMN(TBCODE,COLCODE,COLNAME,COLTYPE,ACCETYPE,COLLENGTH,COLPRECISION,COLSTATE,COLDESC,COLORDER) values(?,?,?,?,'A',?,?,'T',?,?)");
                pStmt.setString(1, sTabCode);
                int nOrder = 1;
                for (TableField col : md.getColumns()) {
                    pStmt.setString(2, col.getColumn().toUpperCase());
                    pStmt.setString(3, col.getDesc());
                    pStmt.setString(4, col.getDBType());
                    pStmt.setInt(5, col.getMaxLength() > col.getPrecision() ? col.getMaxLength() : col.getPrecision());
                    pStmt.setInt(6, col.getScale());
                    pStmt.setString(7, col.getComment());
                    pStmt.setInt(8, nOrder++);
                    pStmt.executeUpdate();
                }
                pStmt.close();
            }
            if (md.getReferences() != null) {
                for (ReferenceMetadata ref : md.getReferences()) {
                    try {
                        pStmt = conn.prepareStatement("insert into F_MD_RELATION (RELCODE, RELNAME, PTABCODE, CTABCODE, RELSTATE, REFDESC) values(?,?,?,?,'T',?)");
                        pStmt.setString(1, ref.getReferenceCode().toUpperCase());
                        pStmt.setString(2, ref.getReferenceName());
                        pStmt.setString(3, md.getTabName().toUpperCase());
                        pStmt.setString(4, ref.getTableName().toUpperCase());
                        pStmt.setString(5, "\u5916\u952e\u8fde\u63a5");
                        pStmt.executeUpdate();
                        pStmt.close();
                        pStmt = conn.prepareStatement("insert into F_MD_REL_DETIAL (RELCODE, PCOLCODE, CCOLCODE) values(?,?,?)");
                        pStmt.setString(1, ref.getReferenceCode().toUpperCase());
                        int i = 0;
                        for (TableField col : ref.getFkcolumns()) {
                            pStmt.setString(2, md.getPkColumns().get(i).toUpperCase());
                            pStmt.setString(3, col.getColumn().toUpperCase());
                            ++i;
                            pStmt.executeUpdate();
                        }
                        pStmt.close();
                    }
                    catch (Exception e) {
                        pStmt.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

