/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.ReferenceMetadata;
import com.centit.support.database.metadata.TableField;
import com.centit.support.utils.xml.IgnoreDTDEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMetadata {
    private String sClassName;
    private String sTableName;
    private List<TableField> keyProperties;
    private List<TableField> properties;
    private boolean isMainTable = true;
    private boolean hasID = false;
    private String sIdType;
    private String sIdName;
    private List<HibernateMetadata> one2manys;
    private List<ReferenceMetadata> references;

    public boolean isReferenceColumn(int refPos, String sCol) {
        if (this.references == null || this.references.size() == 0) {
            return false;
        }
        int n = this.references.size();
        if (refPos < 0 || n <= 0 || refPos >= n) {
            return false;
        }
        return this.references.get(refPos).containColumn(sCol);
    }

    public boolean isHasID() {
        return this.hasID;
    }

    public void setHasID(boolean hasID) {
        this.hasID = hasID;
    }

    public String getIdType() {
        return this.sIdType;
    }

    public void setIdType(String idType) {
        this.sIdType = idType;
    }

    public String getIdName() {
        return this.sIdName;
    }

    public void setIdName(String idName) {
        this.sIdName = idName;
    }

    public boolean isMainTable() {
        return this.isMainTable;
    }

    public void setMainTable(boolean isMT) {
        this.isMainTable = isMT;
    }

    public static String trimToSimpleClassName(String className) {
        String sClassSimpleName = className;
        int p = className.lastIndexOf(46);
        if (p > 0) {
            sClassSimpleName = className.substring(p + 1);
        }
        return sClassSimpleName;
    }

    public String getClassSimpleName() {
        return HibernateMetadata.trimToSimpleClassName(this.sClassName);
    }

    private TableField loadField(Element fieldNode) {
        TableField field = new TableField();
        field.setName(fieldNode.attribute("name").getValue());
        String sType = "";
        Attribute atType = fieldNode.attribute("type");
        if (atType != null) {
            sType = atType.getValue();
        } else {
            atType = fieldNode.attribute("class");
            if (atType != null) {
                sType = atType.getValue();
            }
        }
        field.setType(sType);
        Element columnNode = fieldNode.element("column");
        if (columnNode != null) {
            field.setColumn(columnNode.attribute("name").getValue());
            Attribute attr = columnNode.attribute("length");
            if (attr != null) {
                field.setMaxLength(Integer.valueOf(attr.getValue()));
            }
            if ((attr = columnNode.attribute("not-null")) != null) {
                field.setNotNull(attr.getValue());
            }
            if ((attr = columnNode.attribute("precision")) != null) {
                field.setPrecision(Integer.valueOf(attr.getValue()));
            }
            if ((attr = columnNode.attribute("scale")) != null) {
                field.setScale(Integer.valueOf(attr.getValue()));
            }
        }
        return field;
    }

    public void loadHibernateMetadata(String sPath, String sHbmFile) {
        this.keyProperties = new ArrayList<TableField>();
        this.properties = new ArrayList<TableField>();
        this.one2manys = null;
        this.references = null;
        try {
            List setElements;
            Element idNode;
            File hbmfile = new File(sPath + sHbmFile);
            FileInputStream is = new FileInputStream(hbmfile);
            SAXReader builder = new SAXReader(false);
            builder.setValidation(false);
            builder.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
            Document doc = builder.read((InputStream)is);
            Element classNode = doc.getRootElement().element("class");
            this.sClassName = classNode.attribute("name").getValue();
            Attribute attr = classNode.attribute("table");
            if (attr != null) {
                this.sTableName = attr.getValue();
            }
            if ((idNode = classNode.element("id")) != null) {
                TableField tf = this.loadField(idNode);
                this.hasID = false;
                this.sIdType = TableField.trimType(tf.getType());
                this.sIdName = tf.getName();
                this.keyProperties.add(tf);
            } else {
                idNode = classNode.element("composite-id");
                this.hasID = true;
                this.sIdType = idNode.attributeValue("class");
                this.sIdName = idNode.attributeValue("name");
                this.sIdType = TableField.trimType(this.sIdType);
                List keyNodes = idNode.elements("key-property");
                for (Element key : keyNodes) {
                    this.keyProperties.add(this.loadField(key));
                }
            }
            List propNodes = classNode.elements("property");
            for (Element prop : propNodes) {
                this.properties.add(this.loadField(prop));
            }
            if (this.isMainTable && (setElements = classNode.elements("set")) != null && setElements.size() > 0) {
                this.one2manys = new ArrayList<HibernateMetadata>();
                this.references = new ArrayList<ReferenceMetadata>();
                for (Element setElement : setElements) {
                    Element one2manyNode = setElement.element("one-to-many");
                    String sSubClassName = one2manyNode.attributeValue("class");
                    int p = sSubClassName.lastIndexOf(46);
                    if (p > 0) {
                        sSubClassName = sSubClassName.substring(p + 1);
                    }
                    HibernateMetadata one2many = new HibernateMetadata();
                    one2many.setMainTable(false);
                    one2many.loadHibernateMetadata(sPath, sSubClassName + ".hbm.xml");
                    this.one2manys.add(one2many);
                    ReferenceMetadata ref = new ReferenceMetadata();
                    ref.setReferenceCode(setElement.attributeValue("name"));
                    Element keyElt = setElement.element("key");
                    List colElements = keyElt.elements("column");
                    for (Element colElt : colElements) {
                        TableField field = new TableField();
                        field.setColumn(colElt.attributeValue("name"));
                        field.mapToMetadata();
                        ref.getFkcolumns().add(field);
                    }
                    this.references.add(ref);
                }
            }
            is.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getClassName() {
        return this.sClassName;
    }

    public String getTableName() {
        return this.sTableName;
    }

    public List<TableField> getKeyProperties() {
        if (this.keyProperties == null) {
            this.keyProperties = new ArrayList<TableField>();
        }
        return this.keyProperties;
    }

    public List<TableField> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<TableField>();
        }
        return this.properties;
    }

    public TableField getProperty(int indx) {
        int n = this.getProperties().size();
        if (n < 1 || indx < 0 || indx >= n) {
            return new TableField();
        }
        return this.properties.get(indx);
    }

    public TableField getKeyProperty(int indx) {
        int n = this.getKeyProperties().size();
        if (n < 1 || indx < 0 || indx >= n) {
            return new TableField();
        }
        return this.keyProperties.get(indx);
    }

    public List<HibernateMetadata> getOne2manys() {
        if (this.one2manys == null) {
            this.one2manys = new ArrayList<HibernateMetadata>();
        }
        return this.one2manys;
    }

    public List<ReferenceMetadata> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<ReferenceMetadata>();
        }
        return this.references;
    }
}

