/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.config.DBConfig;
import com.centit.support.database.metadata.Database;
import com.centit.support.database.metadata.ReferenceMetadata;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class OracleDatabase
implements Database {
    private static final String sqlGetTabColumns = "select a.COLUMN_NAME,a.DATA_TYPE, a.DATA_LENGTH,nvl(a.DATA_PRECISION,a.DATA_LENGTH) as DATA_PRECISION,NVL(a.DATA_SCALE,0) as DATA_SCALE,a.NULLABLE from user_tab_columns a where a.TABLE_NAME=?";
    private static final String sqlPKName = "select CONSTRAINT_NAME from user_constraints where TABLE_NAME=? and CONSTRAINT_TYPE='P'";
    private static final String sqlPKColumns = "select a.COLUMN_NAME from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";
    private static final String sqlFKNames = "select TABLE_NAME,CONSTRAINT_NAME from user_constraints where /*a.OWNER=? and*/ R_CONSTRAINT_NAME=? and CONSTRAINT_TYPE='R'";
    private static final String sqlFKColumns = "select a.COLUMN_NAME,b.DATA_TYPE,b.DATA_LENGTH,nvl(b.DATA_PRECISION,b.DATA_LENGTH) as DATA_PRECISION,NVL(b.DATA_SCALE,0) as DATA_SCALE,b.NULLABLE from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";
    private String sDBSchema;
    private DBConfig dbc;

    public void setDBConfig(DBConfig dbc) {
        this.dbc = dbc;
    }

    public String getDBSchema() {
        return this.sDBSchema;
    }

    public void setDBSchema(String schema) {
        this.sDBSchema = schema;
    }

    public TableMetadata getTableMetadata(String tabName) {
        TableMetadata tab = new TableMetadata(tabName);
        try {
            Connection conn = this.dbc.getConn();
            tab.setSchema(this.dbc.getDbSchema().toUpperCase());
            PreparedStatement pStmt = conn.prepareStatement(sqlGetTabColumns);
            pStmt.setString(1, tabName);
            ResultSet rs = pStmt.executeQuery();
            while (rs.next()) {
                TableField field = new TableField();
                field.setColumn(rs.getString("COLUMN_NAME"));
                field.setDBType(rs.getString("DATA_TYPE"));
                field.setMaxLength(rs.getInt("DATA_LENGTH"));
                field.setPrecision(rs.getInt("DATA_PRECISION"));
                field.setScale(rs.getInt("DATA_SCALE"));
                field.setNullEnable(rs.getString("NULLABLE"));
                field.mapToMetadata();
                tab.getColumns().add(field);
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlPKName);
            pStmt.setString(1, tabName);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                tab.setPkName(rs.getString("CONSTRAINT_NAME"));
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlPKColumns);
            pStmt.setString(1, tab.getPkName());
            rs = pStmt.executeQuery();
            while (rs.next()) {
                tab.getPkColumns().add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlFKNames);
            pStmt.setString(1, tab.getPkName());
            rs = pStmt.executeQuery();
            while (rs.next()) {
                ReferenceMetadata ref = new ReferenceMetadata();
                ref.setTableName(rs.getString("TABLE_NAME"));
                ref.setReferenceCode(rs.getString("CONSTRAINT_NAME"));
                tab.getReferences().add(ref);
            }
            rs.close();
            pStmt.close();
            for (ReferenceMetadata ref : tab.getReferences()) {
                pStmt = conn.prepareStatement(sqlFKColumns);
                pStmt.setString(1, ref.getReferenceCode());
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    TableField field = new TableField();
                    field.setColumn(rs.getString("COLUMN_NAME"));
                    field.setDBType(rs.getString("DATA_TYPE"));
                    field.setMaxLength(rs.getInt("DATA_LENGTH"));
                    field.setPrecision(rs.getInt("DATA_PRECISION"));
                    field.setScale(rs.getInt("DATA_SCALE"));
                    field.setNullEnable(rs.getString("NULLABLE"));
                    field.mapToMetadata();
                    ref.getFkcolumns().add(field);
                }
                rs.close();
                pStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tab;
    }
}

