/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import com.centit.support.utils.StringRegularOpt;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatetimeOpt {
    private static Log log = LogFactory.getLog(DatetimeOpt.class);
    private static String defaultDatePattern = "yyyy-MM-dd";
    private static String timePattern = "HH:mm";
    private static String datetimePattern = "yyyy-MM-dd HH:mm:ss";

    public static Date createUtilDate(int year, int month, int date, int hourOfDay, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(year, month - 1, date, hourOfDay, minute, second);
        return cal.getTime();
    }

    public static Date createUtilDate(int year, int month, int date, int hourOfDay, int minute) {
        return DatetimeOpt.createUtilDate(year, month, date, hourOfDay, minute, 0);
    }

    public static Date createUtilDate(int year, int month, int date) {
        return DatetimeOpt.createUtilDate(year, month, date, 0, 0, 0);
    }

    public static Date convertUtilDate(java.sql.Date date) {
        return date;
    }

    public static java.sql.Date convertSqlDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static java.sql.Date currentSqlDate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Date currentUtilDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Calendar currentCalendarDate() {
        Date today = DatetimeOpt.currentUtilDate();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(today);
        return cal;
    }

    public static String getDatePattern() {
        return defaultDatePattern;
    }

    public static String getDateTimePattern() {
        return datetimePattern;
    }

    public static final Date convertStringToDate(String strDate, String aMask) {
        SimpleDateFormat df = null;
        Date date = null;
        df = new SimpleDateFormat(aMask);
        try {
            if (strDate == null || strDate.equals("")) {
                return null;
            }
            date = df.parse(strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("converting '" + strDate + "' to date with mask '" + aMask + "'"));
            return null;
        }
        return date;
    }

    public static final String convertDateToString(Date aDate, String aMask) {
        String returnValue = "";
        if (aDate == null) {
            log.error((Object)"aDate is null!");
        } else {
            String sMask = aMask == null || "".equals(aMask) ? "yyyy-MM-dd" : aMask;
            SimpleDateFormat df = new SimpleDateFormat(sMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final String convertTimeToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, timePattern);
    }

    public static final String convertTimeWithSecondToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, "HH:mm:ss");
    }

    public static final String convertDateToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, defaultDatePattern);
    }

    public static final String convertDatetimeToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, datetimePattern);
    }

    public static final String getNowDateTime4String() {
        return DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern());
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        return DatetimeOpt.convertStringToDate(strDate, DatetimeOpt.getDatePattern());
    }

    public static int getDayOfWeek(int y, int m, int d) {
        int y0 = y - (14 - m) / 12;
        int x = y0 + y0 / 4 - y0 / 100 + y0 / 400;
        int m0 = m + 12 * ((14 - m) / 12) - 2;
        return (d + x + 31 * m0 / 12) % 7;
    }

    public static int getSecond(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(13);
    }

    public static int getMinute(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(12);
    }

    public static int getHour(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getDayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public static int getDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDayOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int getMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static Date truncateToDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatetimeOpt.createUtilDate(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static Date truncateToMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatetimeOpt.createUtilDate(cal.get(1), cal.get(2) + 1, 1);
    }

    public static Date truncateToYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatetimeOpt.createUtilDate(cal.get(1), 1, 1);
    }

    public static Date addSeconds(Date date, int nSeconds) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(13, nSeconds);
        return cal.getTime();
    }

    public static Date addMinutes(Date date, int nMinutes) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(12, nMinutes);
        return cal.getTime();
    }

    public static Date addHours(Date date, int nHours) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(10, nHours);
        return cal.getTime();
    }

    public static Date addDays(Date date, int nDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(5, nDays);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int nMonths) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(2, nMonths);
        return cal.getTime();
    }

    public static Date addYears(Date date, int nYears) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(1, nYears);
        return cal.getTime();
    }

    public static String getDayOfWeekCN(Date date) {
        String[] weeklist = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", ""};
        return weeklist[DatetimeOpt.getDayOfWeek(date)];
    }

    public static int calcSpanDays(Date beginDate, Date endDate) {
        Date bD = beginDate.getTime() > endDate.getTime() ? DatetimeOpt.truncateToDay(endDate) : DatetimeOpt.truncateToDay(beginDate);
        Date eD = beginDate.getTime() > endDate.getTime() ? beginDate : endDate;
        return (int)((eD.getTime() - bD.getTime()) / 1000L / 60L / 60L / 24L + 1L);
    }

    public static int calcWeekendDays(Date beginDate, Date endDate) {
        int nWeekDay = DatetimeOpt.getDayOfWeek(beginDate);
        int m = DatetimeOpt.calcSpanDays(beginDate, endDate);
        int weekEnds = (m + nWeekDay) / 7;
        int nWeekDay2 = (m + nWeekDay) % 7;
        int days = weekEnds * 2 - (nWeekDay == 0 ? 0 : 1) + (nWeekDay2 > 0 ? 1 : 0);
        return days;
    }

    public static int calcWeekDays(Date beginDate, Date endDate, int weekDay) {
        int nWeekDay = DatetimeOpt.getDayOfWeek(beginDate);
        int m = DatetimeOpt.calcSpanDays(beginDate, endDate);
        return m / 7 + (weekDay >= nWeekDay && nWeekDay + m % 7 > weekDay || weekDay + 7 >= nWeekDay && nWeekDay + m % 7 > weekDay + 7 ? 1 : 0);
    }

    public static boolean equalOnSecond(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 1000L == otherDate.getTime() / 1000L;
    }

    public static boolean equalOnMinute(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 60000L == otherDate.getTime() / 60000L;
    }

    public static boolean equalOnHour(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 3600000L == otherDate.getTime() / 3600000L;
    }

    public static boolean equalOnDay(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 86400000L == otherDate.getTime() / 86400000L;
    }

    public static Date smartPraseDate(String sDate) {
        String sTD = StringRegularOpt.TrimDateString(sDate);
        int sl = sTD.length();
        if (sl < 5) {
            return null;
        }
        if (sl == 4) {
            return DatetimeOpt.convertStringToDate(sTD, "yy-M");
        }
        if (sl == 5) {
            return DatetimeOpt.convertStringToDate(sTD, "yy-MM");
        }
        if (sl == 6) {
            return DatetimeOpt.convertStringToDate(sTD, "yyyy-M");
        }
        if (sl == 7) {
            Date aDate = DatetimeOpt.convertStringToDate(sTD, "yyyy-MM");
            if (aDate == null) {
                aDate = DatetimeOpt.convertStringToDate(sTD, "yy-M-dd");
            }
            return aDate;
        }
        if (sl == 8) {
            return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd");
        }
        if (sl == 9) {
            return DatetimeOpt.convertStringToDate(sTD, "yyyy-M-dd");
        }
        if (sl >= 10) {
            return DatetimeOpt.convertStringToDate(sTD.substring(0, 10), "yyyy-MM-dd");
        }
        return null;
    }
}

