/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.util.Collection;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONOpt {
    private static JSONKey praseJosnKey(String skey) {
        JSONKey key = new JSONKey();
        key.ind = -1;
        int nL = skey.indexOf(91);
        if (nL > 0) {
            key.skey = skey.substring(0, nL);
            int nR = skey.indexOf(93);
            key.ind = nR > nL + 1 ? Integer.parseInt(skey.substring(nL + 1, nR)) : 0;
        } else {
            key.skey = skey;
        }
        return key;
    }

    private static JSONPath findJsonObject(JSONObject objJson, int depth, String[] skeys) {
        JSONPath p = new JSONPath();
        int nLast = 0;
        JSONObject lastKeyJson = objJson;
        while (nLast < depth) {
            Object obj2;
            JSONArray jarray;
            JSONKey key = JSONOpt.praseJosnKey(skeys[nLast]);
            if (!lastKeyJson.has(key.skey)) break;
            Object obj = lastKeyJson.get(key.skey);
            if (obj instanceof JSONObject) {
                if (key.ind >= 0) break;
                lastKeyJson = (JSONObject)obj;
                ++nLast;
                continue;
            }
            if (!(obj instanceof JSONArray) || key.ind < 0 || key.ind >= (jarray = (JSONArray)obj).size() || !((obj2 = jarray.get(key.ind)) instanceof JSONObject)) break;
            lastKeyJson = (JSONObject)obj2;
            ++nLast;
        }
        p.found = true;
        p.pathPos = nLast;
        p.objJson = lastKeyJson;
        return p;
    }

    public static JSONObject findJsonObject(JSONObject objJson, String[] skeys) {
        int depth = skeys.length;
        if (depth < 1) {
            return null;
        }
        JSONPath path = JSONOpt.findJsonObject(objJson, depth, skeys);
        if (path.pathPos != depth) {
            return null;
        }
        return path.objJson;
    }

    public static JSONObject findJsonObject(JSONObject objJson, String path) {
        String[] skeys = path.split("\\x2E");
        if (skeys == null) {
            return null;
        }
        return JSONOpt.findJsonObject(objJson, skeys);
    }

    private static JSONObject createJsonObject(String[] skeys, int beginPos, Object value) {
        int depth = skeys.length;
        if (depth == 0) {
            return null;
        }
        int nLast = beginPos;
        JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
        JSONObject leafKey = new JSONObject();
        if (key.ind < 0) {
            leafKey.element(key.skey, value);
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, value);
            leafKey.element(key.skey, (Collection)jarray);
        }
        depth -= 2;
        while (depth >= nLast) {
            key = JSONOpt.praseJosnKey(skeys[depth]);
            JSONObject tempKey = new JSONObject();
            if (key.ind < 0) {
                tempKey.element(key.skey, (Map)leafKey);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, (Object)leafKey);
                tempKey.element(key.skey, (Collection)jarray);
            }
            leafKey = tempKey;
            --depth;
        }
        return leafKey;
    }

    public static void setAttribute(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        if (skeys == null) {
            return;
        }
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.createJsonObject(skeys, jpath.pathPos + 1, value);
        }
        JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
        if (key.ind < 0) {
            if (jpath.pathPos == depth - 1 && jsonValue instanceof Map) {
                for (Map.Entry ent : ((Map)value).entrySet()) {
                    jpath.objJson.element(ent.getKey().toString(), ent.getValue());
                }
            } else {
                jpath.objJson.element(key.skey, jsonValue);
            }
        } else if (jpath.objJson.has(key.skey)) {
            Object leafJson = jpath.objJson.get(key.skey);
            if (leafJson instanceof JSONArray) {
                JSONArray jarray = (JSONArray)leafJson;
                if (jarray.size() < key.ind + 1) {
                    for (int i = jarray.size(); i < key.ind; ++i) {
                        jarray.add(i, null);
                    }
                    jarray.add(key.ind, jsonValue);
                } else if (jpath.pathPos == depth - 1 && jsonValue instanceof Map) {
                    Object obj = jarray.get(key.ind);
                    if (obj instanceof JSONObject) {
                        for (Map.Entry ent : ((Map)value).entrySet()) {
                            ((JSONObject)obj).element(ent.getKey().toString(), ent.getValue());
                        }
                    } else {
                        jarray.set(key.ind, jsonValue);
                    }
                } else {
                    jarray.set(key.ind, jsonValue);
                }
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.element(key.skey, (Collection)jarray);
            }
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, jsonValue);
            jpath.objJson.element(key.skey, (Collection)jarray);
        }
    }

    public static void appendData(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        if (skeys == null) {
            return;
        }
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.createJsonObject(skeys, jpath.pathPos + 1, value);
            JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
            if (key.ind < 0) {
                jpath.objJson.element(key.skey, jsonValue);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.element(key.skey, (Collection)jarray);
            }
        } else {
            JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
            if (jpath.objJson.has(key.skey)) {
                jpath.objJson.accumulate(key.skey, value);
            } else if (key.ind < 0) {
                jpath.objJson.element(key.skey, value);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, value);
                jpath.objJson.element(key.skey, (Collection)jarray);
            }
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Object[] values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Collection<Object> values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    static class JSONKey {
        String skey;
        int ind;

        JSONKey() {
        }
    }

    static class JSONPath {
        JSONObject objJson;
        String path;
        boolean found;
        int pathPos;

        JSONPath() {
        }
    }
}

