/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionOpt {
    protected static final Log log = LogFactory.getLog(ReflectionOpt.class);

    private ReflectionOpt() {
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        return ReflectionOpt.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class<?> clazz, String propertyName) throws NoSuchFieldException {
        assert (clazz != null);
        assert (propertyName != null && !propertyName.isEmpty());
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field f = superClass.getDeclaredField(propertyName);
                if (f == null) continue;
                return f;
            }
            catch (NoSuchFieldException e) {
                log.debug((Object)e.getMessage());
            }
        }
        throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
    }

    public static Object forceGetProperty(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        if (field == null) {
            log.debug((Object)("property not found. (\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c5e\u6027) \u5bf9\u8c61\uff1a" + object.toString() + " \u5c5e\u6027 \uff1a" + propertyName));
            return null;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            log.info((Object)("error wont' happen." + e.getMessage()));
        }
        field.setAccessible(accessible);
        return result;
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        if (field == null) {
            log.debug((Object)("property not found. (\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c5e\u6027) \u5bf9\u8c61\uff1a" + object.toString() + " \u5c5e\u6027 \uff1a" + propertyName));
            return;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            log.info((Object)("Error won't happen." + e.getMessage()));
        }
        field.setAccessible(accessible);
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object ... params) throws NoSuchMethodException {
        assert (object != null);
        assert (methodName != null && !methodName.isEmpty());
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass();
        }
        Class<?> clazz = object.getClass();
        AccessibleObject method = null;
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                method = superClass.getDeclaredMethod(methodName, types);
                break;
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)"\u65b9\u6cd5\u4e0d\u5728\u5f53\u524d\u7c7b\u5b9a\u4e49,\u7ee7\u7eed\u5411\u4e0a\u8f6c\u578b");
                continue;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("No Such Method:" + clazz.getSimpleName() + methodName);
        }
        boolean accessible = method.isAccessible();
        ((Method)method).setAccessible(true);
        Object result = null;
        try {
            result = ((Method)method).invoke(object, params);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        ((Method)method).setAccessible(accessible);
        return result;
    }

    public static List<Field> getFieldsByType(Object object, Class<?> type) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(type)) continue;
            list.add(field);
        }
        return list;
    }

    public static Class<?> getPropertyType(Class<?> type, String name) throws NoSuchFieldException {
        return ReflectionOpt.getDeclaredField(type, name).getType();
    }

    public static String getGetterName(Class<?> type, String fieldName) {
        assert (type != null);
        assert (fieldName != null && !fieldName.isEmpty());
        if (type.getName().equals("boolean")) {
            return "is" + StringUtils.capitalize((String)fieldName);
        }
        return "get" + StringUtils.capitalize((String)fieldName);
    }

    public static Method getGetterMethod(Class<?> type, String fieldName) {
        try {
            return type.getMethod(ReflectionOpt.getGetterName(type, fieldName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> void InvokeNoParamFunc(T demander, String smethod) {
        try {
            Method setV = demander.getClass().getMethod(smethod, new Class[0]);
            if (setV == null) {
                return;
            }
            setV.invoke(demander, new Object[0]);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.info((Object)("\u6ca1\u6709\u51fd\u6570 " + smethod));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static <T> void InvokeBinaryOpt(T demander, String smethod, T param) {
        try {
            Method setV = demander.getClass().getMethod(smethod, demander.getClass());
            if (setV == null) {
                return;
            }
            setV.invoke(demander, param);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz) {
        return ReflectionOpt.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn((Object)(clazz.getSimpleName() + "'s superclass not ParameterizedType"));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn((Object)("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn((Object)(clazz.getSimpleName() + " not set the actual class on superclass generic parameter"));
            return Object.class;
        }
        return (Class)params[index];
    }
}

