/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBaseOpt {
    private static final Log log = LogFactory.getLog(StringBaseOpt.class);
    static final int GB_SP_DIFF = 160;
    static final int[] secPosvalueList = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5600};
    private static final char[] firstLetter = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z'};

    public static String encodePassword(String password, String algorithm) {
        byte[] unencodedPassword = password.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e));
            return password;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encodedPassword.length; ++i) {
            if ((encodedPassword[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String encodeString(String str) {
        return new String(Base64.encodeBase64((byte[])str.getBytes()));
    }

    public static String decodeString(String str) {
        return new String(Base64.decodeBase64((byte[])str.getBytes()));
    }

    public static boolean contains(String[] strs, String str) {
        boolean in = false;
        if (strs == null) {
            return in;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (!strs[i].contains(str)) continue;
            in = true;
        }
        return in;
    }

    public static String deleteStringByQuote(String str, String quote) {
        if (null == str || "".equals(str)) {
            return "";
        }
        return StringUtils.replace((String)str.trim(), (String)("_" + quote), (String)"");
    }

    public static int indexOf(String[] strs, String str) {
        int index = -1;
        if (null != strs) {
            for (int i = 0; i < strs.length; ++i) {
                if (!strs[i].contains(str)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static boolean isNvl(String str) {
        return str == null || "".equals(str.trim());
    }

    public static String fillZeroForString(String str, int size) {
        if (StringBaseOpt.isNvl(str)) {
            return "";
        }
        for (int sl = str.length(); sl < size; ++sl) {
            str = "0" + str;
        }
        return str;
    }

    public static String nextCode(String sCode) {
        int nSL = sCode.length();
        String sRes = "";
        int i = nSL;
        while (i > 0) {
            char c;
            if ((c = sCode.charAt(--i)) == '9') {
                sRes = '0' + sRes;
                continue;
            }
            if (c == 'z') {
                sRes = 'a' + sRes;
                continue;
            }
            if (c == 'Z') {
                sRes = 'A' + sRes;
                continue;
            }
            c = (char)(c + '\u0001');
            sRes = c + sRes;
            break;
        }
        if (i > 0) {
            sRes = sCode.substring(0, i) + sRes;
        }
        return sRes;
    }

    private static char convertFirstLetter(byte[] bytes) {
        char result = '-';
        int secPosvalue = 0;
        int i = 0;
        while (i < bytes.length) {
            int n = i++;
            bytes[n] = (byte)(bytes[n] - 160);
        }
        secPosvalue = bytes[0] * 100 + bytes[1];
        for (i = 0; i < 23; ++i) {
            if (secPosvalue < secPosvalueList[i] || secPosvalue >= secPosvalueList[i + 1]) continue;
            result = firstLetter[i];
            break;
        }
        return result;
    }

    public static String getFirstLetter(String oriStr) {
        if (oriStr == null) {
            return "";
        }
        String str = oriStr.toLowerCase();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            char[] temp = new char[]{ch};
            byte[] uniCode = new String(temp).getBytes();
            if (uniCode[0] < 128 && uniCode[0] > 0) {
                buffer.append(temp);
                continue;
            }
            buffer.append(StringBaseOpt.convertFirstLetter(uniCode));
        }
        return buffer.toString();
    }

    public static String readFileToBuffer(String sFileName) {
        try {
            FileInputStream in = new FileInputStream(sFileName);
            byte[] readBytes = new byte[in.available()];
            in.read(readBytes);
            in.close();
            return new String(readBytes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String readJarResourceToBuffer(Class<?> clazz, String sResourceName) {
        StringBuffer buffer = new StringBuffer();
        try {
            InputStream in = clazz.getResourceAsStream(sResourceName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append("\r\n");
                line = br.readLine();
            }
            br.close();
            in.close();
            return buffer.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getParameterString(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            String[] strArr = (String[])v;
            if (strArr.length > 0) {
                return strArr[0];
            }
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }
}

