package com.centit.support.database.config;

import java.io.File;
import java.sql.Connection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.centit.support.utils.xml.IgnoreDTDEntityResolver;

public class DirectConnDB implements DBConfig {

	private String url ;
	private String user ;
	private String driver ;
	private String psd ;
	private DBType dbType;
	private int    maxConn ;
	private static Log log = LogFactory.getLog(DBConfig.class);

	public DirectConnDB()
	{
		maxConn = 1;
	}
	
	public DirectConnDB(String url, String user ,String psd)
	{
		this.url = url;
		this.user = user;
		this.psd = psd;

		this.dbType = DBType.mapDBType(url);
		this.driver = DBType.getDbDriver(this.dbType);
		maxConn = 1;
	}
	
	public void loadHibernateConfig(String sConfFile,String sDbBeanName){
		SAXReader  builder = new SAXReader(false);
		builder.setValidation(false);
		builder.setEntityResolver(new IgnoreDTDEntityResolver());
		
		Document doc = null;
		Element bean = null;
		maxConn = 1;
		try {			
			if(sConfFile.indexOf(':')>=0){
				if(sConfFile.startsWith("classpath:")){
					doc= builder.read(this.getClass().getResourceAsStream(sConfFile.substring(10)));
				}else
					doc= builder.read(new File(sConfFile));
			}else
				doc= builder.read(this.getClass().getResourceAsStream(sConfFile));
			Element root  = doc.getRootElement();//获取根元素 
			bean = (Element) root.selectSingleNode("bean[@id=\""+sDbBeanName+"\"]");
			if(bean != null){ // 
				Element property;
				property = (Element)bean.selectSingleNode("property[@name=\"driverClassName\"]");
				if(property!=null)
					driver = property.attributeValue("value");
				log.debug(driver);
				property = (Element)bean.selectSingleNode("property[@name=\"url\"]");
				if(property!=null)
					url = property.attributeValue("value");
				property = (Element)bean.selectSingleNode("property[@name=\"username\"]");
				if(property!=null)
					user = property.attributeValue("value");
				property = (Element)bean.selectSingleNode("property[@name=\"password\"]");
				if(property!=null)
					psd = property.attributeValue("value");
			}
		} catch (DocumentException e) {
			log.error(e.getMessage());
			e.printStackTrace();
		}	
		
		dbType = DBType.mapDBType(url);
	}
	public DBType getDbType() {
		return dbType;
	}
	
	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getDriver() {
		return driver;
	}

	public void setDriver(String driver) {
		this.driver = driver;
	}

	public String getPassword() {
		return psd;
	}

	public void setPassword(String password) {
		this.psd = password;
	}
	
	public int getMaxConn() {
		return maxConn;
	}

	public void setMaxConn(int maxConn) {
		
		this.maxConn = maxConn;
	}
	
	public void praiseConnUrl(String dbUrl) {
		this.url = dbUrl;
		this.dbType = DBType.mapDBType(dbUrl);
		this.driver = DBType.getDbDriver(dbType);
	}
	
	@Override
	public boolean equals(Object dbco){
		if( dbco instanceof DirectConnDB ){
			DirectConnDB dbc =(DirectConnDB) dbco;
			return url !=null && url.equals(dbc.getUrl())
				&& user != null && user.equals(dbc.getUser());
		}else
			return false;
	}
	
	@Override
	public int hashCode(){
		int result = 17;
		result = 37 * result +
		 	(this.getUrl() == null ? 0 :this.getUrl().hashCode());
  
		result = 37 * result +
		 	(this.getUser() == null ? 0 :this.getUser().hashCode());
	
		return result;
	}

	@Override
	public String getDbSchema() {
		return getUser();
	}

	@Override
	public Connection getConn() throws Exception{
		try{
			return DirectConn.getConn(this);
		}catch(Exception e){
			//log.error("连接数据库出错:"+ e.getMessage() + " - " + this.toString());
			throw e;
		}
		
	}
}