package com.centit.support.database.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;

import com.centit.support.database.config.DBConfig;

public class OracleDatabase implements Database {
	private final static String sqlGetTabColumns=
		"select a.COLUMN_NAME,a.DATA_TYPE, a.DATA_LENGTH," +
		   "nvl(a.DATA_PRECISION,a.DATA_LENGTH) as DATA_PRECISION,NVL(a.DATA_SCALE,0) as DATA_SCALE,a.NULLABLE " +
		"from user_tab_columns a "+
		"where a.TABLE_NAME=?";
	
	private final static String sqlPKName=
		"select CONSTRAINT_NAME "+
		"from user_constraints " +
		"where TABLE_NAME=? and CONSTRAINT_TYPE='P'";

	private final static String sqlPKColumns=
		"select a.COLUMN_NAME "+
		"from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) "+
		"where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";

	private final static String sqlFKNames=
		"select TABLE_NAME,CONSTRAINT_NAME "+
		"from user_constraints " +
		"where /*a.OWNER=? and*/ R_CONSTRAINT_NAME=? and CONSTRAINT_TYPE='R'";

	private final static String sqlFKColumns=
		"select a.COLUMN_NAME,b.DATA_TYPE,b.DATA_LENGTH," +
		   "nvl(b.DATA_PRECISION,b.DATA_LENGTH) as DATA_PRECISION,NVL(b.DATA_SCALE,0) as DATA_SCALE,b.NULLABLE " +
		"from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) "+
		"where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";

	
	private String sDBSchema ;
	private DBConfig dbc;
	
	@Override
	public void setDBConfig(DBConfig dbc){
		this.dbc=dbc;
	}

	public String getDBSchema() {
		return sDBSchema;
	}

	public void setDBSchema(String schema) {
		sDBSchema = schema;
	}
	
	public TableMetadata getTableMetadata(String tabName) {
		TableMetadata tab = new TableMetadata(tabName);
		try {
			Connection conn = dbc.getConn();
			tab.setSchema( dbc.getDbSchema().toUpperCase());
			// get columns
			PreparedStatement pStmt= conn.prepareStatement(sqlGetTabColumns);
			pStmt.setString(1, tabName);
			ResultSet rs = pStmt.executeQuery();
			while (rs.next()) {
				TableField field = new TableField();
				field.setColumn(rs.getString("COLUMN_NAME"));
				field.setDBType(rs.getString("DATA_TYPE"));
				field.setMaxLength(rs.getInt("DATA_LENGTH"));
				field.setPrecision(rs.getInt("DATA_PRECISION"));
				field.setScale(rs.getInt("DATA_SCALE"));
				field.setNullEnable(rs.getString("NULLABLE"));
				field.mapToMetadata();
				
				tab.getColumns().add(field);
			}
			rs.close();
			pStmt.close();
			// get primary key
			pStmt= conn.prepareStatement(sqlPKName);
			pStmt.setString(1, tabName);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				tab.setPkName(rs.getString("CONSTRAINT_NAME"));
			}
			rs.close();
			pStmt.close();
			
			pStmt= conn.prepareStatement(sqlPKColumns);
			pStmt.setString(1, tab.getPkName());
			rs = pStmt.executeQuery();
			while (rs.next()) {
				tab.getPkColumns().add(rs.getString("COLUMN_NAME"));
			}
			rs.close();
			pStmt.close();
			// get reference info 
			 
			pStmt= conn.prepareStatement(sqlFKNames);
			pStmt.setString(1, tab.getPkName());
			rs = pStmt.executeQuery();
			while (rs.next()) {
				ReferenceMetadata ref = new ReferenceMetadata();
				ref.setTableName(rs.getString("TABLE_NAME"));
				ref.setReferenceCode(rs.getString("CONSTRAINT_NAME"));
				tab.getReferences().add(ref );
			}
			rs.close();
			pStmt.close();
			// get reference detail
			for(Iterator<ReferenceMetadata> it= tab.getReferences().iterator();it.hasNext(); ){
				ReferenceMetadata ref = it.next();
				pStmt= conn.prepareStatement(sqlFKColumns);
				pStmt.setString(1,ref.getReferenceCode());
				rs = pStmt.executeQuery();
				while (rs.next()) {
					TableField field = new TableField();
					field.setColumn(rs.getString("COLUMN_NAME"));
					field.setDBType(rs.getString("DATA_TYPE"));
					field.setMaxLength(rs.getInt("DATA_LENGTH"));
					field.setPrecision(rs.getInt("DATA_PRECISION"));
					field.setScale(rs.getInt("DATA_SCALE"));
					field.setNullEnable(rs.getString("NULLABLE"));
					field.mapToMetadata();
					
					ref.getFkcolumns().add(field);
				}
				rs.close();
				pStmt.close();
			}
			//conn.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return tab;
	}
	
}
