package com.centit.support.file;

import java.io.IOException;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/**
 * Properties 文件工具类
 * 
 * @author sx
 * 
 */
public class PropertiesReader {
    private static final Log log = LogFactoryImpl.getLog(PropertiesReader.class);

    /**
     * 读取classpath下文件
     * 
     * @param fileName
     *            文件名
     * @param key
     * @return
     */
    public static String getClassPathProperties(String fileName, String key) {
        try {
            return get(new ClassPathResource(fileName), key);
        } catch (IOException e) {
            log.error("读取系统配置文件出错", e);
        }

        return "";
    }

    /**
     * 读取非classpath下文件
     * 
     * @param fileName
     *            文件全路径及文件名
     * @param key
     * @return
     */
    public static String getFilePathProperties(String fileName, String key) {
        try {
            return get(new FileSystemResource(fileName), key);
        } catch (IOException e) {
            log.error("读取系统配置文件出错", e);
        }

        return "";
    }

    /**
     * 读取classpath下文件
     * 
     * @param fileName
     *            文件名
     * @param key
     * @return
     */
    public static Properties getClassPathProperties(String fileName) {
        try {
            return get(new ClassPathResource(fileName));
        } catch (IOException e) {
            log.error("读取系统配置文件出错", e);
        }

        return null;
    }

    /**
     * 读取非classpath下文件
     * 
     * @param fileName
     *            文件全路径及文件名
     * @param key
     * @return
     */
    public static Properties getFilePathProperties(String fileName) {
        try {
            return get(new FileSystemResource(fileName));
        } catch (IOException e) {
            log.error("读取系统配置文件出错", e);
        }

        return null;
    }

    private static String get(Resource resource, String key) throws IOException {
        Properties prop = new Properties();
        prop.load(resource.getInputStream());

        return prop.getProperty(key);
    }

    private static Properties get(Resource resource) throws IOException {
        Properties prop = new Properties();
        prop.load(resource.getInputStream());
        return prop;
    }

}
