package com.centit.support.utils;

import java.util.ArrayList;
import java.util.List;
/**
 * 
 * 一些通用的算法，这些算法都和具体的业务数据结构解耦
 * 
 * @author codefan
 * @version $Rev$ <br>
 *          $Id$
 */
public class Algorithm {
	/**
	 * 
	 * 判断两个对象是否是父子关系，用于针对树形展示的数据结构进行排序
	 * 
	 * @author codefan
	 * @version $Rev$ <br>
	 *          $Id$
	 */
	public static interface ParentChild<T> {
		boolean parentAndChild(T p,T c);
	}
	
	/**
	 * 交换List中两个对象的位置
	 * @param list
	 * @param p1 位置1
	 * @param p2 位置2
	 */
	public static <T> void changeListItem(List<T> list, int p1,int p2) {
		if(p1==p2)
			return;
		T tmp = list.get(p1);
		list.set(p1, list.get(p2));
		list.set(p2, tmp);		
	}
	/**
	 * 移动List一个对象到新的位置
	 * @param list
	 * @param item 位置1
	 * @param pos 位置2
	 */
	public static <T> void moveListItem(List<T> list, int item,int pos) {
		if(item==pos)
			return;
		T tmp = list.remove(item);
		list.add(pos, tmp);	
	}
	
	/**
	 * 对某一个元素，找到它所有的子元素
	 * @param list
	 * @param c
	 * @param nCurPos
	 * @return
	 */
	public static <T> int sortAsTreePiece(List<T> list, ParentChild<? super T> c, int nCurPos) {
		int pp= nCurPos;
		int n = list.size();
		int sortedInd = pp;
		int i=sortedInd+1;
		while(i<n){
			if(c.parentAndChild(list.get(pp),list.get(i))){
				sortedInd ++;
				//changeListItem(list,sortedInd,i);
				moveListItem(list,i,sortedInd);
				sortedInd = sortAsTreePiece(list,c,sortedInd);
				i = sortedInd;
			}
			i ++;
		}
	   return sortedInd;
	}
	
	/**
	 * 将数组结构按照树形展示的形式进行排序，将所有孩子元素放到父元素的下面
	 * @param list
	 * @param c
	 */
	public static <T> void sortAsTree(List<T> list, ParentChild<? super T> c) {
		int n=list.size();
		//sorted 已经排序好的数量
		int sortedInd = -1;
		while(sortedInd < n-2 ){
			// 找到所有的根节点
			int parentInd = -1;
			for(int i= sortedInd+1;i<n;i++){
				boolean isParent = true;
				for(int j=sortedInd+1;j<n;j++){
					if(i != j && c.parentAndChild(list.get(j),list.get(i))){
						isParent = false;
						break;
					}
				}
				if(isParent){
					parentInd = i;
					break;
				}
			}
			if(parentInd == -1) 
				break;
			
			sortedInd ++;
			//changeListItem(list,sortedInd,parentInd);
			moveListItem(list,parentInd,sortedInd);
			// 查找根节点的所有子元素
			sortedInd = sortAsTreePiece(list,c,sortedInd);
		}
	}
	/**
	 * 对排序号的树形数组结构 找到JQueryTree要的Indexes
	 * @param list
	 * @param c
	 * @return
	 */
    public static <T> List<Integer> makeJqueryTreeIndex(List<T> list, ParentChild<? super T> c) {
    	List<Integer> indexes = new ArrayList<Integer>();
        int n=list.size();
        for(int i=0;i<n;i++){
        	int ind = 0;
        	for(int j=0;j<i;j++){
        		if(c.parentAndChild(list.get(j),list.get(i))){
        			ind = j+1;
                    break;
                }
        	}
        	indexes.add(ind);
        }
        return indexes;
    }
}
