package com.centit.support.utils;


public class HtmlFormUtils {
	
	   public static String htmlValue(String value) {      	
    	   if (value == null) {
               return null;
           }        
           StringBuffer result = new StringBuffer(value.length());
           for (int i=0; i<value.length(); ++i) {
               switch (value.charAt(i)) {
               case '<':
                   result.append("&lt;");
                   break;
               case '>': 
                   result.append("&gt;");
                   break;
               case '"': 
                   result.append("&quot;");
                   break;
               case '\'': 
                   result.append("&#39;");
                   break;
/*               case '%': 
                   result.append("&#37;");
                   break;*/
               case ';': 
                   result.append("&#59;");
                   break;
 /*              case '(': 
                   result.append("&#40;");
                   break;
               case ')': 
                   result.append("&#41;");
                   break;*/
               case '&': 
                   result.append("&amp;");
                   break;
/*               case '+':
                   result.append("&#43;");
                   break;*/
               default:
                   result.append(value.charAt(i));
                   break;
               }
           }
           return result.toString();
     }     
    
     public static String htmlString(String value) {      	
  	   if (value == null) {
             return null;
         }        
  	    return value.replaceAll("&lt;", "<").replaceAll("&gt;", ">")
  	    		.replaceAll("&quot;", "\"").replaceAll("&apos;", "'")
  	    		.replaceAll("&amp;", "&");
    }   
    
    public static Object getParameterObject(Object v) {   
		if(v==null){   
		    return null;   
		}else if(v instanceof String[]){             
		    String []strArr=(String[]) v;   
		    for(int i=0;i<strArr.length;i++){   
		    	strArr[i] = htmlValue(strArr[i]);   
		    }		    
		    return strArr;   
		}else if(v instanceof String){   
		    return htmlValue((String) v);   
		}else{   
		    return v;   
		}
	}
    
	public static String getParameterString(Object v) {   
		if(v==null){   
		    return null;   
		}else if(v instanceof String[]){             
		    String []strArr=(String[]) v;   
		    if(strArr.length>0){   
		      return htmlValue(strArr[0]);   
		    }else{   
		      return null;   
		    }   
		}else if(v instanceof String){   
		    return htmlValue((String) v);   
		}else{   
		    return htmlValue(v.toString());   
		}
	}
}
