/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.config.DBConfig;
import com.centit.support.database.metadata.Database;
import com.centit.support.database.metadata.ReferenceMetadata;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableMetadata;
import com.centit.support.utils.xml.IgnoreDTDEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class PdmReader
implements Database {
    private Document doc = null;
    private String sDBSchema = null;
    private List<String> pkColumnIDs;

    public boolean loadPdmFile(String sPath) {
        boolean b = false;
        try {
            File hbmfile = new File(sPath);
            FileInputStream is = new FileInputStream(hbmfile);
            SAXReader builder = new SAXReader(false);
            builder.setValidation(false);
            builder.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
            this.doc = builder.read((InputStream)is);
            b = true;
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    private QName getPdmQName(String sPreFix, String sName) {
        String uri = "attribute";
        if (sPreFix.equals("c")) {
            uri = "collection";
        } else if (sPreFix.equals("o")) {
            uri = "object";
        }
        return new QName(sName, Namespace.get((String)sPreFix, (String)uri), sPreFix + ':' + sName);
    }

    private String getElementText(Element e, String sPreFix, String sName) {
        if (e == null) {
            return null;
        }
        Element f = e.element(this.getPdmQName(sPreFix, sName));
        if (f == null) {
            return null;
        }
        return f.getText();
    }

    private String getAttributeValue(Element e, String xPath) {
        if (e == null) {
            return null;
        }
        Attribute at = (Attribute)e.selectSingleNode(xPath);
        if (at == null) {
            return null;
        }
        return at.getValue();
    }

    public List<String> listAllTables() {
        return this.getAllTableCode();
    }

    public List<String> getAllTableCode() {
        ArrayList<String> tabNames = new ArrayList<String>();
        List tabNodes = this.doc.selectNodes("//c:Tables/o:Table");
        for (Node tNode : tabNodes) {
            tabNames.add(this.getElementText((Element)tNode, "a", "Code"));
        }
        return tabNames;
    }

    @Override
    public TableMetadata getTableMetadata(String tabName) {
        Node nTab;
        this.pkColumnIDs = new ArrayList<String>();
        if (this.doc == null) {
            return null;
        }
        TableMetadata tab = new TableMetadata(tabName.toUpperCase());
        if (this.sDBSchema != null) {
            tab.setSchema(this.sDBSchema);
        }
        if ((nTab = this.doc.selectSingleNode("//c:Tables/o:Table[a:Code='" + tabName + "']")) == null) {
            return null;
        }
        Element eTab = (Element)nTab;
        tab.setTabDesc(this.getElementText(eTab, "a", "Name"));
        tab.setTabComment(this.getElementText(eTab, "a", "Comment"));
        Element elColumns = eTab.element(this.getPdmQName("c", "Columns"));
        if (elColumns == null) {
            return tab;
        }
        List columns = elColumns.elements(this.getPdmQName("o", "Column"));
        for (Element col : columns) {
            TableField field = new TableField();
            field.setColumn(this.getElementText(col, "a", "Code"));
            field.setDBType(this.getElementText(col, "a", "DataType"));
            String stemp = this.getElementText(col, "a", "Length");
            if (stemp != null) {
                field.setMaxLength(Integer.valueOf(stemp));
                field.setPrecision(Integer.valueOf(stemp));
            }
            if ((stemp = this.getElementText(col, "a", "Precision")) != null) {
                field.setScale(Integer.valueOf(stemp));
            }
            if ((stemp = this.getElementText(col, "a", "Mandatory")) != null) {
                field.setNotNull(stemp);
            }
            field.setDesc(this.getElementText(col, "a", "Name"));
            field.setComment(this.getElementText(col, "a", "Comment"));
            field.mapToMetadata();
            tab.getColumns().add(field);
        }
        Attribute pkID = (Attribute)eTab.selectSingleNode("c:PrimaryKey/o:Key/@Ref");
        if (pkID == null) {
            return tab;
        }
        String sPkID = pkID.getValue();
        Element elPK = (Element)eTab.selectSingleNode("c:Keys/o:Key[@Id='" + sPkID + "']");
        if (elPK == null) {
            return tab;
        }
        tab.setPkName(this.getElementText(elPK, "a", "Code"));
        List pkColAttr = elPK.selectNodes("c:Key.Columns/o:Column/@Ref");
        for (Attribute pkCA : pkColAttr) {
            this.pkColumnIDs.add(pkCA.getValue());
            Element elPKCol = (Element)eTab.selectSingleNode("c:Columns/o:Column[@Id='" + pkCA.getValue() + "']/a:Code");
            if (elPKCol == null) continue;
            tab.getPkColumns().add(elPKCol.getText());
        }
        List elReferences = this.doc.selectNodes("//c:References/o:Reference[c:ParentKey/o:Key/@Ref='" + sPkID + "']");
        for (Element elRef : elReferences) {
            ReferenceMetadata ref = new ReferenceMetadata();
            ref.setReferenceCode(elRef.attributeValue("Id"));
            ref.setReferenceName(this.getElementText(elRef, "a", "Name"));
            String sChildTabID = this.getAttributeValue(elRef, "c:ChildTable/o:Table/@Ref");
            if (sChildTabID == null) {
                sChildTabID = this.getAttributeValue(elRef, "c:Object2/o:Table/@Ref");
            }
            Element eChildTab = null;
            if (sChildTabID != null) {
                eChildTab = (Element)this.doc.selectSingleNode("//c:Tables/o:Table[@Id='" + sChildTabID + "']");
            } else {
                String fpk = this.pkColumnIDs.get(0);
                String ffk = this.getAttributeValue(elRef, "c:Joins/o:ReferenceJoin[c:Object1/o:Column/@Ref='" + fpk + "']/c:Object2/o:Column/@Ref");
                if (ffk != null) {
                    eChildTab = (Element)this.doc.selectSingleNode("//c:Tables/o:Table[c:Columns/o:Column/@Id='" + ffk + "']");
                }
            }
            if (eChildTab == null) continue;
            ref.setTableName(this.getElementText(eChildTab, "a", "Code"));
            for (String pkColID : this.pkColumnIDs) {
                TableField field = new TableField();
                String sChildColId = this.getAttributeValue(elRef, "c:Joins/o:ReferenceJoin[c:Object1/o:Column/@Ref='" + pkColID + "']/c:Object2/o:Column/@Ref");
                Element col = (Element)eChildTab.selectSingleNode("c:Columns/o:Column[@Id='" + sChildColId + "']");
                if (col == null) continue;
                field.setColumn(this.getElementText(col, "a", "Code"));
                field.setDBType(this.getElementText(col, "a", "DataType"));
                String stemp = this.getElementText(col, "a", "Length");
                if (stemp != null) {
                    field.setMaxLength(Integer.valueOf(stemp));
                    field.setPrecision(Integer.valueOf(stemp));
                }
                if ((stemp = this.getElementText(col, "a", "Precision")) != null) {
                    field.setScale(Integer.valueOf(stemp));
                }
                if ((stemp = this.getElementText(col, "a", "Mandatory")) != null) {
                    field.setNotNull(stemp);
                }
                field.setDesc(this.getElementText(col, "a", "Name"));
                field.setComment(this.getElementText(col, "a", "Comment"));
                field.mapToMetadata();
                ref.getFkcolumns().add(field);
            }
            tab.getReferences().add(ref);
        }
        return tab;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        if (schema != null) {
            this.sDBSchema = schema.toUpperCase();
        }
    }

    @Override
    public void setDBConfig(DBConfig dbc) {
    }
}

