/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

public class TableField {
    private String sName;
    private String sDesc;
    private String sType;
    private String sDBType;
    private String sColumn;
    private String sComment;
    private boolean bNotNull = false;
    private int nMaxLength = 0;
    private int nPrecision = 0;
    private int nScale = 0;

    public static String mapPropName(String sDBName) {
        String sTempName = sDBName.toLowerCase();
        String sTemp2Name = sDBName.toUpperCase();
        int nl = sDBName.length();
        if (nl < 3) {
            return sTempName;
        }
        int i = 0;
        String sPropName = "";
        while (i < nl) {
            if (sTempName.charAt(i) != '_') {
                sPropName = sPropName + sTempName.charAt(i);
                ++i;
                continue;
            }
            if (++i == 2) {
                sPropName = "";
                continue;
            }
            if (i >= nl) continue;
            sPropName = sPropName + sTemp2Name.charAt(i);
            ++i;
        }
        return sPropName;
    }

    public void mapToMetadata() {
        this.sName = TableField.mapPropName(this.sColumn);
        if ("NUMBER".equalsIgnoreCase(this.sDBType) || "INTEGER".equalsIgnoreCase(this.sDBType) || "DECIMAL".equalsIgnoreCase(this.sDBType)) {
            this.sType = this.nScale > 0 ? "Double" : "Long";
            if (this.nMaxLength <= 0) {
                this.nMaxLength = 8;
            }
        } else if ("CHAR".equalsIgnoreCase(this.sDBType) || "VARCHAR".equalsIgnoreCase(this.sDBType) || "VARCHAR2".equalsIgnoreCase(this.sDBType)) {
            this.sType = "String";
        } else if ("DATE".equalsIgnoreCase(this.sDBType) || "TIME".equalsIgnoreCase(this.sDBType) || "DATETIME".equalsIgnoreCase(this.sDBType)) {
            this.sType = "Date";
            if (this.nMaxLength <= 0) {
                this.nMaxLength = 7;
            }
        } else if ("TIMESTAMP".equalsIgnoreCase(this.sDBType)) {
            this.sType = "Timestamp";
            if (this.nMaxLength <= 0) {
                this.nMaxLength = 7;
            }
        } else {
            this.sType = "CLOB".equalsIgnoreCase(this.sDBType) ? "String" : this.sDBType;
        }
    }

    public String getHibernateType() {
        if (this.sType != null && (this.sType.equals("Date") || this.sType.equals("Timestamp"))) {
            return "java.util." + this.sType;
        }
        return "java.lang." + this.sType;
    }

    public String getName() {
        return this.sName;
    }

    public void setName(String name) {
        this.sName = name;
    }

    public String getType() {
        return this.sType;
    }

    public static String trimType(String st) {
        int p = st.lastIndexOf(46);
        if (p > 0) {
            return st.substring(p + 1);
        }
        return st;
    }

    public void setType(String st) {
        this.sType = TableField.trimType(st);
    }

    public String getDesc() {
        return this.sDesc;
    }

    public void setDesc(String desc) {
        this.sDesc = desc;
    }

    public String getColumn() {
        return this.sColumn;
    }

    public void setColumn(String column) {
        this.sColumn = column;
    }

    public String getComment() {
        return this.sComment;
    }

    public void setComment(String comment) {
        this.sComment = comment;
    }

    public boolean isNotNull() {
        return this.bNotNull;
    }

    public void setNotNull(boolean notNull) {
        this.bNotNull = notNull;
    }

    public void setNotNull(String sNotNull) {
        this.bNotNull = "true".equalsIgnoreCase(sNotNull) || "1".equals(sNotNull);
    }

    public void setNullEnable(String sNullEnable) {
        this.bNotNull = "N".equalsIgnoreCase(sNullEnable) || "0".equalsIgnoreCase(sNullEnable);
    }

    public int getMaxLength() {
        return this.nMaxLength;
    }

    public void setMaxLength(int maxLength) {
        this.nMaxLength = maxLength;
    }

    public int getPrecision() {
        return this.nPrecision;
    }

    public void setPrecision(int precision) {
        this.nPrecision = precision;
    }

    public int getScale() {
        return this.nScale;
    }

    public void setScale(int scale) {
        this.nScale = scale;
    }

    public String getDBType() {
        return this.sDBType;
    }

    public void setDBType(String type) {
        if (type != null) {
            this.sDBType = type.trim();
            int nPos = this.sDBType.indexOf(40);
            if (nPos > 0) {
                this.sDBType = this.sDBType.substring(0, nPos);
            }
        }
    }
}

