/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.ReferenceMetadata;
import com.centit.support.database.metadata.TableField;
import com.centit.support.utils.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class TableMetadata {
    private List<TableField> columns = null;
    private List<String> pkColumns = null;
    private String sSchema;
    private String sTabName;
    private String sTabDesc;
    private String sTabComment;
    private String sPkName;
    private List<ReferenceMetadata> references = null;
    private String sPackageName;

    public String getTabName() {
        return this.sTabName;
    }

    public void setTabName(String tabName) {
        this.sTabName = tabName;
    }

    public String getTabDesc() {
        return this.sTabDesc;
    }

    public void setTabDesc(String tabDesc) {
        this.sTabDesc = tabDesc;
    }

    public String getTabComment() {
        return this.sTabComment;
    }

    public void setTabComment(String tabComment) {
        this.sTabComment = tabComment;
    }

    public String getPkName() {
        return this.sPkName;
    }

    public void setPkName(String pkName) {
        this.sPkName = pkName;
    }

    public String getPackageName() {
        return this.sPackageName;
    }

    public void setPackageName(String packageName) {
        this.sPackageName = packageName;
    }

    public String getSchema() {
        return this.sSchema;
    }

    public void setSchema(String schema) {
        this.sSchema = schema;
    }

    protected static void writerXMLFile(Document doc, String xmlFile) {
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(xmlFile)));
            output.write(doc);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private TableField findField(String colname) {
        for (TableField col : this.columns) {
            if (!col.getColumn().equals(colname)) continue;
            return col;
        }
        return null;
    }

    private boolean isParmaryKey(String colname) {
        for (String col : this.pkColumns) {
            if (!col.equals(colname)) continue;
            return true;
        }
        return false;
    }

    public TableMetadata() {
    }

    public TableMetadata(String tabname) {
        this.setTabName(tabname);
    }

    private void saveProperty(TableField field, Element propElt, boolean keyProp) {
        propElt.addAttribute("name", field.getName());
        propElt.addAttribute("type", field.getHibernateType());
        Element colElt = propElt.addElement("column");
        this.saveColumn(field, colElt, keyProp);
    }

    private void saveColumn(TableField field, Element colElt, boolean keyProp) {
        colElt.addAttribute("name", field.getColumn().toUpperCase());
        if ("Long".equals(field.getType()) || "Double".equals(field.getType())) {
            colElt.addAttribute("precision", String.valueOf(field.getPrecision()));
            colElt.addAttribute("scale", String.valueOf(field.getScale()));
        } else if (field.getMaxLength() > 0) {
            colElt.addAttribute("length", String.valueOf(field.getMaxLength()));
        }
        if (!keyProp && field.isNotNull()) {
            colElt.addAttribute("not-null", "true");
        }
    }

    private void setAppPropertiesValue(Properties prop, String key, String value) {
        String sKey = TableField.mapPropName(this.sTabName) + '.' + key;
        if (!prop.containsKey(sKey)) {
            prop.setProperty(sKey, value);
        }
    }

    public void addResource(String filename) {
        FileOutputStream outputFile;
        FileInputStream fis;
        Properties prop;
        try {
            prop = new Properties();
            if (FileSystemOpt.existFile(filename + "_zh_CN.properties")) {
                fis = new FileInputStream(filename + "_zh_CN.properties");
                prop.load(fis);
                fis.close();
            }
            this.setAppPropertiesValue(prop, "list.title", this.sTabDesc + "\u5217\u8868");
            this.setAppPropertiesValue(prop, "edit.title", "\u7f16\u8f91" + this.sTabDesc);
            this.setAppPropertiesValue(prop, "view.title", "\u67e5\u770b" + this.sTabDesc);
            for (TableField col : this.columns) {
                this.setAppPropertiesValue(prop, TableField.mapPropName(col.getColumn()), col.getDesc());
            }
            outputFile = new FileOutputStream(filename + "_zh_CN.properties");
            prop.store(outputFile, "create by centit B/S framework!");
            outputFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            prop = new Properties();
            if (FileSystemOpt.existFile(filename + ".properties")) {
                fis = new FileInputStream(filename + ".properties");
                prop.load(fis);
                fis.close();
            }
            this.setAppPropertiesValue(prop, "list.title", TableField.mapPropName(this.sTabName) + " list");
            this.setAppPropertiesValue(prop, "edit.title", "new or edit " + TableField.mapPropName(this.sTabName) + " piece");
            this.setAppPropertiesValue(prop, "view.title", "view " + TableField.mapPropName(this.sTabName) + " piece");
            for (TableField col : this.columns) {
                this.setAppPropertiesValue(prop, TableField.mapPropName(col.getColumn()), col.getName());
            }
            outputFile = new FileOutputStream(filename + ".properties");
            prop.store(outputFile, "create by centit B/S framework!");
            outputFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveHibernateMappingFile(String filename) {
        Element idElt;
        Document doc = null;
        if (FileSystemOpt.existFile(filename)) {
            System.out.println("\u6587\u4ef6\uff1a" + filename + " \u5df2\u5b58\u5728\uff01");
            return;
        }
        doc = DocumentHelper.createDocument();
        doc.addDocType("hibernate-mapping", "-//Hibernate/Hibernate Mapping DTD 3.0//EN", "http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd");
        doc.addComment("Mapping file autogenerated by codefan@centit.com");
        Element root = doc.addElement("hibernate-mapping");
        Element classElt = root.addElement("class");
        classElt.addAttribute("name", this.sPackageName + '.' + this.getClassName());
        classElt.addAttribute("table", this.sTabName.toUpperCase());
        classElt.addAttribute("schema", this.sSchema);
        if (this.pkColumns != null && this.pkColumns.size() > 1) {
            idElt = classElt.addElement("composite-id");
            idElt.addAttribute("name", "cid");
            idElt.addAttribute("class", this.sPackageName + '.' + this.getClassName() + "Id");
            for (String pkcol : this.pkColumns) {
                TableField field = this.findField(pkcol);
                if (field == null) continue;
                Element keyElt = idElt.addElement("key-property");
                this.saveProperty(field, keyElt, true);
            }
        } else if (this.pkColumns != null && this.pkColumns.size() == 1) {
            idElt = classElt.addElement("id");
            TableField field = this.findField(this.pkColumns.get(0));
            this.saveProperty(field, idElt, true);
            Element genElt = idElt.addElement("generator");
            genElt.addAttribute("class", "assigned");
        }
        if (this.columns != null) {
            for (TableField col : this.columns) {
                if (this.isParmaryKey(col.getColumn())) continue;
                Element propElt = classElt.addElement("property");
                this.saveProperty(col, propElt, false);
            }
        }
        if (this.references != null) {
            for (ReferenceMetadata ref : this.references) {
                Element setElt = classElt.addElement("set");
                setElt.addAttribute("name", TableField.mapPropName(ref.getTableName()) + 's');
                setElt.addAttribute("cascade", "all-delete-orphan");
                setElt.addAttribute("inverse", "true");
                Element keyElt = setElt.addElement("key");
                for (TableField col : ref.getFkcolumns()) {
                    Element colElt = keyElt.addElement("column");
                    this.saveColumn(col, colElt, false);
                }
                Element maptypeElt = setElt.addElement("one-to-many");
                maptypeElt.addAttribute("class", this.sPackageName + '.' + ref.getClassName());
            }
        }
        TableMetadata.writerXMLFile(doc, filename);
    }

    public List<TableField> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<TableField>();
        }
        return this.columns;
    }

    public void setColumns(List<TableField> columns) {
        this.columns = columns;
    }

    public List<String> getPkColumns() {
        if (this.pkColumns == null) {
            this.pkColumns = new ArrayList<String>();
        }
        return this.pkColumns;
    }

    public void setPkColumns(List<String> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public String getClassName() {
        String sClassName = TableField.mapPropName(this.sTabName);
        return sClassName.substring(0, 1).toUpperCase() + sClassName.substring(1);
    }

    public List<ReferenceMetadata> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<ReferenceMetadata>();
        }
        return this.references;
    }

    public void setReferences(List<ReferenceMetadata> references) {
        this.references = references;
    }
}

