/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PropertiesReader {
    private static final Log log = LogFactoryImpl.getLog(PropertiesReader.class);

    public static String getClassPathProperties(String fileName, String key) {
        try {
            return PropertiesReader.get((Resource)new ClassPathResource(fileName), key);
        }
        catch (IOException e) {
            log.error((Object)"\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    public static String getFilePathProperties(String fileName, String key) {
        try {
            return PropertiesReader.get((Resource)new FileSystemResource(fileName), key);
        }
        catch (IOException e) {
            log.error((Object)"\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    public static Properties getClassPathProperties(String fileName) {
        try {
            return PropertiesReader.get((Resource)new ClassPathResource(fileName));
        }
        catch (IOException e) {
            log.error((Object)"\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public static Properties getFilePathProperties(String fileName) {
        try {
            return PropertiesReader.get((Resource)new FileSystemResource(fileName));
        }
        catch (IOException e) {
            log.error((Object)"\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private static String get(Resource resource, String key) throws IOException {
        Properties prop = new Properties();
        prop.load(resource.getInputStream());
        return prop.getProperty(key);
    }

    private static Properties get(Resource resource) throws IOException {
        Properties prop = new Properties();
        prop.load(resource.getInputStream());
        return prop;
    }
}

