/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class ExportExcelUtil {
    private HSSFWorkbook wb = null;
    private HSSFSheet sheet = null;

    public static InputStream generateExcel(List<? extends Object> objLists) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HSSFSheet sheet = ExportExcelUtil.getDefaultSheet();
        try {
            ExportExcelUtil.generateObjText(sheet, objLists);
            sheet.getWorkbook().write((OutputStream)baos);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static InputStream generateExcel(List<? extends Object> objLists, String[] header, String[] property) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HSSFSheet sheet = ExportExcelUtil.getDefaultSheet();
        ExportExcelUtil.generateHeader(sheet, header);
        try {
            ExportExcelUtil.generateText(sheet, objLists, property);
            sheet.getWorkbook().write((OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static InputStream generateExcel(List<Object[]> objLists, String[] header, int[] property) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HSSFSheet sheet = ExportExcelUtil.getDefaultSheet();
        ExportExcelUtil.generateHeader(sheet, header);
        try {
            ExportExcelUtil.generateText(sheet, objLists, property);
            sheet.getWorkbook().write((OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static InputStream generateExcel(List<Object[]> objLists, String[] header) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HSSFSheet sheet = ExportExcelUtil.getDefaultSheet();
        ExportExcelUtil.generateHeader(sheet, header);
        ExportExcelUtil.generateText(sheet, objLists);
        try {
            sheet.getWorkbook().write((OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static HSSFSheet getDefaultSheet() {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        return new ExportExcelUtil(wb, sheet).getSheet();
    }

    private static void generateHeader(HSSFSheet sheet, String[] header) {
        HSSFRow headerRow = sheet.createRow(0);
        for (int i = 0; i < header.length; ++i) {
            HSSFCell cell = headerRow.createCell(i);
            ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
            cell.setCellValue(header[i]);
        }
    }

    private static void generateText(HSSFSheet sheet, List<? extends Object> objLists, String[] property) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        for (int i = 0; i < objLists.size(); ++i) {
            HSSFRow textRow = sheet.createRow(i + 1);
            for (int j = 0; j < property.length; ++j) {
                HSSFCell cell = textRow.createCell(j);
                ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
                if (ClassUtils.isAssignableValue(Map.class, objLists.get(i).getClass())) {
                    Object val = ((Map)objLists.get(i)).get(property[j]);
                    cell.setCellValue(null == val ? "" : val.toString());
                    continue;
                }
                Field field = objLists.get(i).getClass().getDeclaredField(property[j]);
                String methodName = ExportExcelUtil.getMethodName(field);
                Method method = objLists.get(i).getClass().getDeclaredMethod(methodName, null);
                Object val = method.invoke(objLists.get(i), null);
                cell.setCellValue(null == val ? "" : val.toString());
            }
        }
    }

    private static void generateText(HSSFSheet sheet, List<Object[]> objLists, int[] property) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        for (int i = 0; i < objLists.size(); ++i) {
            HSSFRow textRow = sheet.createRow(i + 1);
            for (int j = 0; j < property.length; ++j) {
                HSSFCell cell = textRow.createCell(j);
                ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
                if (!ClassUtils.isAssignableValue(Object.class, objLists.get(i).getClass())) continue;
                Object val = objLists.get(i)[property[j]];
                cell.setCellValue(null == val ? "" : val.toString());
            }
        }
    }

    private static void generateObjText(HSSFSheet sheet, List<? extends Object> objLists) throws InvocationTargetException, IllegalAccessException {
        for (int i = 0; i < objLists.size(); ++i) {
            HSSFRow textRow = sheet.createRow(i);
            Field[] fields = objLists.get(i).getClass().getDeclaredFields();
            int errorLen = 0;
            for (int j = 0; j < fields.length; ++j) {
                String methodName = ExportExcelUtil.getMethodName(fields[j]);
                Method method = null;
                try {
                    method = objLists.get(i).getClass().getDeclaredMethod(methodName, null);
                }
                catch (NoSuchMethodException e) {
                    ++errorLen;
                    continue;
                }
                if (null == method) continue;
                HSSFCell cell = textRow.createCell(j - errorLen);
                ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
                Object val = method.invoke(objLists.get(i), null);
                cell.setCellValue(null == val ? "" : val.toString());
            }
        }
    }

    private static void generateText(HSSFSheet sheet, List<Object[]> objLists) {
        for (int i = 0; i < objLists.size(); ++i) {
            HSSFRow textRow = sheet.createRow(i + 1);
            for (int j = 0; j < objLists.get(i).length; ++j) {
                HSSFCell cell = textRow.createCell(j);
                ExportExcelUtil.setCellStyle(sheet.getWorkbook(), cell);
                cell.setCellValue(null == objLists.get(i)[j] ? "" : objLists.get(i)[j].toString());
            }
        }
    }

    private static String getMethodName(Field field) {
        if (Boolean.class.equals(field.getType()) || Boolean.TYPE.equals(field.getType())) {
            return "is" + StringUtils.capitalize((String)field.getName());
        }
        return "get" + StringUtils.capitalize((String)field.getName());
    }

    private static void setCellStyle(HSSFWorkbook wb, HSSFCell cell) {
        cell.setCellType(1);
        cell.setCellStyle(ExportExcelUtil.getDefaultCellStyle(wb));
    }

    private static HSSFCellStyle getDefaultCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)2);
        cellStyle.setVerticalAlignment((short)1);
        HSSFFont font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        cellStyle.setFont(font);
        return cellStyle;
    }

    private ExportExcelUtil() {
    }

    private ExportExcelUtil(HSSFWorkbook wb, HSSFSheet sheet) {
        this.wb = wb;
        this.sheet = sheet;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public HSSFWorkbook getWb() {
        return this.wb;
    }

    public void setWb(HSSFWorkbook wb) {
        this.wb = wb;
    }
}

