package com.centit.support.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

import net.sourceforge.pinyin4j.PinyinHelper;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

/**
 * String Utility Class This is used to encode passwords programmatically
 * 
 * <p>
 * <a h ref="StringUtil.java.html"><i>View Source</i></a>
 * </p>
 * 
 * @author <a href="mailto:matt@raibledesigns.com">Matt Raible</a>
 * @author 杨淮生
 */
public class StringBaseOpt {
	// ~ Static fields/initializers
	// =============================================

	//private final static Log log = LogFactory.getLog(StringBaseOpt.class);

	// ~ Methods
	// ================================================================


	/**
	 * Encode a string using Base64 encoding. Used when storing passwords as
	 * cookies.
	 * 
	 * This is weak encoding in that anyone can use the decodeString routine to
	 * reverse the encoding.
	 * 
	 * @param str
	 * @return String
	 */
	public static String encodeBase64(String str) {
		//sun.misc.BASE64Encoder encoder = new sun.misc.BASE64Encoder();
		//return encoder.encodeBuffer(str.getBytes()).trim();
		return new String(Base64.encodeBase64(str.getBytes()));
	}
	
	/**
	 * Decode a string using Base64 encoding.
	 * 
	 * @param str
	 * @return String
	 */
	public static String decodeBase64(String str) {
		//sun.misc.BASE64Decoder dec = new sun.misc.BASE64Decoder();
		return new String(Base64.decodeBase64(str.getBytes()));
	}
	
	
	/**
	 * Encode a string using algorithm specified in web.xml and return the
	 * resulting encrypted password. If exception, the plain credentials string
	 * is returned
	 * 
	 * @param password
	 *            Password or other credentials to use in authenticating this
	 *            username
	 * @param algorithm
	 *            Algorithm used to do the digest
	 *   如基本的单向加密算法： 
				•BASE64 严格地说，属于编码格式，而非加密算法
				•MD5(Message Digest algorithm 5，信息摘要算法)
				•SHA(Secure Hash Algorithm，安全散列算法)
				•HMAC(Hash Message Authentication Code，散列消息鉴别码)
				
		    复杂的对称加密（DES、PBE）、非对称加密算法： 
			
				•DES(Data Encryption Standard，数据加密算法)
				•PBE(Password-based encryption，基于密码验证)
				•RSA(算法的名字以发明者的名字命名：Ron Rivest, AdiShamir 和Leonard Adleman)
				•DH(Diffie-Hellman算法，密钥一致协议)
				•DSA(Digital Signature Algorithm，数字签名)
				•ECC(Elliptic Curves Cryptography，椭圆曲线密码编码学)

	 * 
	 * @return encypted password based on the algorithm.
	 */
	

    /**
     * 转换密钥<br>
     *
     * @param key
     * @return
     * @throws Exception
     */
    private static Key getDesStaticKey() throws Exception {
        DESKeySpec dks = new DESKeySpec(Base64.encodeBase64("0123456789abcdefghijklmnopqrstuvwxyzABCDEF".getBytes()));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(dks);

        // 当使用其他对称加密算法时，如AES、Blowfish等算法时，用下述代码替换上述三行代码
        //SecretKey secretKey = new SecretKeySpec(key.getBytes(), algorithm);

        return secretKey;
    }

    /**
     * 解密
     *
     * @param data
     * @param key
     * @return
     * @throws Exception 
     */  
    public static byte[] decryptDes(byte[] data) throws Exception {  
        Key k = getDesStaticKey();  
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(Cipher.DECRYPT_MODE, k);  
  
        return cipher.doFinal(data);  
    }  
  
    /**
     * 加密 
     *  
     * @param data 
     * @param key 
     * @return 
     * @throws Exception
     */  
    public static byte[] encryptDes(byte[] data) throws Exception {  
        Key k = getDesStaticKey();  
        Cipher cipher = Cipher.getInstance("DES");  
        cipher.init(Cipher.ENCRYPT_MODE, k);  

        return cipher.doFinal(data);
    }
	
    /**
     * 用Des加密再用base64编码
     * @param str
     * @param key
     * @return
     */

    public static String encryptDesBase64(String str){
    	try {
			return new String(Base64.encodeBase64(encryptDes(str.getBytes())));
		} catch (Exception e) {
			return null;
		}
    }
    /**
     * 用base64解码再用Des解密
     * @param str
     * @param key
     * @return
     */
    public static String decryptBase64Des(String str){
    	try {
			return new String(decryptDes(Base64.decodeBase64(str.getBytes())));
		} catch (Exception e) {
			return null;
		}
    }
	/**
	   * 字符串的压缩
	   *
	   * @param str
	   *            待压缩的字符串
	   * @return    返回压缩后的字符串
	   * @throws IOException
	   */
	  public  static byte[] compress(String str) throws IOException {
	      if (null == str || str.length() <= 0) {  
	          return null;
	      }
	      // 创建一个新的 byte 数组输出流  
	      ByteArrayOutputStream out = new ByteArrayOutputStream();
	      // 使用默认缓冲区大小创建新的输出流
	      GZIPOutputStream gzip = new GZIPOutputStream(out);
	      // 将 b.length 个字节写入此输出流  
	      gzip.write(str.getBytes());
	      gzip.close();
	      // 使用指定的 charsetName，通过解码字节将缓冲区内容转换为字符串  
	      return out.toByteArray();// .toString("ISO-8859-1");
	  }
	    
	  /**
	   * 字符串的解压
	   *
	   * @param str  
	   *            对字符串解压
	   * @return    返回解压缩后的字符串  
	   * @throws IOException  
	   */  
	  public static String unCompress( byte[] str) throws IOException {  
	      if (null == str || str.length <= 0) {  
	          return "";
	      }  
	      // 创建一个新的 byte 数组输出流  
	      ByteArrayOutputStream out = new ByteArrayOutputStream();  
	      // 创建一个 ByteArrayInputStream，使用 buf 作为其缓冲区数组  
	      ByteArrayInputStream in = new ByteArrayInputStream(str );//.getBytes("ISO-8859-1"));
	      // 使用默认缓冲区大小创建新的输入流  
	      GZIPInputStream gzip = new GZIPInputStream(in);  
	      byte[] buffer = new byte[256];  
	      int n = 0;  
	      while ((n = gzip.read(buffer)) >= 0) {// 将未压缩数据读入字节数组  
	          // 将指定 byte 数组中从偏移量 off 开始的 len 个字节写入此 byte数组输出流
	          out.write(buffer, 0, n);  
	      }  
	      // 使用指定的 charsetName，通过解码字节将缓冲区内容转换为字符串  
	      return out.toString("utf-8");  
	  }  
	  
	/**
	 * @param strs
	 * @param str
	 * @return 如果字符串str在数组strs返回true
	 */
	public static boolean contains(String strs[], String str) {
		boolean in = false;
		if (strs == null)
			return in;
		for (int i = 0; i < strs.length; i++)
			if (strs[i].contains(str))
				in = true;
		return in;
	}
	/**
	 * copyProperties(),删除备份条件的后缀,如"value_CODE"过滤成"value"
	 * 
	 * @param str
	 *            源串
	 * @param quote
	 *            待过滤串
	 * @return
	 */
	public static String deleteStringByQuote(String str, String quote) {
		if (null == str || "".equals(str)) {
			return "";
		}
		return StringUtils.replace(str.trim(), "_" + quote, "");
	}
	
	/**
	 * 返回字符串在数组中的第一次出现的位置,找不到返回-1
	 * 
	 * @param strs
	 * @param str
	 * @return int
	 */
	public static int indexOf(String strs[], String str) {
		int index = -1;
		if (null != strs) {
			for (int i = 0; i < strs.length; i++)
				if (strs[i].contains(str)) {
					index = i;
					break;
				}
		}
		return index;
	}
	/**
	 * 判断字符串是否为空(null || ""),是：true,否：false
	 * 
	 * @param str
	 * @return boolean
	 */
	public static boolean isNvl(String str) {
		return str == null || "".equals(str.trim());
	}

	/**
	 * 用"0"填补string
	 * 
	 * @param str
	 * @param size
	 * @return
	 */
	public static String fillZeroForString(String str, int size) {
		if (isNvl(str) ) {
			str =  "0";
		}
		if(size==0)
			return str;
		
		int sl = str.length();

		for (; sl< size ;sl++) {
			str = "0"+str;
		}
		return str;
	}
	/**
	 * 文号、档案号、规则生成算法， 
	 * @param templet 规则模板 $N16$表示生成 16位的流水号 左侧补零
	 * @param currNo 流水号
	 * @param params 用户自定义参数
	 * @return
	 */
	public static String clacDocumentNo(String templet,long currNo,Map<String,String> params){
		if( StringRegularOpt.isNvl( templet) )
			return String.valueOf(currNo);
		
		String sDocNo = templet;
		if (sDocNo.indexOf("$N") != -1) {
             int firstBegin = sDocNo.indexOf("$N");
             int firstEnd = firstBegin + 2;
             int secondBegin = sDocNo.indexOf("$", firstEnd);
             int nunber = 0;
             if(secondBegin>firstEnd )
	             nunber = Integer.parseInt(sDocNo.substring(firstEnd,
	                     secondBegin));
             
             sDocNo = sDocNo.substring(0,  firstBegin) + 
            		 fillZeroForString (String.valueOf(currNo), nunber)
            		 + sDocNo.substring(secondBegin+1);
		}    
		
		if(params !=null){
			for(Map.Entry<String,String> param : params.entrySet()){
				sDocNo = sDocNo.replaceAll("\\$"+param.getKey()+"\\$", 
						param.getValue());
			}
		}

		sDocNo = sDocNo.replaceAll("\\$year\\$", 
				String.valueOf(DatetimeOpt.getYear( DatetimeOpt.currentUtilDate())));
		sDocNo = sDocNo.replaceAll("\\$Y2\\$", 
				String.valueOf(DatetimeOpt.getYear( DatetimeOpt.currentUtilDate())).substring(2,4));
        
		return sDocNo;
	}
	
	/** 寻找比它大一个字符串 nextCode("0000200")=="0000201" 
	 * nextCode("000AZZZ")=="000BAAA" 
	 * @param sCode
	 * @return
	 */
	public static String nextCode( String sCode) {
		int nSL =  sCode.length();
		String sRes="";
		int i=nSL;
		while(i>0){
			i--;
			char c = sCode.charAt(i);
			if (c=='9') {
				sRes = '0' + sRes;
			}else if (c=='z') {
				sRes = 'a' + sRes;
			}else if (c=='Z') {
				sRes = 'A' + sRes;
			}else{
				c+=1;
				sRes = c + sRes;
				break;
			}
		}
		if(i>0)
			sRes = sCode.substring(0,i) + sRes;;
		return sRes;
	}
	
	
	// 国标码和区位码转换常量
	static final int GB_SP_DIFF = 160;
	// 存放国标一级汉字不同读音的起始区位码
	static final int[] secPosvalueList = { 1601, 1637, 1833, 2078, 2274, 2302,
	    2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027,
	    4086, 4390, 4558, 4684, 4925, 5249, 5600 };

	// 存放国标一级汉字不同读音的起始区位码对应读音
	/*private static final char[] firstLetter = { 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
	    'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'w', 'x',
	    'y', 'z' };*/

	// 获取一个字符串的拼音码

	/*private static char convertFirstLetter(byte[] bytes) {

	   char result = '-';
	   int secPosvalue = 0;
	   int i;
	   for (i = 0; i < bytes.length; i++) {
	    bytes[i] -= GB_SP_DIFF;
	   }
	   secPosvalue = bytes[0] * 100 + bytes[1];
	   for (i = 0; i < 23; i++) {
	    if (secPosvalue >= secPosvalueList[i]
	      && secPosvalue < secPosvalueList[i + 1]) {
	     result = firstLetter[i];
	     break;
	    }
	   }
	   return result;
	}*/
	
	/**
	* 获取一个汉字的拼音首字母。 GB码两个字节分别减去160，转换成10进制码组合就可以得到区位码
	* 例如汉字“你”的GB码是0xC4/0xE3，分别减去0xA0（160）就是0x24/0x43
	* 0x24转成10进制就是36，0x43是67，那么它的区位码就是3667，在对照表中读音为‘n’
	*/
	public static String getFirstLetter(String oriStr) {
		/*if(oriStr == null)
			return "";
	    String str = oriStr.toLowerCase();
	    StringBuffer buffer = new StringBuffer();
	    char ch;
	    char[] temp;
	    for (int i = 0; i < str.length(); i++) { // 依次处理str中每个字符
		    ch = str.charAt(i);
		    temp = new char[] { ch };
		    byte[] uniCode = new String(temp).getBytes();
		    if (uniCode[0] < 128 && uniCode[0] > 0) { // 非汉字
		    	buffer.append(temp);
		    } else {
		    	buffer.append(convertFirstLetter(uniCode));
		    }
	   }
	   return buffer.toString();*/
	    
	    StringBuilder sb = new StringBuilder();
	    for (int i = 0; i < oriStr.length(); i++) {
            String[] pinyin = PinyinHelper.toHanyuPinyinStringArray(oriStr.charAt(i));
            if(pinyin != null && pinyin.length > 0) 
            	sb.append(pinyin[0].charAt(0));
            else
            	sb.append(oriStr.charAt(i));
        }
	    
	    return sb.toString();
	}

	public static String readFileToBuffer( String sFileName) 
	{
		/* 一行一行的读出
		StringBuffer buffer = new StringBuffer();
		String line; // 用来保存每行读取的内容 
		BufferedReader reader;
		try {
			reader = new BufferedReader(new FileReader(sFileName));
		
			line = reader.readLine(); // 读取第一行 
			while (line != null) { // 如果 line 为空说明读完了 
				buffer.append(line); // 将读到的内容添加到 buffer 中 
				buffer.append("\r\n"); // 添加换行符 
				line = reader.readLine(); // 读取下一行 
			} 
			return buffer.toString();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} 
		*/
		
		//一次性全部读出
		FileInputStream in;
		try {
			in = new FileInputStream(sFileName);
			byte[] readBytes = new byte[in.available()];
			in.read(readBytes);
			in.close();
			return new String(readBytes); 
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	} 
	
	public static String readJarResourceToBuffer(Class<?> clazz, String sResourceName) 
	{
		//一次性全部读出	
		StringBuffer buffer = new StringBuffer();
		String line; // 用来保存每行读取的内容 
		InputStream in;
		try {
			//URL fileURL=clazz.getResource(sResourceName);    
			//log.debug(fileURL.getFile());  
		
			in = clazz.getResourceAsStream(sResourceName);  
			
			BufferedReader br=new BufferedReader(new InputStreamReader(in));   
			line = br.readLine(); // 读取第一行 
			while (line != null) { // 如果 line 为空说明读完了 
				buffer.append(line); // 将读到的内容添加到 buffer 中 
				buffer.append("\r\n"); // 添加换行符 
				line = br.readLine(); // 读取下一行 
			} 
			br.close();
			in.close();
			return buffer.toString();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	} 
	
	/**
	 * 将字符串转化为数据库查询语句(sql)中的字符串
	 * @param sParam
	 * @return
	 */
	public static String quotedString (String sParam)
	{
		if(sParam==null || "".equals(sParam))
			return "''";
		return "'" + sParam.replaceAll("'", "''")+"'";
	}
	

}
