package com.centit.support.utils;

public class WorkTimeSpan implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    private String sign;
    private long nDays;
    private long nHours;
    private long nMinutes;
    private static long dayWorkHours = 8;
    
	public static long getDayWorkHours() {
		return dayWorkHours;
	}

	public static void setDayWorkHours(long dayWorkHours) {
		WorkTimeSpan.dayWorkHours = dayWorkHours;
	}
	
    public WorkTimeSpan()
    {
        sign = "";
        nDays =0;
        nHours =0;
        nMinutes = 0;
    }
    public WorkTimeSpan(String sTimeSpan)
    {
        this.fromString(sTimeSpan);
    }
    
    public WorkTimeSpan(String sign, long days,long hours,long minutes)
    {
        this.sign = sign;
        nDays = days;
        nHours = hours;
        nMinutes = minutes;
    }
    
    public WorkTimeSpan( long days,long hours,long minutes)
    {
        sign = "";
        nDays = days;
        nHours = hours;
        nMinutes = minutes;
    }
  
    public void fromString(String sTimeSpan)
    {   
        sign = "";
        nDays =0;
        nHours =0;
        nMinutes = 0;
        if(sTimeSpan==null  || "".equals(sTimeSpan))
            return;

        char[] sc= sTimeSpan.toCharArray();
        int sl = sTimeSpan.length();
        int sp=0 ;
        while(sp<sl && sc[sp]==' ') sp++;            
        if(sc[sp]=='-'){
            sp++;
            sign = "-";
        }
       
        while(sp<sl){
           while(sp<sl && !Character.isDigit(sc[sp])) sp++; // 去除非数字
           if(sp>=sl) break;
           int nb=sp;
           while(sp<sl && Character.isDigit(sc[sp]))
               sp++;
           String digits = sTimeSpan.substring(nb,sp);
           while(sp<sl && !Character.isLetter(sc[sp]) && !Character.isDigit(sc[sp])) sp++; // 去除非空格
           if(sp>=sl){
               if(nDays==0)
                   nDays=Long.parseLong(digits);
               break;
           }
           if(Character.isDigit(sc[sp]))
               continue;
           
           switch (sc[sp]) {
           case 'D':
           case 'd':
                nDays=Long.parseLong(digits); 
                break;
           case 'H':
           case 'h':
               nHours=Long.parseLong(digits);
               break;
           case 'M':             
           case 'm':
              nMinutes=Long.parseLong(digits);
           default:
               break;
           }                 
       }          
    }
    
    /**
     * 返回时间中文描述
     * @return
     */
    public String getTimeSpanDesc()
    {
        return sign+(nDays!=0? nDays+"天":"") +
                (nHours!=0?nHours+"小时":"")+
                (nMinutes!=0?nMinutes+"分":"");
    }
    
    @Override
    public String toString()
    {
        return sign+(nDays!=0? nDays+"D":"") +
                (nHours!=0?nHours+"H":"")+
                (nMinutes!=0?nMinutes+"M":"");
    }
    /**
     * 每天8小时工作制
     * @return
     */
    public long toNumber()
    {
        long lSpan = nDays * dayWorkHours * 60 +  nHours * 60 + nMinutes; 
        if("-".equals(sign))
            lSpan = 0-lSpan;
        return lSpan;
    }
    
    /**
     * 每天8小时工作制
     * @return
     */
    public void fromNumber(long lSpan)
    {
        long tSpan = lSpan>0?lSpan:0-lSpan;
        long dayWorkMinutes = dayWorkHours * 60;
        sign = lSpan>0?"":"-";
        nDays = tSpan / dayWorkMinutes;
        nHours = tSpan % dayWorkMinutes / 60;
        nMinutes = tSpan % 60;
    }
    
    public long getDays() {
        return nDays;
    }

    public void setDays(long days) {
        this.nDays = days;
    }

    public long getHours() {
        return nHours;
    }

    public void setHours(long hours) {
        this.nHours = hours;
    }

    public long getMinutes() {
        return nMinutes;
    }

    public void setMinutes(long minutes) {
        this.nMinutes = minutes;
    }
	

}
