/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.config;

import com.centit.support.database.config.DirectConnDB;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectConn {
    private static Log log = LogFactory.getLog(DirectConn.class);
    public static List<String> hasLoadDrivers = new ArrayList<String>();
    public static Map<DirectConnDB, List<Connection>> connSpool = new HashMap<DirectConnDB, List<Connection>>();

    private DirectConn() {
    }

    private static void loadDBDriver(String driver) throws Exception {
        if (driver == null) {
            return;
        }
        if (hasLoadDrivers.contains(driver)) {
            return;
        }
        Class.forName(driver).newInstance();
        hasLoadDrivers.add(driver);
    }

    public static List<Connection> newConns(DirectConnDB dbc) throws Exception {
        DirectConn.loadDBDriver(dbc.getDriver());
        List<Connection> conns = connSpool.get(dbc);
        if (conns == null) {
            conns = new ArrayList<Connection>();
        }
        for (int n = conns.size(); n < 1 || n < dbc.getMaxConn(); ++n) {
            Connection conn = DriverManager.getConnection(dbc.getUrl(), dbc.getUser(), dbc.getPassword());
            conns.add(conn);
        }
        connSpool.put(dbc, conns);
        return conns;
    }

    public static boolean testConn(DirectConnDB dbc) {
        boolean connOk = false;
        try {
            DirectConn.loadDBDriver(dbc.getDriver());
            Connection conn = DriverManager.getConnection(dbc.getUrl(), dbc.getUser(), dbc.getPassword());
            if (conn != null) {
                connOk = true;
            }
            conn.close();
        }
        catch (Exception e) {
            log.error((Object)("\u6d4b\u8bd5\u8fde\u63a5" + dbc.getUrl() + "\u5931\u8d25:" + e.getMessage()));
            e.printStackTrace();
        }
        return connOk;
    }

    public static Connection getConn(DirectConnDB dbc) throws Exception {
        return DirectConn.getConn(dbc, 0);
    }

    public static Connection getConn(DirectConnDB dbc, int ind) throws Exception {
        List<Connection> conns = connSpool.get(dbc);
        if (conns == null || conns.size() < 1 || conns.size() < dbc.getMaxConn()) {
            conns = DirectConn.newConns(dbc);
        }
        int n = conns.size();
        return conns.get(ind % n);
    }

    public static void closeConn(DirectConnDB dbc) throws Exception {
        List<Connection> conns = connSpool.get(dbc);
        if (conns == null) {
            return;
        }
        for (Connection conn : conns) {
            try {
                if (conn == null || conn.isClosed()) continue;
                conn.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
        }
        connSpool.remove(dbc);
        conns.clear();
    }

    public static void closeAll() {
        for (Map.Entry<DirectConnDB, List<Connection>> cs : connSpool.entrySet()) {
            List<Connection> conns = cs.getValue();
            for (Connection conn : conns) {
                try {
                    if (conn == null || conn.isClosed()) continue;
                    conn.close();
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage());
                }
            }
            conns.clear();
        }
        connSpool.clear();
    }
}

