/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class JSONBinder {
    private ObjectMapper mapper = new ObjectMapper();

    public JSONBinder(JsonSerialize.Inclusion inclusion) {
        this.mapper.getSerializationConfig().withSerializationInclusion(inclusion);
        this.mapper.getDeserializationConfig().without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public static JSONBinder buildNormalBinder() {
        return new JSONBinder(JsonSerialize.Inclusion.ALWAYS);
    }

    public static JSONBinder buildNonNullBinder() {
        return new JSONBinder(JsonSerialize.Inclusion.NON_NULL);
    }

    public static JSONBinder buildNonDefaultBinder() {
        return new JSONBinder(JsonSerialize.Inclusion.NON_DEFAULT);
    }

    public <T> T jsonToObject(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((String)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String objectToJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDateFormat(String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            this.mapper.getSerializationConfig().withDateFormat((DateFormat)df);
            this.mapper.getDeserializationConfig().withDateFormat((DateFormat)df);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

