/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import com.centit.support.utils.DatetimeOpt;
import com.centit.support.utils.StringRegularOpt;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class StringBaseOpt {
    static final int GB_SP_DIFF = 160;
    static final int[] secPosvalueList = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5600};

    public static String encodeBase64(String str) {
        return new String(Base64.encodeBase64((byte[])str.getBytes()));
    }

    public static String decodeBase64(String str) {
        return new String(Base64.decodeBase64((byte[])str.getBytes()));
    }

    private static Key getDesStaticKey() throws Exception {
        DESKeySpec dks = new DESKeySpec(Base64.encodeBase64((byte[])"0123456789abcdefghijklmnopqrstuvwxyzABCDEF".getBytes()));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(dks);
        return secretKey;
    }

    public static byte[] decryptDes(byte[] data) throws Exception {
        Key k = StringBaseOpt.getDesStaticKey();
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static byte[] encryptDes(byte[] data) throws Exception {
        Key k = StringBaseOpt.getDesStaticKey();
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String encryptDesBase64(String str) {
        try {
            return new String(Base64.encodeBase64((byte[])StringBaseOpt.encryptDes(str.getBytes())));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decryptBase64Des(String str) {
        try {
            return new String(StringBaseOpt.decryptDes(Base64.decodeBase64((byte[])str.getBytes())));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] compress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        return out.toByteArray();
    }

    public static String unCompress(byte[] str) throws IOException {
        if (null == str || str.length <= 0) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str);
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        int n = 0;
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("utf-8");
    }

    public static boolean contains(String[] strs, String str) {
        boolean in = false;
        if (strs == null) {
            return in;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (!strs[i].contains(str)) continue;
            in = true;
        }
        return in;
    }

    public static String deleteStringByQuote(String str, String quote) {
        if (null == str || "".equals(str)) {
            return "";
        }
        return StringUtils.replace((String)str.trim(), (String)("_" + quote), (String)"");
    }

    public static int indexOf(String[] strs, String str) {
        int index = -1;
        if (null != strs) {
            for (int i = 0; i < strs.length; ++i) {
                if (!strs[i].contains(str)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static boolean isNvl(String str) {
        return str == null || "".equals(str.trim());
    }

    public static String fillZeroForString(String str, int size) {
        if (StringBaseOpt.isNvl(str)) {
            str = "0";
        }
        if (size == 0) {
            return str;
        }
        for (int sl = str.length(); sl < size; ++sl) {
            str = "0" + str;
        }
        return str;
    }

    public static String clacDocumentNo(String templet, long currNo, Map<String, String> params) {
        if (StringRegularOpt.isNvl(templet)) {
            return String.valueOf(currNo);
        }
        String sDocNo = templet;
        if (sDocNo.indexOf("$N") != -1) {
            int firstBegin = sDocNo.indexOf("$N");
            int firstEnd = firstBegin + 2;
            int secondBegin = sDocNo.indexOf("$", firstEnd);
            int nunber = 0;
            if (secondBegin > firstEnd) {
                nunber = Integer.parseInt(sDocNo.substring(firstEnd, secondBegin));
            }
            sDocNo = sDocNo.substring(0, firstBegin) + StringBaseOpt.fillZeroForString(String.valueOf(currNo), nunber) + sDocNo.substring(secondBegin + 1);
        }
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                sDocNo = sDocNo.replaceAll("\\$" + param.getKey() + "\\$", param.getValue());
            }
        }
        sDocNo = sDocNo.replaceAll("\\$year\\$", String.valueOf(DatetimeOpt.getYear(DatetimeOpt.currentUtilDate())));
        sDocNo = sDocNo.replaceAll("\\$Y2\\$", String.valueOf(DatetimeOpt.getYear(DatetimeOpt.currentUtilDate())).substring(2, 4));
        return sDocNo;
    }

    public static String nextCode(String sCode) {
        int nSL = sCode.length();
        String sRes = "";
        int i = nSL;
        while (i > 0) {
            char c;
            if ((c = sCode.charAt(--i)) == '9') {
                sRes = '0' + sRes;
                continue;
            }
            if (c == 'z') {
                sRes = 'a' + sRes;
                continue;
            }
            if (c == 'Z') {
                sRes = 'A' + sRes;
                continue;
            }
            c = (char)(c + '\u0001');
            sRes = c + sRes;
            break;
        }
        if (i > 0) {
            sRes = sCode.substring(0, i) + sRes;
        }
        return sRes;
    }

    public static String getFirstLetter(String oriStr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < oriStr.length(); ++i) {
            String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)oriStr.charAt(i));
            if (pinyin != null && pinyin.length > 0) {
                sb.append(pinyin[0].charAt(0));
                continue;
            }
            sb.append(oriStr.charAt(i));
        }
        return sb.toString();
    }

    public static String readFileToBuffer(String sFileName) {
        try {
            FileInputStream in = new FileInputStream(sFileName);
            byte[] readBytes = new byte[in.available()];
            in.read(readBytes);
            in.close();
            return new String(readBytes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String readJarResourceToBuffer(Class<?> clazz, String sResourceName) {
        StringBuffer buffer = new StringBuffer();
        try {
            InputStream in = clazz.getResourceAsStream(sResourceName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append("\r\n");
                line = br.readLine();
            }
            br.close();
            in.close();
            return buffer.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String quotedString(String sParam) {
        if (sParam == null || "".equals(sParam)) {
            return "''";
        }
        return "'" + sParam.replaceAll("'", "''") + "'";
    }
}

