/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.io.Serializable;

public class WorkTimeSpan
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sign;
    private long nDays;
    private long nHours;
    private long nMinutes;
    private static long dayWorkHours = 8L;

    public static long getDayWorkHours() {
        return dayWorkHours;
    }

    public static void setDayWorkHours(long dayWorkHours) {
        WorkTimeSpan.dayWorkHours = dayWorkHours;
    }

    public WorkTimeSpan() {
        this.sign = "";
        this.nDays = 0L;
        this.nHours = 0L;
        this.nMinutes = 0L;
    }

    public WorkTimeSpan(String sTimeSpan) {
        this.fromString(sTimeSpan);
    }

    public WorkTimeSpan(String sign, long days, long hours, long minutes) {
        this.sign = sign;
        this.nDays = days;
        this.nHours = hours;
        this.nMinutes = minutes;
    }

    public WorkTimeSpan(long days, long hours, long minutes) {
        this.sign = "";
        this.nDays = days;
        this.nHours = hours;
        this.nMinutes = minutes;
    }

    public void fromString(String sTimeSpan) {
        int sp;
        this.sign = "";
        this.nDays = 0L;
        this.nHours = 0L;
        this.nMinutes = 0L;
        if (sTimeSpan == null || "".equals(sTimeSpan)) {
            return;
        }
        char[] sc = sTimeSpan.toCharArray();
        int sl = sTimeSpan.length();
        for (sp = 0; sp < sl && sc[sp] == ' '; ++sp) {
        }
        if (sc[sp] == '-') {
            ++sp;
            this.sign = "-";
        }
        while (sp < sl) {
            while (sp < sl && !Character.isDigit(sc[sp])) {
                ++sp;
            }
            if (sp >= sl) break;
            int nb = sp;
            while (sp < sl && Character.isDigit(sc[sp])) {
                ++sp;
            }
            String digits = sTimeSpan.substring(nb, sp);
            while (sp < sl && !Character.isLetter(sc[sp]) && !Character.isDigit(sc[sp])) {
                ++sp;
            }
            if (sp >= sl) {
                if (this.nDays != 0L) break;
                this.nDays = Long.parseLong(digits);
                break;
            }
            if (Character.isDigit(sc[sp])) continue;
            switch (sc[sp]) {
                case 'D': 
                case 'd': {
                    this.nDays = Long.parseLong(digits);
                    break;
                }
                case 'H': 
                case 'h': {
                    this.nHours = Long.parseLong(digits);
                    break;
                }
                case 'M': 
                case 'm': {
                    this.nMinutes = Long.parseLong(digits);
                }
            }
        }
    }

    public String getTimeSpanDesc() {
        return this.sign + (this.nDays != 0L ? this.nDays + "\u5929" : "") + (this.nHours != 0L ? this.nHours + "\u5c0f\u65f6" : "") + (this.nMinutes != 0L ? this.nMinutes + "\u5206" : "");
    }

    public String toString() {
        return this.sign + (this.nDays != 0L ? this.nDays + "D" : "") + (this.nHours != 0L ? this.nHours + "H" : "") + (this.nMinutes != 0L ? this.nMinutes + "M" : "");
    }

    public long toNumber() {
        long lSpan = this.nDays * dayWorkHours * 60L + this.nHours * 60L + this.nMinutes;
        if ("-".equals(this.sign)) {
            lSpan = 0L - lSpan;
        }
        return lSpan;
    }

    public void fromNumber(long lSpan) {
        long tSpan = lSpan > 0L ? lSpan : 0L - lSpan;
        long dayWorkMinutes = dayWorkHours * 60L;
        this.sign = lSpan > 0L ? "" : "-";
        this.nDays = tSpan / dayWorkMinutes;
        this.nHours = tSpan % dayWorkMinutes / 60L;
        this.nMinutes = tSpan % 60L;
    }

    public long getDays() {
        return this.nDays;
    }

    public void setDays(long days) {
        this.nDays = days;
    }

    public long getHours() {
        return this.nHours;
    }

    public void setHours(long hours) {
        this.nHours = hours;
    }

    public long getMinutes() {
        return this.nMinutes;
    }

    public void setMinutes(long minutes) {
        this.nMinutes = minutes;
    }
}

