/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class XmlUtils {
    private static Log logger = LogFactory.getLog(XmlUtils.class);

    public static Document string2xml(String xmlStr) {
        Document xmlDoc = null;
        try {
            xmlDoc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return xmlDoc;
    }

    public static String encodeString(String strData) {
        if (strData == null) {
            return "";
        }
        StringBuilder xmlData = new StringBuilder();
        block7: for (int i = 0; i < strData.length(); ++i) {
            switch (strData.charAt(i)) {
                case '&': {
                    xmlData.append("&amp;");
                    continue block7;
                }
                case '<': {
                    xmlData.append("&lt;");
                    continue block7;
                }
                case '>': {
                    xmlData.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    xmlData.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    xmlData.append("&apos;");
                    continue block7;
                }
                default: {
                    xmlData.append(strData.charAt(i));
                }
            }
        }
        return strData;
    }

    public static String decodeString(String xmlData) {
        String strData = xmlData.replaceAll("&lt;", "<");
        strData = strData.replaceAll("&gt;", ">");
        strData = strData.replaceAll("&apos;", "'");
        strData = strData.replaceAll("&quot;", "\"");
        strData = strData.replaceAll("&amp;", "&");
        return strData;
    }
}

