/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.config;

import com.centit.support.database.config.DBConfig;
import com.centit.support.database.config.DBType;
import com.centit.support.database.config.DirectConn;
import com.centit.support.utils.xml.IgnoreDTDEntityResolver;
import java.io.File;
import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class DirectConnDB
implements DBConfig {
    private String url;
    private String user;
    private String driver;
    private String psd;
    private DBType dbType;
    private int maxConn;
    private static Log log = LogFactory.getLog(DBConfig.class);

    public DirectConnDB() {
        this.maxConn = 1;
    }

    public DirectConnDB(String url, String user, String psd) {
        this.url = url;
        this.user = user;
        this.psd = psd;
        this.dbType = DBType.mapDBType(url);
        this.driver = DBType.getDbDriver(this.dbType);
        this.maxConn = 1;
    }

    public void loadHibernateConfig(String sConfFile, String sDbBeanName) {
        SAXReader builder = new SAXReader(false);
        builder.setValidation(false);
        builder.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        Document doc = null;
        Element bean = null;
        this.maxConn = 1;
        try {
            doc = sConfFile.indexOf(58) >= 0 ? (sConfFile.startsWith("classpath:") ? builder.read(this.getClass().getResourceAsStream(sConfFile.substring(10))) : builder.read(new File(sConfFile))) : builder.read(this.getClass().getResourceAsStream(sConfFile));
            Element root = doc.getRootElement();
            bean = (Element)root.selectSingleNode("bean[@id=\"" + sDbBeanName + "\"]");
            if (bean != null) {
                Element property = (Element)bean.selectSingleNode("property[@name=\"driverClassName\"]");
                if (property != null) {
                    this.driver = property.attributeValue("value");
                }
                log.debug((Object)this.driver);
                property = (Element)bean.selectSingleNode("property[@name=\"url\"]");
                if (property != null) {
                    this.url = property.attributeValue("value");
                }
                if ((property = (Element)bean.selectSingleNode("property[@name=\"username\"]")) != null) {
                    this.user = property.attributeValue("value");
                }
                if ((property = (Element)bean.selectSingleNode("property[@name=\"password\"]")) != null) {
                    this.psd = property.attributeValue("value");
                }
            }
        }
        catch (DocumentException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        this.dbType = DBType.mapDBType(this.url);
    }

    @Override
    public DBType getDbType() {
        return this.dbType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.psd;
    }

    public void setPassword(String password) {
        this.psd = password;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn;
    }

    public void praiseConnUrl(String dbUrl) {
        this.url = dbUrl;
        this.dbType = DBType.mapDBType(dbUrl);
        this.driver = DBType.getDbDriver(this.dbType);
    }

    public boolean equals(Object dbco) {
        if (dbco instanceof DirectConnDB) {
            DirectConnDB dbc = (DirectConnDB)dbco;
            return this.url != null && this.url.equals(dbc.getUrl()) && this.user != null && this.user.equals(dbc.getUser());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        result = 37 * result + (this.getUser() == null ? 0 : this.getUser().hashCode());
        return result;
    }

    @Override
    public String getDbSchema() {
        return this.getUser();
    }

    @Override
    public Connection getConn() throws Exception {
        return DirectConn.getConn(this);
    }
}

