/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.config.DBConfig;
import com.centit.support.database.metadata.Database;
import com.centit.support.database.metadata.ReferenceMetadata;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class IbmDb2Database
implements Database {
    private static final String sqlGetTabColumns = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private static final String sqlPKInfo = "select constname, colname from sysibm.syskeycoluse where tbcreator=? and tbname=? order by colseq";
    private static final String sqlFKInfo = "select tbname, relname, colcount, fkcolnames, pkcolnames from sysibm.sysrels where refkeyname= ?";
    private static final String sqlFKColumn = "select a.name,a.coltype,a.length, a.scale, a.nulls from sysibm.systables b , sysibm.syscolumns a where a.tbcreator= ? and a.tbname= ? and a.name= ? and b.name=a.tbname and b.creator=a.tbcreator";
    private String sDBSchema;
    private DBConfig dbc;

    @Override
    public void setDBConfig(DBConfig dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        if (schema != null) {
            this.sDBSchema = schema.toUpperCase();
        }
    }

    @Override
    public TableMetadata getTableMetadata(String tabName) {
        TableMetadata tab = new TableMetadata(tabName);
        try {
            Connection conn = this.dbc.getConn();
            tab.setSchema(this.dbc.getDbSchema().toUpperCase());
            PreparedStatement pStmt = conn.prepareStatement(sqlGetTabColumns);
            pStmt.setString(1, this.sDBSchema);
            pStmt.setString(2, tabName);
            ResultSet rs = pStmt.executeQuery();
            while (rs.next()) {
                TableField field = new TableField();
                field.setColumn(rs.getString("name"));
                field.setDBType(rs.getString("coltype"));
                field.setMaxLength(rs.getInt("length"));
                field.setPrecision(field.getMaxLength());
                field.setScale(rs.getInt("scale"));
                field.setNullEnable(rs.getString("nulls"));
                field.mapToMetadata();
                tab.getColumns().add(field);
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlPKInfo);
            pStmt.setString(1, this.sDBSchema);
            pStmt.setString(2, tabName);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                tab.setPkName(rs.getString("constname"));
                tab.getPkColumns().add(rs.getString("colname"));
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlFKInfo);
            pStmt.setString(1, tab.getPkName());
            rs = pStmt.executeQuery();
            while (rs.next()) {
                ReferenceMetadata ref = new ReferenceMetadata();
                ref.setTableName(rs.getString("tbname"));
                ref.setReferenceCode(rs.getString("relname"));
                int nColCount = rs.getInt("colcount");
                String sFColNames = rs.getString("fkcolnames").trim();
                String[] p = sFColNames.split("\\s+");
                if (nColCount != p.length) {
                    System.out.println("\u5916\u952e" + ref.getReferenceCode() + "\u5b57\u6bb5\u5206\u9694\u51fa\u9519\uff01");
                }
                for (int i = 0; i < p.length; ++i) {
                    TableField field = new TableField();
                    field.setColumn(p[i]);
                    ref.getFkcolumns().add(field);
                }
                tab.getReferences().add(ref);
            }
            rs.close();
            pStmt.close();
            for (ReferenceMetadata ref : tab.getReferences()) {
                for (TableField field : ref.getFkcolumns()) {
                    pStmt = conn.prepareStatement(sqlFKColumn);
                    pStmt.setString(1, this.sDBSchema);
                    pStmt.setString(2, ref.getTableName());
                    pStmt.setString(3, field.getColumn());
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        field.setDBType(rs.getString("coltype"));
                        field.setMaxLength(rs.getInt("length"));
                        field.setPrecision(field.getMaxLength());
                        field.setScale(rs.getInt("scale"));
                        field.setNullEnable(rs.getString("nulls"));
                        field.mapToMetadata();
                    }
                    rs.close();
                    pStmt.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tab;
    }
}

