/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.config.DBConfig;
import com.centit.support.database.metadata.Database;
import com.centit.support.database.metadata.ReferenceMetadata;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class MsSqlsvrDatabase
implements Database {
    private static final String sqlGetTabColumns = "SELECT  a.name, c.name AS typename, a.length , a.xprec, a.xscale, isnullable FROM syscolumns a INNER JOIN sysobjects b ON a.id = b.id INNER JOIN systypes c ON a.xtype = c.xtype WHERE b.xtype = 'U' and b.name = ? ORDER BY a.colorder";
    private static final String sqlPKName = "select a.name,a.object_id, a.parent_object_id ,a.unique_index_id  from sys.key_constraints a , sysobjects b where a.type='PK' and  a.parent_object_id=b.id and b.xtype = 'U' and b.name = ? ";
    private static final String sqlPKColumns = "select a.name from sys.index_columns b join sys.columns a on(a.object_id=b.object_id and a.column_id=b.column_id) where b.object_id=? and b.index_id=? order by b.key_ordinal";
    private static final String sqlFKNames = "select a.name,a.object_id,a.parent_object_id , b.name as tabname from sys.foreign_keys a join sysobjects b ON a.parent_object_id = b.id where referenced_object_id = ? ";
    private static final String sqlFKColumns = "SELECT  a.name, c.name AS typename, a.length , a.xprec, a.xscale, isnullable FROM syscolumns a INNER JOIN sys.foreign_key_columns b ON a.id = b.parent_object_id  and b.parent_column_id=a.colid JOIN systypes c ON a.xtype = c.xtype WHERE b.constraint_object_id=? ORDER BY b.constraint_column_id";
    private String sDBSchema;
    private DBConfig dbc;

    @Override
    public void setDBConfig(DBConfig dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        this.sDBSchema = schema;
    }

    @Override
    public TableMetadata getTableMetadata(String tabName) {
        TableMetadata tab = new TableMetadata(tabName);
        int table_id = 0;
        int pk_ind_id = 0;
        try {
            Connection conn = this.dbc.getConn();
            tab.setSchema(this.dbc.getDbSchema().toUpperCase());
            PreparedStatement pStmt = conn.prepareStatement(sqlGetTabColumns);
            pStmt.setString(1, tabName);
            ResultSet rs = pStmt.executeQuery();
            while (rs.next()) {
                TableField field = new TableField();
                field.setColumn(rs.getString("name"));
                field.setDBType(rs.getString("typename"));
                field.setMaxLength(rs.getInt("length"));
                field.setPrecision(rs.getInt("xprec"));
                field.setScale(rs.getInt("xscale"));
                field.setNullEnable(rs.getString("isnullable"));
                field.mapToMetadata();
                tab.getColumns().add(field);
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlPKName);
            pStmt.setString(1, tabName);
            rs = pStmt.executeQuery();
            if (rs.next()) {
                tab.setPkName(rs.getString("name"));
                table_id = rs.getInt("parent_object_id");
                pk_ind_id = rs.getInt("unique_index_id");
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlPKColumns);
            pStmt.setInt(1, table_id);
            pStmt.setInt(2, pk_ind_id);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                tab.getPkColumns().add(rs.getString("name"));
            }
            rs.close();
            pStmt.close();
            pStmt = conn.prepareStatement(sqlFKNames);
            pStmt.setInt(1, table_id);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                ReferenceMetadata ref = new ReferenceMetadata();
                ref.setTableName(rs.getString("tabname"));
                ref.setReferenceCode(rs.getString("name"));
                ref.setObjectId(rs.getInt("object_id"));
                tab.getReferences().add(ref);
            }
            rs.close();
            pStmt.close();
            for (ReferenceMetadata ref : tab.getReferences()) {
                pStmt = conn.prepareStatement(sqlFKColumns);
                pStmt.setInt(1, ref.getObjectId());
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    TableField field = new TableField();
                    field.setColumn(rs.getString("name"));
                    field.setDBType(rs.getString("typename"));
                    field.setMaxLength(rs.getInt("length"));
                    field.setPrecision(rs.getInt("xprec"));
                    field.setScale(rs.getInt("xscale"));
                    field.setNullEnable(rs.getString("isnullable"));
                    field.mapToMetadata();
                    ref.getFkcolumns().add(field);
                }
                rs.close();
                pStmt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tab;
    }
}

