/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSystemOpt {
    public static List<File> findFilesByExt(String dir, String extName) {
        File dirFile = new File(dir);
        File[] fileArray = dirFile.listFiles();
        ArrayList<File> resFiles = new ArrayList<File>();
        if (null == fileArray) {
            return resFiles;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || !fileArray[i].getName().endsWith(extName)) continue;
            resFiles.add(fileArray[i]);
        }
        return resFiles;
    }

    public static List<File> findFiles(String s) {
        return FileSystemOpt.findFiles("./", s);
    }

    public static List<File> findFiles(String dir, String s) {
        File file = new File(dir);
        s = s.replace('.', '#');
        s = s.replaceAll("#", "\\\\.");
        s = s.replace('*', '#');
        s = s.replaceAll("#", ".*");
        s = s.replace('?', '#');
        s = s.replaceAll("#", ".?");
        s = "^" + s + "$";
        Pattern p = Pattern.compile(s);
        return FileSystemOpt.filePattern(file, p);
    }

    private static List<File> filePattern(File file, Pattern p) {
        File[] files;
        if (file == null) {
            return null;
        }
        if (file.isFile()) {
            Matcher fMatcher = p.matcher(file.getName());
            if (fMatcher.matches()) {
                ArrayList<File> list = new ArrayList<File>();
                list.add(file);
                return list;
            }
        } else if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                List<File> rlist = FileSystemOpt.filePattern(files[i], p);
                if (rlist == null) continue;
                list.addAll(rlist);
            }
            return list;
        }
        return null;
    }

    public static boolean existFile(String sFilePath) {
        File f = new File(sFilePath);
        return f.exists();
    }

    public static void createDirect(String sDirPath) {
        File f = new File(sDirPath);
        if (f.exists()) {
            return;
        }
        f.mkdirs();
    }

    public static String extractFileName(String filePath) {
        int nEnd;
        int nl;
        int nPos;
        if (filePath == null) {
            return "";
        }
        for (nPos = nl = filePath.length(); nPos > 0 && filePath.charAt(nPos - 1) != '\\' && filePath.charAt(nPos - 1) != '/'; --nPos) {
        }
        for (nEnd = nPos; nEnd < nl && filePath.charAt(nEnd) != '.'; ++nEnd) {
        }
        return filePath.substring(nPos, nEnd);
    }
}

