/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.utils;

import com.centit.support.utils.ReflectionOpt;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JSONOpt {
    private static JSONKey praseJosnKey(String skey) {
        JSONKey key = new JSONKey();
        key.ind = -1;
        int nL = skey.indexOf(91);
        if (nL > 0) {
            key.skey = skey.substring(0, nL);
            int nR = skey.indexOf(93);
            key.ind = nR > nL + 1 ? Integer.parseInt(skey.substring(nL + 1, nR)) : 0;
        } else {
            key.skey = skey;
        }
        return key;
    }

    private static JSONPath findJsonObject(JSONObject objJson, int depth, String[] skeys) {
        JSONPath p = new JSONPath();
        int nLast = 0;
        JSONObject lastKeyJson = objJson;
        while (nLast < depth) {
            Object obj2;
            JSONArray jarray;
            JSONKey key = JSONOpt.praseJosnKey(skeys[nLast]);
            if (!lastKeyJson.has(key.skey)) break;
            Object obj = lastKeyJson.get(key.skey);
            if (obj instanceof JSONObject) {
                if (key.ind >= 0) break;
                lastKeyJson = (JSONObject)obj;
                ++nLast;
                continue;
            }
            if (!(obj instanceof JSONArray) || key.ind < 0 || key.ind >= (jarray = (JSONArray)obj).size() || !((obj2 = jarray.get(key.ind)) instanceof JSONObject)) break;
            lastKeyJson = (JSONObject)obj2;
            ++nLast;
        }
        p.found = true;
        p.pathPos = nLast;
        p.objJson = lastKeyJson;
        return p;
    }

    public static JSONObject findJsonObject(JSONObject objJson, String[] skeys) {
        int depth = skeys.length;
        if (depth < 1) {
            return null;
        }
        JSONPath path = JSONOpt.findJsonObject(objJson, depth, skeys);
        if (path.pathPos != depth) {
            return null;
        }
        return path.objJson;
    }

    public static JSONObject findJsonObject(JSONObject objJson, String path) {
        String[] skeys = path.split("\\x2E");
        return JSONOpt.findJsonObject(objJson, skeys);
    }

    private static JSONObject createJsonObject(String[] skeys, int beginPos, Object value) {
        int depth = skeys.length;
        if (depth == 0) {
            return null;
        }
        int nLast = beginPos;
        JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
        JSONObject leafKey = new JSONObject();
        if (key.ind < 0) {
            leafKey.element(key.skey, value);
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, value);
            leafKey.element(key.skey, (Collection)jarray);
        }
        depth -= 2;
        while (depth >= nLast) {
            key = JSONOpt.praseJosnKey(skeys[depth]);
            JSONObject tempKey = new JSONObject();
            if (key.ind < 0) {
                tempKey.element(key.skey, (Map)leafKey);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, (Object)leafKey);
                tempKey.element(key.skey, (Collection)jarray);
            }
            leafKey = tempKey;
            --depth;
        }
        return leafKey;
    }

    public static void setAttribute(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.createJsonObject(skeys, jpath.pathPos + 1, value);
        }
        JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
        if (key.ind < 0) {
            jpath.objJson.element(key.skey, jsonValue);
        } else if (jpath.objJson.has(key.skey)) {
            Object leafJson = jpath.objJson.get(key.skey);
            if (leafJson instanceof JSONArray) {
                JSONArray jarray = (JSONArray)leafJson;
                if (jarray.size() < key.ind + 1) {
                    for (int i = jarray.size(); i < key.ind; ++i) {
                        jarray.add(i, null);
                    }
                    jarray.add(key.ind, jsonValue);
                } else if (jpath.pathPos == depth - 1 && jsonValue instanceof Map) {
                    Object obj = jarray.get(key.ind);
                    if (obj instanceof JSONObject) {
                        for (Map.Entry ent : ((Map)value).entrySet()) {
                            ((JSONObject)obj).element(ent.getKey().toString(), ent.getValue());
                        }
                    } else {
                        jarray.set(key.ind, jsonValue);
                    }
                } else {
                    jarray.set(key.ind, jsonValue);
                }
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.element(key.skey, (Collection)jarray);
            }
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, jsonValue);
            jpath.objJson.element(key.skey, (Collection)jarray);
        }
    }

    public static void appendData(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.createJsonObject(skeys, jpath.pathPos + 1, value);
            JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
            if (key.ind < 0) {
                jpath.objJson.element(key.skey, jsonValue);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.element(key.skey, (Collection)jarray);
            }
        } else {
            JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
            if (jpath.objJson.has(key.skey)) {
                jpath.objJson.accumulate(key.skey, value);
            } else if (key.ind < 0) {
                jpath.objJson.element(key.skey, value);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, value);
                jpath.objJson.element(key.skey, (Collection)jarray);
            }
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Object[] values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Collection<Object> values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    public static JSON objectToJSON(Object obj) {
        return JSONOpt.objectToJSON(obj, false, false);
    }

    public static JSON objectToJSON(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj instanceof JSON) {
            return (JSON)obj;
        }
        if (ReflectionOpt.isArray(obj)) {
            return JSONOpt.arrayToJSONArray(obj, methodOnly, fieldOnly, includePrivateField);
        }
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, includePrivateField);
    }

    public static JSON objectToJSON(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSON(obj, methodOnly, fieldOnly, false);
    }

    public static JSONObject objectToJSONObject(Object obj) {
        return JSONOpt.objectToJSONObject(obj, false, false, false);
    }

    private static Object makeJSONValue(Object value, boolean methodOnly, boolean fieldOnly) {
        if (value == null) {
            return null;
        }
        if (ReflectionOpt.isPrimitiveType(value.getClass())) {
            return value;
        }
        return JSONOpt.objectToJSON(value, methodOnly, fieldOnly);
    }

    public static JSONObject objectToJSONObject(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        JSONObject jObj = new JSONObject();
        if (ReflectionOpt.isPrimitiveType(obj.getClass())) {
            jObj.element("value", (Object)obj.toString());
            return jObj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry ent : map.entrySet()) {
                jObj.element(ent.getKey().toString(), JSONOpt.makeJSONValue(ent.getValue(), methodOnly, fieldOnly));
            }
            return jObj;
        }
        ArrayList<String> methodNames = new ArrayList<String>();
        List<Method> getMethods = ReflectionOpt.getAllGetterMethod(obj.getClass());
        if (!fieldOnly && getMethods != null) {
            for (Method m : getMethods) {
                String fieldName = ReflectionOpt.methodNameToField(m.getName());
                methodNames.add(fieldName);
                Object value = null;
                try {
                    value = m.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                jObj.element(fieldName, JSONOpt.makeJSONValue(value, methodOnly, fieldOnly));
            }
        }
        Field[] fls = ReflectionOpt.getFields(obj);
        if (!methodOnly && fls != null) {
            for (Field fl : fls) {
                if (methodNames.contains(fl.getName())) continue;
                try {
                    if (!includePrivateField && !Modifier.isPublic(fl.getModifiers())) continue;
                    Object value = ReflectionOpt.forceGetFieldValue(obj, fl);
                    jObj.element(fl.getName(), JSONOpt.makeJSONValue(value, methodOnly, fieldOnly));
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(fls != null && fls.length >= 1 || getMethods != null && getMethods.size() >= 1)) {
            jObj.element("value", (Object)obj.toString());
        }
        return jObj;
    }

    public static JSONObject objectToJSONObject(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, false);
    }

    public static JSONArray arrayToJSONArray(Object obj) {
        return JSONOpt.arrayToJSONArray(obj, false, false, false);
    }

    public static JSONArray arrayToJSONArray(Object objArray, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        JSONArray jArray;
        block10: {
            char[] objList;
            block15: {
                double[] objList2;
                block14: {
                    float[] objList3;
                    block13: {
                        long[] objList4;
                        block12: {
                            int[] objList5;
                            block11: {
                                block9: {
                                    Object[] objList6;
                                    if (objArray == null) {
                                        return null;
                                    }
                                    if (objArray instanceof JSONArray) {
                                        return (JSONArray)objArray;
                                    }
                                    jArray = new JSONArray();
                                    if (!(objArray instanceof Object[])) break block9;
                                    for (Object obj : objList6 = (Object[])objArray) {
                                        jArray.add(JSONOpt.makeJSONValue(obj, methodOnly, fieldOnly));
                                    }
                                    break block10;
                                }
                                if (!(objArray instanceof Collection)) break block11;
                                Collection objList7 = (Collection)objArray;
                                for (Object obj : objList7) {
                                    jArray.add(JSONOpt.makeJSONValue(obj, methodOnly, fieldOnly));
                                }
                                break block10;
                            }
                            if (!"[I".equals(objArray.getClass().getName())) break block12;
                            for (int obj : objList5 = (int[])objArray) {
                                jArray.add((Object)obj);
                            }
                            break block10;
                        }
                        if (!"[J".equals(objArray.getClass().getName())) break block13;
                        for (long obj : objList4 = (long[])objArray) {
                            jArray.add((Object)obj);
                        }
                        break block10;
                    }
                    if (!"[F".equals(objArray.getClass().getName())) break block14;
                    for (float obj : objList3 = (float[])objArray) {
                        jArray.add((Object)Float.valueOf(obj));
                    }
                    break block10;
                }
                if (!"[D".equals(objArray.getClass().getName())) break block15;
                for (double obj : objList2 = (double[])objArray) {
                    jArray.add((Object)obj);
                }
                break block10;
            }
            if (!"[C".equals(objArray.getClass().getName())) break block10;
            for (char obj : objList = (char[])objArray) {
                jArray.add((Object)Character.valueOf(obj));
            }
        }
        return jArray;
    }

    public static JSONArray arrayToJSONArray(Object objArray, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.arrayToJSONArray(objArray, methodOnly, fieldOnly, false);
    }

    static class JSONKey {
        String skey;
        int ind;

        JSONKey() {
        }
    }

    static class JSONPath {
        JSONObject objJson;
        String path;
        boolean found;
        int pathPos;

        JSONPath() {
        }
    }
}

