package com.centit.support.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

import com.centit.support.security.AESSecurityUtils;

public abstract class FileEncryptWithAes {

	/**
	 * 文件file进行加密并保存目标文件destFile中
	 * 
	 * @param file
	 *            要加密的文件 如c:/test/srcFile.txt
	 * @param destFile
	 *            加密后存放的文件名 如c:/加密后文件.txt
	 */
	public static void encrypt(String sourceFileName, String diminationFileName,String keyValue) 
			throws Exception {
		encrypt(new File(sourceFileName), new File( diminationFileName), keyValue);
	}

	/**
	 * 文件file进行加密并保存目标文件destFile中
	 * 
	 * @param file
	 *            要加密的文件 如c:/test/srcFile.txt
	 * @param destFile
	 *            加密后存放的文件名 如c:/加密后文件.txt
	 * @throws GeneralSecurityException 
	 * @throws Exception 
	 * @throws IOException 
	 */
	public static void encrypt(InputStream sourceFile, OutputStream diminationFile,String keyValue) 
			throws IOException, GeneralSecurityException 
	{
		try(CipherInputStream cis = new CipherInputStream(sourceFile, AESSecurityUtils.createEncryptCipher(keyValue)))
		{
			byte[] buffer = new byte[1024];
			int r;
			while ((r = cis.read(buffer)) > 0) {
				diminationFile.write(buffer, 0, r);
			}
			//cis.close();
			//is.close();
			//out.close();
		}
	}
	
	public static void encrypt(File sourceFile, File diminationFile,String keyValue)
			throws IOException, GeneralSecurityException 
	{
		try( InputStream is = new FileInputStream(sourceFile);
				OutputStream out = new FileOutputStream(diminationFile))
		{
			encrypt(is,out,keyValue);
		}
	}
	
	/**
	 * 文件采用AS算法解密文件
	 * 
	 * @param file
	 *            已加密的文件 如c:/加密后文件.txt * @param destFile 解密后存放的文件名 如c:/
	 *            test/解密后文件.txt
	 */
	public static void decrypt(String sourceFileName, String diminationFileName,String keyValue) 
			throws IOException, GeneralSecurityException  {		
		decrypt(new File(sourceFileName), new File( diminationFileName), keyValue);
	}
	
	/**
	 * 文件采用AS算法解密文件
	 * 
	 * @param file
	 *            已加密的文件 如c:/加密后文件.txt * @param destFile 解密后存放的文件名 如c:/
	 *            test/解密后文件.txt
	 */
	public static void decrypt(InputStream sourceFile, OutputStream diminationFile,String keyValue)
			throws IOException, GeneralSecurityException {
		try(
				CipherOutputStream cos = new CipherOutputStream(diminationFile, AESSecurityUtils.createDencryptCipher(keyValue)))
		{
			byte[] buffer = new byte[1024];
			int r;
			while ((r = sourceFile.read(buffer)) >= 0) {
				cos.write(buffer, 0, r);
			}
			//cos.close();
			//out.close();
			//is.close();
		}
	}
	/**
	 * 文件采用AES算法解密文件
	 * 
	 * @param file
	 *            已加密的文件 如c:/加密后文件.txt * @param destFile 解密后存放的文件名 如c:/
	 *            test/解密后文件.txt
	 */
	public static void decrypt(File sourceFile, File diminationFile,String keyValue)
			throws IOException, GeneralSecurityException {
		try(InputStream is = new FileInputStream(sourceFile);
				OutputStream out = new FileOutputStream(diminationFile))
		{
			decrypt(is,out,keyValue);
		}
	}
}
