/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.StringBaseOpt;

public class NumberBaseOpt {
    private static final String[] CNum = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CNum2 = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CBit = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};

    public static final char getNumByte(String szNum, int nBit) {
        int nPos;
        int sl = szNum.length();
        for (nPos = 0; nPos < sl && szNum.charAt(nPos) != '.'; ++nPos) {
        }
        nPos = nBit < 0 ? (nPos -= nBit) : nPos - nBit - 1;
        if (nPos < 0 || nPos >= sl) {
            return '0';
        }
        return szNum.charAt(nPos);
    }

    public static final String capitalization(String szNum) {
        int inl;
        int sl;
        StringBuilder resstr = new StringBuilder();
        String tmpstr = szNum.trim();
        int sp = 0;
        int dotpos = tmpstr.indexOf(46);
        if (dotpos != -1) {
            for (sl = tmpstr.length(); sl > 1 && tmpstr.charAt(sl - 1) == '0'; --sl) {
            }
            if (tmpstr.charAt(sl - 1) == '.') {
                --sl;
            }
            if (sl != tmpstr.length()) {
                tmpstr = tmpstr.substring(0, sl);
            }
        } else {
            dotpos = sl;
        }
        if (sl < 1) {
            return CNum[0];
        }
        if (tmpstr.charAt(0) == '-') {
            resstr.append("\u8d1f");
            sp = 1;
        }
        String integerNum = tmpstr.substring(sp, dotpos - sp);
        String decimalNum = "";
        if (dotpos + 1 < sl) {
            decimalNum = tmpstr.substring(dotpos + 1);
        }
        sl = integerNum.length();
        for (sp = 0; sp < sl && integerNum.charAt(sp) == '0'; ++sp) {
        }
        if (sp > 0) {
            integerNum = integerNum.substring(sp);
        }
        if ((inl = integerNum.length()) > 0) {
            int h = (inl - 1) % 4;
            sp = 0;
            boolean allzero = false;
            boolean preallzero = false;
            for (int j = (inl - 1) / 4 + 1; j > 0; --j) {
                int k = h;
                h = 3;
                boolean preiszero = allzero;
                allzero = true;
                while (k >= 0) {
                    if (integerNum.charAt(sp) == '0') {
                        preiszero = true;
                    } else {
                        allzero = false;
                        if (preiszero) {
                            resstr.append("\u96f6");
                        }
                        preiszero = false;
                        resstr.append(CNum[(byte)integerNum.charAt(sp) - 48] + CBit[k]);
                    }
                    --k;
                    ++sp;
                }
                if (j != 0 && j % 2 == 0) {
                    if (!allzero) {
                        resstr.append("\u4e07");
                    }
                } else if (!allzero || !preallzero) {
                    int repyi = j / 2;
                    for (int i = 0; i < repyi; ++i) {
                        resstr.append("\u4ebf");
                    }
                }
                preallzero = allzero;
            }
        } else {
            resstr.append("\u96f6");
        }
        int dnl = decimalNum.length();
        if (dnl > 0) {
            resstr.append("\u70b9");
            for (int i = 0; i < dnl; ++i) {
                resstr.append(CNum[(byte)decimalNum.charAt(i) - 48]);
            }
        }
        return resstr.toString();
    }

    public static final String uppercaseCN(String szNum) {
        StringBuilder resstr = new StringBuilder();
        String tmpstr = szNum.trim();
        int sl = tmpstr.length();
        if (sl < 1) {
            return CNum2[0];
        }
        for (int sp = 0; sp < sl; ++sp) {
            if (tmpstr.charAt(sp) >= '0' && tmpstr.charAt(sp) <= '9') {
                resstr.append(CNum2[tmpstr.charAt(sp) - 48]);
                continue;
            }
            resstr.append(tmpstr.charAt(sp));
        }
        return resstr.toString();
    }

    public static final String capitalization(String szNum, boolean isSimple) {
        if (isSimple) {
            return NumberBaseOpt.uppercaseCN(szNum);
        }
        return NumberBaseOpt.capitalization(szNum);
    }

    public static final Long parseLong(String sNum, Long errorValue) {
        Long lValue = null;
        try {
            lValue = Long.parseLong(sNum);
        }
        catch (NumberFormatException e) {
            lValue = errorValue;
        }
        return lValue;
    }

    public static final Long parseLong(String sNum) {
        return NumberBaseOpt.parseLong(sNum, null);
    }

    public static final Integer parseInteger(String sNum, Integer errorValue) {
        Integer lValue = null;
        try {
            lValue = Integer.parseInt(sNum);
        }
        catch (NumberFormatException e) {
            lValue = errorValue;
        }
        return lValue;
    }

    public static final Integer parseInteger(String sNum) {
        return NumberBaseOpt.parseInteger(sNum, null);
    }

    public static final Double parseDouble(String sNum, Double errorValue) {
        Double lValue = null;
        try {
            lValue = Double.parseDouble(sNum);
        }
        catch (NumberFormatException e) {
            lValue = errorValue;
        }
        return lValue;
    }

    public static final Double parseDouble(String sNum) {
        return NumberBaseOpt.parseDouble(sNum, null);
    }

    public static final Long castObjectToLong(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Double) {
            return ((Double)obj).longValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).longValue();
        }
        if (obj instanceof String) {
            return NumberBaseOpt.parseLong((String)obj, null);
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        return NumberBaseOpt.parseLong(StringBaseOpt.objectToString(obj), null);
    }

    public static final Integer castObjectToInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof String) {
            return NumberBaseOpt.parseInteger((String)obj, null);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return NumberBaseOpt.parseInteger(StringBaseOpt.objectToString(obj), null);
    }

    public static final Double castObjectToDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).doubleValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof String) {
            return NumberBaseOpt.parseDouble((String)obj, null);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return NumberBaseOpt.parseDouble(StringBaseOpt.objectToString(obj), null);
    }
}

