/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpExecutor {
    protected static final Log logger = LogFactory.getLog(FtpExecutor.class);

    public static boolean uploadFile(String url, int port, String username, String password, String path, String filename, InputStream input) {
        return FtpExecutor.uploadFile(url, port, username, null, password, path, filename, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(String url, int port, String username, Proxy proxy, String password, String path, String filename, InputStream input) {
        boolean success = false;
        FTPClient ftp = new FTPClient();
        try {
            if (proxy != null) {
                ftp.setProxy(proxy);
            }
            ftp.connect(url, port);
            ftp.login(username, password);
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                boolean bl = success;
                return bl;
            }
            ftp.changeWorkingDirectory(path);
            ftp.storeFile(filename, input);
            ftp.logout();
            success = true;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {}
            }
        }
        return success;
    }

    public static boolean downloadFile(String url, int port, String username, String password, String remotePath, String fileName, String localPath) {
        return FtpExecutor.downloadFile(url, port, username, password, null, remotePath, fileName, localPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String url, int port, String username, String password, Proxy proxy, String remotePath, String fileName, String localPath) {
        boolean success = false;
        FTPClient ftp = new FTPClient();
        try {
            FTPFile[] fs;
            if (proxy != null) {
                ftp.setProxy(proxy);
            }
            ftp.connect(url, port);
            ftp.login(username, password);
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                boolean bl = success;
                return bl;
            }
            ftp.changeWorkingDirectory(remotePath);
            for (FTPFile ff : fs = ftp.listFiles()) {
                if (!ff.getName().equals(fileName)) continue;
                File localFile = new File(localPath + "/" + ff.getName());
                try (FileOutputStream is = new FileOutputStream(localFile);){
                    ftp.retrieveFile(ff.getName(), (OutputStream)is);
                }
            }
            ftp.logout();
            success = true;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {}
            }
        }
        return success;
    }
}

