/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class AESSecurityUtils {
    public static Cipher createEncryptCipher(String keyValue) throws GeneralSecurityException {
        Key key = AESSecurityUtils.getKey(keyValue);
        Cipher encryptCipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        encryptCipher.init(1, key);
        return encryptCipher;
    }

    public static Cipher createDencryptCipher(String keyValue) throws GeneralSecurityException {
        Key key = AESSecurityUtils.getKey(keyValue);
        Cipher decryptCipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        decryptCipher.init(2, key);
        return decryptCipher;
    }

    private static Key getKey(String secret) throws GeneralSecurityException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128, new SecureRandom(secret.getBytes()));
        SecretKey secretKey = kgen.generateKey();
        return secretKey;
    }

    public static byte[] encrypt(byte[] arrB, String keyValue) throws GeneralSecurityException {
        return AESSecurityUtils.createEncryptCipher(keyValue).doFinal(arrB);
    }

    public static byte[] decrypt(byte[] arrB, String keyValue) throws Exception {
        return AESSecurityUtils.createDencryptCipher(keyValue).doFinal(arrB);
    }

    public static String encryptAndBase64(String str, String keyValue) {
        try {
            return new String(Base64.encodeBase64((byte[])AESSecurityUtils.encrypt(str.getBytes(), keyValue)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decryptBase64String(String str, String keyValue) {
        try {
            return new String(AESSecurityUtils.decrypt(Base64.decodeBase64((byte[])str.getBytes()), keyValue));
        }
        catch (Exception e) {
            return null;
        }
    }
}

